/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.templates.textmanipulation;

import org.eclipse.core.runtime.CoreException;
import org.epic.perleditor.templates.textmanipulation.TextBuffer;
import org.epic.perleditor.templates.textmanipulation.TextEdit;
import org.epic.perleditor.templates.textmanipulation.TextRange;

public abstract class SimpleTextEdit
extends TextEdit {
    private TextRange fRange;
    private String fText;

    public static SimpleTextEdit createReplace(int offset, int length, String text) {
        return new SimpleTextEditImpl(offset, length, text);
    }

    public static SimpleTextEdit createInsert(int offset, String text) {
        return new SimpleTextEditImpl(offset, 0, text);
    }

    public static SimpleTextEdit createDelete(int offset, int length) {
        return new SimpleTextEditImpl(offset, length, "");
    }

    protected SimpleTextEdit() {
        this(TextRange.UNDEFINED, "");
    }

    protected SimpleTextEdit(int offset, int length, String text) {
        this(new TextRange(offset, length), text);
    }

    protected SimpleTextEdit(TextRange range, String text) {
        this.fRange = range;
        this.fText = text;
    }

    public String getText() {
        return this.fText;
    }

    protected final void setText(String text) {
        this.fText = text;
    }

    protected void setTextRange(TextRange range) {
        this.fRange = range;
    }

    @Override
    public TextRange getTextRange() {
        return this.fRange;
    }

    @Override
    public final TextEdit perform(TextBuffer buffer) throws CoreException {
        String current = buffer.getContent(this.fRange.fOffset, this.fRange.fLength);
        buffer.replace(this.fRange, this.fText);
        return new SimpleTextEditImpl(this.fRange, current);
    }

    private static final class SimpleTextEditImpl
    extends SimpleTextEdit {
        protected SimpleTextEditImpl(TextRange range, String text) {
            super(range, text);
        }

        protected SimpleTextEditImpl(int offset, int length, String text) {
            super(offset, length, text);
        }

        @Override
        public TextEdit copy() {
            return new SimpleTextEditImpl(this.getTextRange().copy(), this.getText());
        }
    }
}

