/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Checkout;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.ResponseHandler;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.client.UpdatedHandler;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderSandbox;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.CheckoutOperation;
import org.eclipse.ui.IWorkbenchPart;

public class CheckoutToRemoteFolderOperation
extends CheckoutOperation {
    RemoteFolderSandbox sandbox;

    public static ICVSRemoteFolder checkoutRemoteFolder(IWorkbenchPart part, ICVSRemoteFolder folder, IProgressMonitor monitor) throws CVSException, InvocationTargetException, InterruptedException {
        CheckoutToRemoteFolderOperation op = new CheckoutToRemoteFolderOperation(part, folder);
        op.run(monitor);
        return op.getResultingFolder();
    }

    public CheckoutToRemoteFolderOperation(IWorkbenchPart part, ICVSRemoteFolder remoteFolder) {
        super(part, new ICVSRemoteFolder[]{remoteFolder});
    }

    protected IStatus checkout(ICVSRemoteFolder folder, IProgressMonitor monitor) throws CVSException {
        IPath sandboxPath = new Path(null, folder.getRepositoryRelativePath()).removeLastSegments(1);
        String pathString = sandboxPath.isEmpty() ? "" : sandboxPath.toString();
        this.sandbox = new RemoteFolderSandbox(null, folder.getRepository(), pathString, folder.getTag());
        return this.checkout(folder, (ICVSFolder)this.sandbox, monitor);
    }

    protected String getTaskName() {
        return NLS.bind((String)CVSUIMessages.CheckoutToRemoteFolderOperation_0, (Object[])new String[]{this.getRemoteFolders()[0].getName()});
    }

    protected IStatus checkout(ICVSRemoteFolder resource, ICVSFolder sandbox, IProgressMonitor pm) throws CVSException {
        ICVSRepositoryLocation repository = resource.getRepository();
        Session session = new Session(repository, sandbox);
        pm.beginTask(null, 100);
        Policy.checkCanceled(pm);
        session.open(Policy.subMonitorFor(pm, 5), false);
        try {
            ArrayList<Command.LocalOption> localOptions = new ArrayList<Command.LocalOption>();
            CVSTag tag = resource.getTag();
            if (tag == null) {
                tag = CVSTag.DEFAULT;
            }
            localOptions.add(Update.makeTagOption((CVSTag)tag));
            localOptions.add(Checkout.makeDirectoryNameOption((String)resource.getName()));
            IStatus status = new SandboxCheckout().execute(session, Command.NO_GLOBAL_OPTIONS, localOptions.toArray(new Command.LocalOption[localOptions.size()]), new String[]{resource.getRepositoryRelativePath()}, null, Policy.subMonitorFor(pm, 90));
            if (status.getCode() == -10) {
                IStatus iStatus = status;
                return iStatus;
            }
            IStatus iStatus = OK;
            return iStatus;
        }
        catch (CVSException e) {
            IStatus iStatus = e.getStatus();
            return iStatus;
        }
        finally {
            session.close();
            pm.done();
        }
    }

    public ICVSRemoteFolder getResultingFolder() throws CVSException {
        return (ICVSRemoteFolder)this.sandbox.getFolder(this.getRemoteFolders()[0].getName());
    }

    public class CreatedResponseHandler
    extends UpdatedHandler {
        public CreatedResponseHandler() {
            super(4);
        }

        protected void receiveTargetFile(Session session, ICVSFile mFile, String entryLine, Date modTime, boolean binary, boolean readOnly, boolean executable, IProgressMonitor monitor) throws CVSException {
            if (mFile instanceof RemoteFile) {
                try {
                    ((RemoteFile)mFile).aboutToReceiveContents(entryLine.getBytes());
                    super.receiveTargetFile(session, mFile, entryLine, modTime, binary, readOnly, executable, monitor);
                }
                finally {
                    ((RemoteFile)mFile).doneReceivingContents();
                }
            } else {
                super.receiveTargetFile(session, mFile, entryLine, modTime, binary, readOnly, executable, monitor);
            }
        }
    }

    public class SandboxCheckout
    extends Checkout {
        protected IStatus commandFinished(Session session, Command.GlobalOption[] globalOptions, Command.LocalOption[] localOptions, ICVSResource[] resources, IProgressMonitor monitor, IStatus status) throws CVSException {
            return status;
        }

        protected IStatus doExecute(Session session, Command.GlobalOption[] globalOptions, Command.LocalOption[] localOptions, String[] arguments, ICommandOutputListener listener, IProgressMonitor monitor) throws CVSException {
            CreatedResponseHandler newCreated = new CreatedResponseHandler();
            ResponseHandler oldCreated = session.getResponseHandler(newCreated.getResponseID());
            session.registerResponseHandler((ResponseHandler)newCreated);
            try {
                IStatus iStatus = super.doExecute(session, globalOptions, localOptions, arguments, listener, monitor);
                return iStatus;
            }
            finally {
                session.registerResponseHandler(oldCreated);
            }
        }
    }
}

