/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core.rule;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.rule.DefaultStatementFactory;
import zigen.plugin.db.core.rule.IStatementFactory;
import zigen.plugin.db.core.rule.mysql.MySQLStatementFactory;
import zigen.plugin.db.core.rule.oracle.OracleStatementFactory;
import zigen.plugin.db.core.rule.symfoware.SymfowareStatementFactory;

public abstract class AbstractStatementFactory
implements IStatementFactory {
    protected static String NULL = "null";
    protected boolean convertUnicode;
    private static Map map = new HashMap();

    public static IStatementFactory getFactory(IDBConfig config) {
        return AbstractStatementFactory.getFactory(config.getDriverName(), config.isConvertUnicode());
    }

    public static IStatementFactory getFactory(DatabaseMetaData objMet, boolean isConvertUnicode) {
        try {
            return AbstractStatementFactory.getFactory(objMet.getDriverName(), isConvertUnicode);
        }
        catch (SQLException sQLException) {
            throw new IllegalStateException("Faild get DriverName");
        }
    }

    public static IStatementFactory getFactory(String driverName, boolean isConvertUnicode) {
        IStatementFactory factory = null;
        String key = String.valueOf(driverName) + ":" + isConvertUnicode;
        if (map.containsKey(key)) {
            factory = (IStatementFactory)map.get(key);
        } else {
            switch (DBType.getType(driverName)) {
                case 1: {
                    factory = new OracleStatementFactory(isConvertUnicode);
                    break;
                }
                case 2: {
                    factory = new MySQLStatementFactory(isConvertUnicode);
                    break;
                }
                case 3: {
                    factory = new SymfowareStatementFactory(isConvertUnicode);
                    break;
                }
                default: {
                    factory = new DefaultStatementFactory(isConvertUnicode);
                }
            }
            map.put(key, factory);
        }
        return factory;
    }
}

