/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core.rule.postgresql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.rule.DefaultMappingFactory;
import zigen.plugin.db.core.rule.IMappingFactory;

public class PostgreSQLMappingFactory
extends DefaultMappingFactory
implements IMappingFactory {
    public PostgreSQLMappingFactory(boolean convertUnicode) {
        super(convertUnicode);
    }

    public Object getObject(ResultSet rs, int icol) throws SQLException {
        ResultSetMetaData rmd = rs.getMetaData();
        int type = rmd.getColumnType(icol);
        switch (type) {
            case 7: {
                return this.getFloat(rs, icol);
            }
        }
        return super.getObject(rs, icol);
    }

    public void setObject(PreparedStatement pst, int icol, TableColumn column, Object value) throws Exception {
        try {
            int type = column.getDataType();
            String str = String.valueOf(value);
            switch (type) {
                case 7: {
                    this.setFloat(pst, icol, str);
                    break;
                }
                default: {
                    super.setObject(pst, icol, column, value);
                    break;
                }
            }
        }
        catch (SQLException e) {
            DbPlugin.log(e);
            throw new Exception(e);
        }
    }

    protected String getFloat(ResultSet rs, int icol) throws SQLException {
        float value = rs.getFloat(icol);
        if (rs.wasNull()) {
            return this.nullSymbol;
        }
        return String.valueOf(value);
    }

    protected void setFloat(PreparedStatement pst, int icol, String str) throws SQLException {
        if (this.nullSymbol.equals(str)) {
            pst.setNull(icol, 6);
        } else {
            Float.parseFloat(str);
            pst.setFloat(icol, Float.parseFloat(str));
        }
    }
}

