/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.core.rule.sqlserver;

import zigen.plugin.db.core.SQLFormatter;
import zigen.plugin.db.core.SQLUtil;
import zigen.plugin.db.core.rule.DefaultSQLCreatorFactory;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;

public class SQLServerSQLCreatorFactory
extends DefaultSQLCreatorFactory {
    public SQLServerSQLCreatorFactory(ITable table) {
        super(table);
    }

    public String createSelect(String _condition, int limit) {
        StringBuffer sb = new StringBuffer();
        if (limit > 0) {
            sb.append("SELECT TOP ");
            sb.append(++limit);
        } else {
            sb.append("SELECT ");
        }
        sb.append(" * FROM ");
        sb.append(this.getTableNameWithSchemaForSQL(this.table, this.isVisibleSchemaName));
        String[] conditions = SQLFormatter.splitOrderCause(_condition);
        String condition = conditions[0];
        String orderBy = conditions[1];
        if (condition != null && !"".equals(condition.trim())) {
            sb.append(" WHERE " + condition);
        }
        if (orderBy != null && !"".equals(orderBy)) {
            sb.append(" " + orderBy);
        }
        return sb.toString();
    }

    public String[] createAddColumnDDL(Column column) {
        return null;
    }

    public String createCommentOnColumnDDL(Column column) {
        return null;
    }

    public String createCommentOnTableDDL(String commnets) {
        return null;
    }

    public String[] createDropColumnDDL(Column column, boolean cascadeConstraints) {
        return null;
    }

    public String[] createModifyColumnDDL(Column from, Column to) {
        return null;
    }

    public String createRenameColumnDDL(Column from, Column to) {
        return null;
    }

    public String createRenameTableDDL(String newTableName) {
        StringBuffer sb = new StringBuffer();
        sb.append("sp_rename");
        sb.append(" '" + SQLUtil.encodeQuotation(this.table.getSqlTableName()) + "'");
        sb.append(", '" + SQLUtil.encodeQuotation(newTableName) + "'");
        return sb.toString();
    }

    public boolean supportsModifyColumnSize(String columnType) {
        return false;
    }

    public boolean supportsModifyColumnType() {
        return false;
    }

    public boolean supportsRemarks() {
        return false;
    }

    public boolean supportsDropColumnCascadeConstraints() {
        return false;
    }

    public boolean supportsRollbackDDL() {
        return true;
    }
}

