/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.diff;

import java.sql.Connection;
import java.util.Iterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.Transaction;
import zigen.plugin.db.diff.DDLDiffEditorInput;
import zigen.plugin.db.diff.SourceDDL;
import zigen.plugin.db.diff.SourceDDLDiff;
import zigen.plugin.db.ext.oracle.internal.OracleSourceDetailInfo;
import zigen.plugin.db.ext.oracle.internal.OracleSourceDetailSearcher;
import zigen.plugin.db.ui.internal.OracleSource;

public class DDLDiffForSourceAction
extends Action
implements Runnable {
    private StructuredViewer viewer = null;
    private OracleSource left = null;
    private OracleSource right = null;

    public DDLDiffForSourceAction(StructuredViewer viewer) {
        this.viewer = viewer;
        this.setText("&Diff DDL");
    }

    public void run() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        try {
            int index = 0;
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof OracleSource)) continue;
                OracleSource s = (OracleSource)obj;
                if (index == 0) {
                    this.left = s;
                    ++index;
                    continue;
                }
                if (index != 1) break;
                this.right = s;
                ++index;
            }
            if (index == 2) {
                this.showDDLDiff();
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }

    private void showDDLDiff() throws Exception {
        SourceDDLDiff diff = new SourceDDLDiff(new SourceDDL(this.left), new SourceDDL(this.right));
        DDLDiffEditorInput input = new DDLDiffEditorInput(new SourceDDLDiff[]{diff}, true);
        IWorkbenchPage page = DbPlugin.getDefault().getPage();
        IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)"zigen.plugin.db.diff.DDLDiffEditor", (boolean)true);
    }

    protected OracleSourceDetailInfo getOracleSourceDetailInfo(OracleSource source) {
        OracleSourceDetailInfo sourceDetail = null;
        try {
            Connection con = Transaction.getInstance(source.getDbConfig()).getConnection();
            String owner = source.getOracleSourceInfo().getOwner();
            String type = source.getOracleSourceInfo().getType();
            String name = source.getOracleSourceInfo().getName();
            sourceDetail = OracleSourceDetailSearcher.execute(con, owner, name, type, false);
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
        return sourceDetail;
    }
}

