/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.diff;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import zigen.plugin.db.diff.IDDLDiff;
import zigen.plugin.db.diff.Messages;
import zigen.plugin.db.ui.internal.Folder;
import zigen.plugin.db.ui.internal.Root;
import zigen.plugin.db.ui.internal.Table;
import zigen.plugin.db.ui.internal.TreeLeaf;
import zigen.plugin.db.ui.internal.TreeNode;

public class DiffContentProvider
implements ITreeContentProvider {
    public static final String FOLDER_INCLUDE_ONLY_TARGET = Messages.getString("DiffContentProvider.0");
    public static final String FOLDER_INCLUDE_ONLY_ORIGIN = Messages.getString("DiffContentProvider.1");
    public static final String FOLDER_BOTH_DIFFERENCE = Messages.getString("DiffContentProvider.2");
    public static final String FOLDER_BOTH_SAME = Messages.getString("DiffContentProvider.3");
    private Root invisibleRoot;
    private TreeViewer viewer;
    Table[] tables = null;

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        if (newInput != null) {
            this.invisibleRoot = new Root("invisible", true);
            Folder folder1 = new Folder(FOLDER_INCLUDE_ONLY_TARGET);
            Folder folder2 = new Folder(FOLDER_INCLUDE_ONLY_ORIGIN);
            Folder folder3 = new Folder(FOLDER_BOTH_DIFFERENCE);
            Folder folder4 = new Folder(FOLDER_BOTH_SAME);
            this.invisibleRoot.addChild(folder1);
            this.invisibleRoot.addChild(folder2);
            this.invisibleRoot.addChild(folder3);
            this.invisibleRoot.addChild(folder4);
            this.viewer = (TreeViewer)v;
            if (newInput instanceof IDDLDiff[]) {
                IDDLDiff[] diffs = (IDDLDiff[])newInput;
                int cnt1 = 0;
                int cnt2 = 0;
                int cnt3 = 0;
                int cnt4 = 0;
                int i = 0;
                while (i < diffs.length) {
                    IDDLDiff diff = diffs[i];
                    switch (diff.getResultType()) {
                        case 20: {
                            folder1.addChild((TreeLeaf)((Object)diff));
                            ++cnt1;
                            break;
                        }
                        case 10: {
                            folder2.addChild((TreeLeaf)((Object)diff));
                            ++cnt2;
                            break;
                        }
                        case 30: {
                            folder3.addChild((TreeLeaf)((Object)diff));
                            ++cnt3;
                            break;
                        }
                        case 40: {
                            folder4.addChild((TreeLeaf)((Object)diff));
                            ++cnt4;
                            break;
                        }
                        default: {
                            this.invisibleRoot.addChild((TreeLeaf)((Object)diff));
                        }
                    }
                    ++i;
                }
                folder1.setName(String.valueOf(FOLDER_INCLUDE_ONLY_TARGET) + " (" + cnt1 + ")");
                folder2.setName(String.valueOf(FOLDER_INCLUDE_ONLY_ORIGIN) + " (" + cnt2 + ")");
                folder3.setName(String.valueOf(FOLDER_BOTH_DIFFERENCE) + " (" + cnt3 + ")");
                folder4.setName(String.valueOf(FOLDER_BOTH_SAME) + " (" + cnt4 + ")");
            }
        }
    }

    public void dispose() {
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(this.invisibleRoot);
    }

    public Object getParent(Object element) {
        if (element instanceof TreeLeaf) {
            return ((TreeLeaf)element).getParent();
        }
        return null;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TreeNode) {
            return ((TreeNode)parentElement).getChildrens();
        }
        return new Object[0];
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TreeNode) {
            return ((TreeNode)element).hasChildren();
        }
        return false;
    }

    public Root getInvisibleRoot() {
        return this.invisibleRoot;
    }
}

