/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.parser.util;

import org.eclipse.jface.text.IDocument;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.core.StringUtil;

public class CurrentSql {
    private String sql;
    private String offsetSql;
    private int begin;
    private int offset;
    private String demiliter;

    public CurrentSql(IDocument doc, int offset, String demiliter) {
        this.offset = offset;
        this.demiliter = "/".equals(demiliter) ? String.valueOf(DbPluginConstant.LINE_SEP) + demiliter + DbPluginConstant.LINE_SEP : String.valueOf(demiliter) + DbPluginConstant.LINE_SEP;
        this.parse(doc);
    }

    public String getSql() {
        return this.sql;
    }

    public String getOffsetSql() {
        return this.offsetSql == null ? "" : this.offsetSql;
    }

    private void parse(IDocument doc) {
        try {
            String text = doc.get();
            if (text == null || "".equals(text) || this.offset < 0) {
                return;
            }
            String cText = text.substring(0, this.offset);
            String nText = StringUtil.convertLineSep(cText, DbPluginConstant.LINE_SEP);
            int x = nText.length() - cText.length();
            if (x != 0) {
                this.offset += x;
            }
            text = StringUtil.convertLineSep(doc.get(), DbPluginConstant.LINE_SEP);
            int len = text.length();
            int startSlash = this.findStartSlash(text);
            int endSlash = this.findEndSlash(text);
            startSlash = startSlash == -1 ? 0 : startSlash;
            endSlash = endSlash == -1 ? len : endSlash;
            int p = 0;
            while (CurrentSql.isIntoQuot(text, startSlash)) {
                p = startSlash - 1;
                int n = startSlash = (p = text.lastIndexOf(this.demiliter, p)) == -1 ? 0 : p;
            }
            while (CurrentSql.isIntoQuot(text, endSlash)) {
                p = endSlash + 1;
                int n = endSlash = (p = text.indexOf(this.demiliter, p)) == -1 ? len : p;
            }
            this.sql = this.trimSeparator(text.substring(startSlash, endSlash), startSlash);
            this.offsetSql = this.trimSeparator(text.substring(startSlash, this.offset), startSlash);
        }
        catch (Exception e) {
            DbPlugin.log(e);
        }
    }

    private int findStartSlash(String str) {
        int i = str.lastIndexOf(this.demiliter, this.offset - this.demiliter.length());
        if (i > 1 && str.startsWith("*/", i - 1)) {
            i = str.lastIndexOf(this.demiliter, i - 1);
        }
        return i;
    }

    private int findEndSlash(String str) {
        int i = str.indexOf(this.demiliter, this.offset - this.demiliter.length() + 1);
        if (i > 1 && str.startsWith("*/", i - 1)) {
            i = str.indexOf(this.demiliter, i + 1);
        }
        return i;
    }

    private String trimSeparator(String executeSql, int startSlash) {
        int start = 0;
        int end = executeSql.length();
        int sepLen = this.demiliter.length();
        if (executeSql.startsWith(this.demiliter)) {
            start += sepLen;
        }
        this.begin = startSlash + start;
        return executeSql.substring(start, end);
    }

    private static boolean isIntoQuot(String str, int pos) {
        int len = str.length();
        boolean intoQuotFlag = false;
        int startQuot = Integer.MAX_VALUE;
        int endQuot = -1;
        int i = 0;
        while (i < len) {
            block8: {
                block7: {
                    char c = str.charAt(i);
                    if (c != '\'') break block7;
                    if (intoQuotFlag && i + 1 < len && '\'' == str.charAt(i + 1)) break block8;
                    if (intoQuotFlag ^= true) {
                        startQuot = i;
                    } else {
                        endQuot = i;
                    }
                }
                if (!intoQuotFlag && startQuot <= pos && pos < endQuot) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public int getBegin() {
        return this.begin;
    }

    public int getEnd() {
        return this.begin + this.getLength();
    }

    public int getLength() {
        return this.sql != null ? this.sql.length() : 0;
    }
}

