/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.bookmark;

import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.DbPluginConstant;
import zigen.plugin.db.DefaultXmlManager;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.ui.internal.Bookmark;
import zigen.plugin.db.ui.internal.BookmarkRoot;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.TreeLeaf;
import zigen.plugin.db.ui.internal.TreeNode;

public class BookmarkManager
extends DefaultXmlManager {
    private BookmarkRoot bookmarkRoot = this.load();

    public void setBookmarkRoot(BookmarkRoot bookmarkRoot) {
        this.bookmarkRoot = bookmarkRoot;
    }

    public BookmarkRoot getBookmarkRoot() {
        return this.bookmarkRoot;
    }

    public BookmarkManager(IPath path) {
        super(path, "bookmark.xml");
        if (this.bookmarkRoot == null) {
            this.bookmarkRoot = new BookmarkRoot();
        }
    }

    public BookmarkRoot load() {
        try {
            Object obj = super.loadXml();
            if (obj instanceof BookmarkRoot) {
                return (BookmarkRoot)obj;
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
        return null;
    }

    public void save() {
        try {
            this.removeNode();
            super.saveXml(this.bookmarkRoot);
        }
        catch (IOException e) {
            DbPlugin.log(e);
        }
    }

    private void removeNode() {
        try {
            this.bookmarkRoot.setParent(null);
            this.removeColumnNode(this.bookmarkRoot);
        }
        catch (Exception e) {
            DbPlugin.log(e);
        }
    }

    private void removeColumnNode(TreeNode node) {
        TreeLeaf[] leafs = node.getChildrens();
        int i = 0;
        while (i < leafs.length) {
            TreeLeaf leaf = leafs[i];
            if (leaf instanceof Bookmark) {
                Bookmark bm = (Bookmark)leaf;
                bm.removeChildAll();
                TableColumn tColumn = new TableColumn();
                tColumn.setColumnName(DbPluginConstant.TREE_LEAF_LOADING);
                bm.addChild(new Column(tColumn));
                bm.setExpanded(false);
            } else if (leaf instanceof TreeNode) {
                this.removeColumnNode((TreeNode)leaf);
            }
            ++i;
        }
    }
}

