/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.ui.internal.ITable;

public class TableViewEditorInput
implements IEditorInput {
    private String tooltip;
    private String name;
    private IDBConfig config;
    private String schemaName;
    private ITable table;

    public TableViewEditorInput(IDBConfig config, ITable table) {
        this.config = config;
        this.schemaName = table.getSchemaName();
        this.table = table;
        this.name = table.getName();
        this.tooltip = String.valueOf(table.getName()) + " [" + config.getUserId() + " : " + config.getDbName() + "]";
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(config.getDbName());
        sb.append("] ");
        sb.append(table.getSqlTableName());
        if (table.getRemarks() != null && !"".equals(table.getRemarks().trim())) {
            sb.append(" [");
            sb.append(table.getRemarks());
            sb.append("]");
        }
        this.tooltip = sb.toString();
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.tooltip;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public boolean equals(Object o) {
        boolean b = false;
        if (o == this) {
            return true;
        }
        if (o instanceof TableViewEditorInput) {
            TableViewEditorInput input = (TableViewEditorInput)o;
            if (this.schemaName != null && input.schemaName != null) {
                b = this.config.equals(input.config) && this.schemaName.equals(input.schemaName) && this.name.equals(input.name) && this.table.getClass() == input.table.getClass();
                return b;
            }
            if (this.schemaName == null && input.schemaName == null) {
                b = this.config.equals(input.config) && this.name.equals(input.name);
                return b;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public IDBConfig getConfig() {
        return this.config;
    }

    public ITable getTable() {
        return this.table;
    }

    public void setToolTipText(String tooltip) {
        this.tooltip = tooltip;
    }
}

