/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors.event;

import java.sql.Connection;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.TableColumn;
import zigen.plugin.db.core.TableElement;
import zigen.plugin.db.core.TableElementSearcher;
import zigen.plugin.db.core.TableNewElement;
import zigen.plugin.db.core.TransactionForTableEditor;
import zigen.plugin.db.core.rule.AbstractValidatorFactory;
import zigen.plugin.db.core.rule.IValidatorFactory;
import zigen.plugin.db.ui.actions.InsertRecordAction;
import zigen.plugin.db.ui.editors.ITableViewEditor;
import zigen.plugin.db.ui.editors.TextCellEditor;
import zigen.plugin.db.ui.editors.event.PasteRecordMonitor;
import zigen.plugin.db.ui.editors.exceptions.UpdateException;
import zigen.plugin.db.ui.editors.exceptions.ZeroUpdateException;
import zigen.plugin.db.ui.editors.internal.RecordUpdateThread;
import zigen.plugin.db.ui.editors.internal.TableViewerManager;
import zigen.plugin.db.ui.internal.ITable;

public class TableKeyEventHandler {
    protected ITableViewEditor editor;
    protected TableViewer viewer;
    protected Table table;
    protected IDBConfig config;

    public TableKeyEventHandler(ITableViewEditor editor) {
        this.editor = editor;
        this.viewer = editor.getViewer();
        this.table = editor.getViewer().getTable();
        this.config = editor.getDBConfig();
    }

    public int getSelectedRow() {
        return this.table.getSelectionIndex();
    }

    public void selectRow(int index) {
        this.table.select(index);
    }

    public int getSelectedCellEditorIndex() {
        int defaultIndex = 0;
        CellEditor[] editors = this.viewer.getCellEditors();
        if (editors == null) {
            return -1;
        }
        int i = 0;
        while (i < editors.length) {
            if (editors[i] != null && editors[i].isActivated()) {
                return i;
            }
            ++i;
        }
        return defaultIndex;
    }

    public int getEditableNextColumn(int cuurentCol) {
        int nextCol;
        ICellModifier modifier = this.viewer.getCellModifier();
        int n = nextCol = cuurentCol < this.table.getColumnCount() - 1 ? cuurentCol + 1 : 1;
        if (modifier.canModify((Object)this.getHeaderTableElement(), String.valueOf(nextCol))) {
            return nextCol;
        }
        return this.getEditableNextColumn(nextCol);
    }

    public int getEditablePrevColumn(int CurrentCol) {
        int nextCol;
        ICellModifier modifier = this.viewer.getCellModifier();
        int n = nextCol = CurrentCol == 1 ? this.table.getColumnCount() - 1 : CurrentCol - 1;
        if (modifier.canModify((Object)this.getHeaderTableElement(), String.valueOf(nextCol))) {
            return nextCol;
        }
        return this.getEditablePrevColumn(nextCol);
    }

    public TableElement getHeaderTableElement() {
        Object obj = this.viewer.getInput();
        if (obj instanceof TableElement[]) {
            TableElement[] elements = (TableElement[])obj;
            if (elements.length > 0) {
                return elements[0];
            }
            return null;
        }
        return null;
    }

    public void editTableElement(int rowIndex, int columnIndex) {
        Object element = this.viewer.getElementAt(rowIndex);
        if (element != null) {
            if (columnIndex == 1) {
                this.table.showColumn(this.table.getColumn(0));
            } else {
                this.table.showColumn(this.table.getColumn(columnIndex));
            }
            this.viewer.editElement(element, columnIndex);
        }
    }

    public void updateColumn(TableElement element, int col, Object newValue) {
        element.updateItems(col - 1, newValue);
        this.viewer.update((Object)element, null);
        this.columnsPack();
    }

    public void setMessage(String msg) {
        DbPlugin.getDefault().showWarningMessage(msg);
    }

    private void columnsPack() {
    }

    public boolean validate(int row, int col) {
        Object oldValue;
        TableElement element = (TableElement)this.viewer.getElementAt(row);
        Object newValue = null;
        CellEditor editor = this.viewer.getCellEditors()[col];
        if (editor == null) {
            throw new IllegalStateException("CellEditor is not set.");
        }
        if (editor instanceof TextCellEditor) {
            TextCellEditor tce = (TextCellEditor)editor;
            newValue = tce.getInputValue();
            tce.getColumnIndex();
        }
        if (!(oldValue = element.getItems()[col - 1]).equals(newValue)) {
            String msg = editor.getErrorMessage();
            if (msg == null) {
                this.updateColumn(element, col, newValue);
                return true;
            }
            this.viewer.cancelEditing();
            this.updateColumn(element, col, newValue);
            this.setMessage(msg);
            this.editTableElement(row, col);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean validateAll() {
        try {
            int row = this.getSelectedRow();
            if (row == -1) {
                return true;
            }
            TableElement element = (TableElement)this.viewer.getElementAt(row);
            IDBConfig config = element.getTable().getDbConfig();
            IValidatorFactory factory = AbstractValidatorFactory.getFactory(config);
            TableColumn[] columns = element.getColumns();
            String msg = null;
            int col = 0;
            while (true) {
                if (col >= columns.length) {
                    return true;
                }
                Object[] items = element.getItems();
                msg = factory.validate(columns[col], items[col]);
                if (msg != null) {
                    this.viewer.cancelEditing();
                    this.setMessage(msg);
                    this.editTableElement(row, col + 1);
                    return false;
                }
                ++col;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            DbPlugin.getDefault().showErrorDialog(e);
        }
        return true;
    }

    public boolean updateDataBase(TableElement element) throws Exception {
        block10: {
            Display display;
            block7: {
                block8: {
                    block9: {
                        PasteRecordMonitor.isPasting();
                        display = Display.getDefault();
                        element.setUpdatedDataBase(false);
                        if (!element.isNew()) break block7;
                        if (!this.validateAll()) break block8;
                        if (!this.hasSameRecord(element)) break block9;
                        return false;
                    }
                    display.syncExec((Runnable)new RecordUpdateThread(this.editor, element));
                    this.columnsPack();
                    break block10;
                }
                return false;
            }
            if (!element.isModify()) break block10;
            if (this.validateAll()) {
                display.syncExec((Runnable)new RecordUpdateThread(this.editor, element));
                break block10;
            }
            return false;
        }
        try {
            this.viewer.getTable().select(this.getSelectedRow());
            this.viewer.getControl().notifyListeners(13, null);
            element.setUpdatedDataBase(true);
            return true;
        }
        catch (ZeroUpdateException zeroUpdateException) {
            return false;
        }
        catch (UpdateException updateException) {
            return false;
        }
    }

    public boolean hasSameRecord(TableElement element) throws Exception {
        Connection con = TransactionForTableEditor.getInstance(this.config).getConnection();
        TableElement registedElem = TableElementSearcher.findElement(con, element, true);
        return registedElem != null;
    }

    public void createNewRecord() {
        DbPlugin.getDefault().getPreferenceStore().getString("PreferencePage.NullSymbol");
        TableElement elem = this.getHeaderTableElement();
        ITable tbl = elem.getTable();
        int count = this.table.getItems().length;
        Object[] items = new Object[elem.getColumns().length];
        int i = 0;
        while (i < items.length) {
            TableColumn column = elem.getColumns()[i];
            items[i] = InsertRecordAction.getDefaultValue(column);
            ++i;
        }
        TableNewElement newElement = new TableNewElement(tbl, count + 1, elem.getColumns(), items, elem.getUniqueColumns());
        TableViewerManager.insert(this.viewer, newElement);
        this.editTableElement(count, 1);
    }

    public void removeRecord(TableElement element) {
        TableViewerManager.remove(this.viewer, element);
    }

    public void dispose() {
    }
}

