/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.editors.internal.action;

import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.viewers.IStructuredSelection;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.core.IDBConfig;
import zigen.plugin.db.core.rule.AbstractSQLCreatorFactory;
import zigen.plugin.db.core.rule.ISQLCreatorFactory;
import zigen.plugin.db.ui.actions.TableViewEditorAction;
import zigen.plugin.db.ui.editors.TableViewEditorFor31;
import zigen.plugin.db.ui.editors.internal.action.Messages;
import zigen.plugin.db.ui.editors.internal.thread.DropColumnThread;
import zigen.plugin.db.ui.internal.Column;
import zigen.plugin.db.ui.internal.ITable;

public class DeleteColumnAction
extends TableViewEditorAction {
    public DeleteColumnAction() {
        this.setText(Messages.getString("DeleteColumnAction.0"));
        this.setToolTipText(Messages.getString("DeleteColumnAction.1"));
        this.setImageDescriptor("IMG_TOOL_DELETE");
    }

    public void run() {
        try {
            TableViewEditorFor31 tEditor;
            IStructuredSelection selection;
            Object obj;
            if (this.editor instanceof TableViewEditorFor31 && (obj = (selection = (IStructuredSelection)(tEditor = (TableViewEditorFor31)this.editor).getTableDefineEditor().getDefineViewer().getSelection()).getFirstElement()) instanceof Column) {
                Column col = (Column)obj;
                IDBConfig config = tEditor.getDBConfig();
                ITable table = tEditor.getTableNode();
                ISQLCreatorFactory factory = AbstractSQLCreatorFactory.getFactory(config, table);
                String msg = Messages.getString("DeleteColumnAction.2");
                if (factory.supportsDropColumnCascadeConstraints()) {
                    String opt = Messages.getString("DeleteColumnAction.3");
                    MessageDialogWithToggle dialog = DbPlugin.getDefault().confirmDialogWithToggle(msg, opt, true);
                    if (dialog.getReturnCode() == 2) {
                        DropColumnThread thread = new DropColumnThread(table, col, dialog.getToggleState());
                        thread.run();
                    }
                } else if (DbPlugin.getDefault().confirmDialog(msg)) {
                    DropColumnThread thread = new DropColumnThread(table, col, false);
                    thread.run();
                }
            }
        }
        catch (Exception e) {
            DbPlugin.getDefault().showErrorDialog(e);
        }
    }
}

