/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.PluginSettingsManager;
import zigen.plugin.db.ui.actions.SQLSourceViewerAction;
import zigen.plugin.db.ui.views.Messages;
import zigen.plugin.db.ui.views.internal.SQLSourceViewer;

public class FormatModeAction
extends SQLSourceViewerAction
implements IMenuCreator {
    protected PluginSettingsManager pluginMgr = DbPlugin.getDefault().getPluginSettingsManager();
    public static final String TEXT_MANUAL = Messages.getString("FormatModeAction.0");
    public static final String TEXT_AUTO = Messages.getString("FormatModeAction.1");
    Menu fMenu;
    Action autoAction;
    Action manualAction;
    boolean isAutoFormat = false;

    public FormatModeAction(SQLSourceViewer viewer) {
        super(viewer, "Format Mode", 4);
        this.setMenuCreator(this);
        this.isAutoFormat = this.getLastAutoFormatMode();
        if (viewer == null) {
            this.setFormatMode(this.isAutoFormat);
        }
    }

    public void setSQLSourceViewer(SQLSourceViewer viewer) {
        this.fSQLSourceViewer = viewer;
        this.setFormatMode(this.isAutoFormat);
    }

    public void run() {
        this.fSQLSourceViewer.doOperation(1001);
    }

    public void dispose() {
    }

    public Menu getMenu(Control parent) {
        this.fMenu = new Menu(parent);
        this.autoAction = new Action(TEXT_AUTO, 2){

            public void run() {
                if (!FormatModeAction.this.isAutoFormat) {
                    FormatModeAction.this.isAutoFormat = !FormatModeAction.this.isAutoFormat;
                    FormatModeAction.this.setFormatMode(FormatModeAction.this.isAutoFormat);
                }
            }
        };
        this.autoAction.setChecked(this.isAutoFormat);
        this.autoAction.setImageDescriptor(DbPlugin.getDefault().getImageDescriptor("format2.gif"));
        this.addActionToMenu(this.fMenu, (IAction)this.autoAction);
        this.manualAction = new Action(TEXT_MANUAL, 2){

            public void run() {
                if (FormatModeAction.this.isAutoFormat) {
                    FormatModeAction.this.isAutoFormat = !FormatModeAction.this.isAutoFormat;
                    FormatModeAction.this.setFormatMode(FormatModeAction.this.isAutoFormat);
                }
            }
        };
        this.manualAction.setChecked(!this.isAutoFormat);
        this.manualAction.setImageDescriptor(DbPlugin.getDefault().getImageDescriptor("format.gif"));
        this.addActionToMenu(this.fMenu, (IAction)this.manualAction);
        return this.fMenu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    protected void addActionToMenu(Menu parent, IAction action) {
        ActionContributionItem item = new ActionContributionItem(action);
        item.fill(parent, -1);
    }

    public final void setFormatMode(boolean b) {
        this.isAutoFormat = b;
        if (!this.isAutoFormat) {
            this.setToolTipText(TEXT_MANUAL);
            this.setImageDescriptor(DbPlugin.getDefault().getImageDescriptor("format.gif"));
        } else {
            this.setToolTipText(TEXT_AUTO);
            this.setImageDescriptor(DbPlugin.getDefault().getImageDescriptor("format2.gif"));
        }
        if (this.fSQLSourceViewer != null) {
            this.fSQLSourceViewer.setFormatPreExecute(b);
        }
        this.setLastAutoFormatMode(b);
    }

    public boolean isAutoFormat() {
        return this.isAutoFormat;
    }

    protected boolean getLastAutoFormatMode() {
        Object obj = this.pluginMgr.getValue("KEY_AUTO_FORMAT");
        if (obj != null) {
            return (Boolean)obj;
        }
        return false;
    }

    protected void setLastAutoFormatMode(boolean auto) {
        this.pluginMgr.setValue("KEY_AUTO_FORMAT", new Boolean(auto));
    }
}

