/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.views;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.IStatusChangeListener;
import zigen.plugin.db.ImageCacher;
import zigen.plugin.db.PluginSettingsManager;
import zigen.plugin.db.core.SQLHistory;
import zigen.plugin.db.core.SQLHistoryManager;
import zigen.plugin.db.ui.actions.DeleteHistoryAction;
import zigen.plugin.db.ui.editors.event.TextSelectionListener;
import zigen.plugin.db.ui.internal.History;
import zigen.plugin.db.ui.internal.HistoryFolder;
import zigen.plugin.db.ui.internal.TreeNode;
import zigen.plugin.db.ui.util.LineNumberRulerColumnUtil;
import zigen.plugin.db.ui.views.HistoryContentProvider;
import zigen.plugin.db.ui.views.HistoryViewSorter;
import zigen.plugin.db.ui.views.HistoryViewTableFilter;
import zigen.plugin.db.ui.views.Messages;
import zigen.plugin.db.ui.views.SQLExecuteView;
import zigen.plugin.db.ui.views.TreeLabelProvider;
import zigen.plugin.db.ui.views.internal.ColorManager;
import zigen.plugin.db.ui.views.internal.SQLCodeConfiguration;
import zigen.plugin.db.ui.views.internal.SQLDocument;
import zigen.plugin.db.ui.views.internal.SQLSourceViewer;

public class HistoryView
extends ViewPart
implements IStatusChangeListener {
    protected SQLHistoryManager mgr = DbPlugin.getDefault().getHistoryManager();
    protected PluginSettingsManager settringMgr = DbPlugin.getDefault().getPluginSettingsManager();
    protected TreeViewer viewer;
    protected String lastSecondaryId;
    SashForm sash;
    Combo filterComb;
    Button searchBtn;
    List filterHistory;
    int maxSize = 20;
    SQLSourceViewer sourceViewer;
    IDocument doc;
    DeleteHistoryAction removeHistoryAction;
    protected ColorManager colorManager = new ColorManager();
    ImageCacher ic = ImageCacher.getInstance();

    public TreeViewer getTreeView() {
        return this.viewer;
    }

    public void createPartControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        main.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginHeight = 2;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 2;
        main.setLayout((Layout)gridLayout);
        this.createFilterBar(main);
        this.createTreeArea(main);
    }

    protected void createTreeArea(Composite parent) {
        Composite body = new Composite(parent, 0);
        body.setLayoutData((Object)new GridData(1808));
        body.setLayout((Layout)new FillLayout());
        this.sash = new SashForm(body, 512);
        this.viewer = new TreeViewer((Composite)this.sash, 770);
        HistoryContentProvider hcp = new HistoryContentProvider();
        this.viewer.setContentProvider((IContentProvider)hcp);
        this.viewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.viewer.setSorter((ViewerSorter)new HistoryViewSorter());
        this.viewer.setInput((Object)this.getViewSite());
        HistoryFolder folder = hcp.getHistoryHolder(Calendar.getInstance().getTime());
        this.viewer.expandToLevel((Object)folder, 1);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                HistoryView.this.selectionChangeHandler(event);
            }
        });
        CompositeRuler ruler = new CompositeRuler();
        LineNumberRulerColumn rulerCol = new LineNumberRulerColumn();
        LineNumberRulerColumnUtil.changeColor(this.colorManager, rulerCol);
        ruler.addDecorator(0, (IVerticalRulerColumn)rulerCol);
        ruler.setFont(DbPlugin.getSmallFont());
        this.sourceViewer = new SQLSourceViewer((Composite)this.sash, (IVerticalRuler)ruler, null, false, 2818);
        this.sourceViewer.getTextWidget().setFont(DbPlugin.getSmallFont());
        SQLCodeConfiguration sqlConfiguration = new SQLCodeConfiguration(this.colorManager);
        this.sourceViewer.configure(sqlConfiguration);
        this.doc = new SQLDocument();
        this.sourceViewer.setDocument(this.doc);
        this.sourceViewer.setEditable(false);
        this.sash.setWeights(new int[]{50, 50});
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        DbPlugin.addStatusChangeListener(this);
        this.hookDoubleClickAction();
        this.makeActions();
        this.hookContextMenu();
    }

    void selectionChangeHandler(SelectionChangedEvent event) {
        Object element;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.size() == 1) {
            element = selection.getFirstElement();
            if (element instanceof HistoryFolder) {
                this.doc = new SQLDocument();
                this.sourceViewer.setDocument(this.doc);
            } else if (element instanceof History) {
                History h = (History)element;
                this.doc.set(this.mgr.loadContents(h.getSqlHistory()));
            }
        }
        if (selection.size() > 0) {
            element = selection.getFirstElement();
            if (element instanceof HistoryFolder || element instanceof History) {
                this.removeHistoryAction.setEnabled(true);
            } else {
                this.removeHistoryAction.setEnabled(false);
            }
        } else {
            this.removeHistoryAction.setEnabled(false);
        }
        this.setGlobalAction(selection);
    }

    void setGlobalAction(IStructuredSelection selection) {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.clearGlobalActionHandlers();
        bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.removeHistoryAction);
        bars.updateActionBars();
    }

    protected void createFilterBar(Composite parent) {
        Composite tool = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        tool.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.makeColumnsEqualWidth = false;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        tool.setLayout((Layout)gridLayout);
        Label label1 = new Label(tool, 0);
        gridData = new GridData(4);
        label1.setLayoutData((Object)gridData);
        label1.setText(" Filter:");
        this.filterComb = new Combo(tool, 0);
        this.filterComb.setVisibleItemCount(20);
        this.filterComb.setLayoutData((Object)new GridData(768));
        this.filterComb.setText("");
        this.filterComb.addFocusListener((FocusListener)new TextSelectionListener());
        this.filterComb.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    e.doit = false;
                    HistoryView.this.filter(HistoryView.this.filterComb.getText());
                }
            }
        });
        this.searchBtn = new Button(tool, 0);
        this.searchBtn.setText(Messages.getString("HistoryView.2"));
        this.searchBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HistoryView.this.filter(HistoryView.this.filterComb.getText());
            }
        });
        this.filterHistory = this.loadFilterHistory();
        if (this.filterHistory != null) {
            if (this.filterHistory.size() == 0) {
                this.filterComb.add("");
            } else {
                int i = 0;
                while (i < this.filterHistory.size()) {
                    this.filterComb.add((String)this.filterHistory.get(i));
                    ++i;
                }
            }
        }
    }

    private void filter(String condition) {
        int i = 0;
        while (i < this.viewer.getFilters().length) {
            ViewerFilter filter = this.viewer.getFilters()[i];
            this.viewer.removeFilter(filter);
            ++i;
        }
        if (!"".equals(condition)) {
            this.viewer.addFilter((ViewerFilter)new HistoryViewTableFilter(condition));
        }
        if (this.filterHistory.contains(condition)) {
            this.filterHistory.remove(condition);
            this.filterComb.remove(condition);
        }
        this.filterHistory.add(0, condition);
        this.filterComb.add(condition, 0);
        this.filterComb.select(0);
        this.removeOverHistory();
        this.filterComb.setFocus();
    }

    private void removeOverHistory() {
        while (this.filterHistory.size() > this.maxSize) {
            int i = this.filterHistory.size() - 1;
            this.filterHistory.remove(i);
            this.filterComb.remove(i);
        }
    }

    private void saveFilterHistory() {
        this.settringMgr.setValue("KEY_FILTER_LIST_HISTORY", this.filterHistory);
    }

    private List loadFilterHistory() {
        List list = (List)this.settringMgr.getValue("KEY_FILTER_LIST_HISTORY");
        if (list != null) {
            return list;
        }
        return new ArrayList();
    }

    protected void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener((IDoubleClickListener)new HistoryDoubleClickHandler());
    }

    protected void makeActions() {
        this.removeHistoryAction = new DeleteHistoryAction((StructuredViewer)this.viewer);
    }

    protected void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                HistoryView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        this.contributeToActionBars();
    }

    void fillContextMenu(IMenuManager manager) {
        Object obj = ((StructuredSelection)this.viewer.getSelection()).getFirstElement();
        if (obj instanceof HistoryFolder || obj instanceof History) {
            manager.add((IAction)this.removeHistoryAction);
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    public void setFocus() {
        this.viewer.getControl().notifyListeners(13, null);
        DbPlugin.fireStatusChangeListener(this, 13);
    }

    public void dispose() {
        this.saveFilterHistory();
        DbPlugin.fireStatusChangeListener(this, 12);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part instanceof SQLExecuteView) {
            this.lastSecondaryId = ((SQLExecuteView)part).getViewSite().getSecondaryId();
        }
    }

    public void statusChanged(Object obj, int status) {
        if (obj instanceof SQLExecuteView && 13 == status) {
            this.lastSecondaryId = ((SQLExecuteView)obj).getViewSite().getSecondaryId();
        }
    }

    public void updateHistoryView(SQLHistory history) {
        IContentProvider cp = this.viewer.getContentProvider();
        if (cp instanceof HistoryContentProvider) {
            HistoryContentProvider hcp = (HistoryContentProvider)cp;
            hcp.reflesh(history);
            this.viewer.refresh();
            HistoryFolder currentFolder = hcp.getHistoryHolder(history.getDate());
            this.viewer.expandToLevel((Object)currentFolder, 1);
        }
    }

    protected void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    void fillLocalPullDown(IMenuManager manager) {
    }

    void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.removeHistoryAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new MyButtonContiribution());
    }

    private class HistoryDoubleClickHandler
    implements IDoubleClickListener {
        SQLHistoryManager historyManager = DbPlugin.getDefault().getHistoryManager();

        public void doubleClick(DoubleClickEvent event) {
            try {
                Viewer view = event.getViewer();
                ISelection selection = event.getSelection();
                if (view instanceof TreeViewer && selection instanceof StructuredSelection) {
                    TreeViewer viewer = (TreeViewer)view;
                    Object element = ((StructuredSelection)selection).getFirstElement();
                    if (element instanceof History) {
                        History history = (History)element;
                        SQLExecuteView sview = HistoryView.this.lastSecondaryId == null ? (SQLExecuteView)DbPlugin.showView("zigen.plugin.db.ui.views.SQLExecuteView") : (SQLExecuteView)DbPlugin.showView("zigen.plugin.db.ui.views.SQLExecuteView", HistoryView.this.lastSecondaryId);
                        if (sview != null) {
                            SQLHistory sh = history.getSqlHistory();
                            sview.setSqlText(HistoryView.this.mgr.loadContents(sh));
                            if (sh.getConfig() != null) {
                                sview.updateCombo(sh.getConfig());
                            }
                            this.historyManager.modifyCurrentPosition(sh);
                            sview.updateHistoryButton();
                        }
                    } else if (element instanceof TreeNode) {
                        this.changeExpandedState(viewer, (TreeNode)element);
                    }
                }
            }
            catch (Exception e) {
                DbPlugin.log(e);
            }
        }

        private void changeExpandedState(TreeViewer viewer, TreeNode element) {
            if (!viewer.getExpandedState((Object)element)) {
                viewer.expandToLevel((Object)element, 1);
            } else {
                viewer.collapseToLevel((Object)element, 1);
            }
        }
    }

    public class MyButtonContiribution
    extends ControlContribution {
        Button button;

        public MyButtonContiribution() {
            super("verticalLayout");
        }

        public Control createControl(Composite parent) {
            ToolBar toolbar = new ToolBar(parent, 0x800000);
            ToolItem verticalItem = new ToolItem(toolbar, 16);
            ToolItem horizonItem = new ToolItem(toolbar, 16);
            Object obj = HistoryView.this.settringMgr.getValue("KEY_SQLHISTORY_LAYOUT");
            if (obj != null && obj instanceof String) {
                String value = (String)obj;
                if ("SWT.VERTICAL".equals(value)) {
                    HistoryView.this.sash.setOrientation(512);
                    verticalItem.setSelection(true);
                } else {
                    HistoryView.this.sash.setOrientation(256);
                    horizonItem.setSelection(true);
                }
            } else {
                verticalItem.setSelection(true);
            }
            verticalItem.setToolTipText(Messages.getString("HistoryView.7"));
            horizonItem.setToolTipText(Messages.getString("HistoryView.8"));
            verticalItem.setImage(HistoryView.this.ic.getImage("verticallayout.gif"));
            horizonItem.setImage(HistoryView.this.ic.getImage("horizontallayout.gif"));
            verticalItem.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ MyButtonContiribution this$1;
                {
                    this.this$1 = myButtonContiribution;
                }

                public void widgetSelected(SelectionEvent arg0) {
                    MyButtonContiribution.access$0((MyButtonContiribution)this.this$1).sash.setOrientation(512);
                    MyButtonContiribution.access$0((MyButtonContiribution)this.this$1).settringMgr.setValue("KEY_SQLHISTORY_LAYOUT", "SWT.VERTICAL");
                }
            });
            horizonItem.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ MyButtonContiribution this$1;
                {
                    this.this$1 = myButtonContiribution;
                }

                public void widgetSelected(SelectionEvent arg0) {
                    MyButtonContiribution.access$0((MyButtonContiribution)this.this$1).sash.setOrientation(256);
                    MyButtonContiribution.access$0((MyButtonContiribution)this.this$1).settringMgr.setValue("KEY_SQLHISTORY_LAYOUT", "SWT.HORIZONTAL");
                }
            });
            return toolbar;
        }

        static /* synthetic */ HistoryView access$0(MyButtonContiribution myButtonContiribution) {
            return myButtonContiribution.HistoryView.this;
        }
    }
}

