/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.views;

import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import zigen.plugin.db.core.DBType;
import zigen.plugin.db.ui.internal.DataBase;
import zigen.plugin.db.ui.internal.Folder;
import zigen.plugin.db.ui.internal.ITable;
import zigen.plugin.db.ui.internal.Schema;
import zigen.plugin.db.ui.jobs.ConnectDBJob;
import zigen.plugin.db.ui.jobs.OracleSequeceSearchJob;
import zigen.plugin.db.ui.jobs.OracleSourceSearchJob;
import zigen.plugin.db.ui.jobs.RefreshColumnJob;
import zigen.plugin.db.ui.jobs.RefreshFolderJob;
import zigen.plugin.db.ui.jobs.TableTypeSearchJob;

public class TreeViewListener
implements ITreeViewerListener {
    private boolean showDialog = false;

    public void treeCollapsed(TreeExpansionEvent event) {
    }

    public void treeExpanded(TreeExpansionEvent event) {
        Folder folder;
        Object element = event.getElement();
        TreeViewer viewer = (TreeViewer)event.getTreeViewer();
        if (element instanceof DataBase) {
            DataBase db = (DataBase)element;
            if (!db.isExpanded()) {
                db.setExpanded(true);
                ConnectDBJob job = new ConnectDBJob(viewer, db);
                job.setPriority(20);
                job.setUser(false);
                job.setSystem(false);
                job.schedule();
            }
        } else if (element instanceof Schema) {
            Schema schema = (Schema)element;
            if (!schema.isExpanded()) {
                schema.setExpanded(true);
                TableTypeSearchJob job = new TableTypeSearchJob(viewer, schema);
                job.setPriority(20);
                job.setUser(this.showDialog);
                job.schedule();
            }
        } else if (element instanceof ITable) {
            ITable table = (ITable)element;
            if (!table.isExpanded()) {
                RefreshColumnJob job = new RefreshColumnJob(viewer, table);
                job.setPriority(20);
                job.setUser(false);
                job.schedule();
            }
        } else if (element instanceof Folder && !(folder = (Folder)element).isExpanded()) {
            folder.setExpanded(true);
            Schema schema = folder.getSchema();
            if (schema != null) {
                switch (DBType.getType(schema.getDbConfig())) {
                    case 1: {
                        if (schema == null) break;
                        if ("TABLE".equals(folder.getName())) {
                            return;
                        }
                        if ("SEQUENCE".equals(folder.getName())) {
                            OracleSequeceSearchJob job = new OracleSequeceSearchJob(viewer, folder);
                            job.setPriority(20);
                            job.setUser(this.showDialog);
                            job.schedule();
                            return;
                        }
                        if ("VIEW".equals(folder.getName())) {
                            System.out.println("treeExpanded!!");
                            RefreshFolderJob job = new RefreshFolderJob(viewer, folder);
                            job.setPriority(20);
                            job.setUser(this.showDialog);
                            job.schedule();
                            return;
                        }
                        String[] sTypes = schema.getSourceType();
                        if (sTypes == null) break;
                        int i = 0;
                        while (i < sTypes.length) {
                            String stype = sTypes[i];
                            if (stype.equals(folder.getName())) {
                                OracleSourceSearchJob job = new OracleSourceSearchJob(viewer, folder);
                                job.setPriority(20);
                                job.setUser(this.showDialog);
                                job.schedule();
                                return;
                            }
                            ++i;
                        }
                        break;
                    }
                }
                RefreshFolderJob job = new RefreshFolderJob(viewer, folder);
                job.setPriority(20);
                job.setUser(this.showDialog);
                job.schedule();
                return;
            }
        }
    }
}

