/*
 * Decompiled with CFR 0.152.
 */
package zigen.plugin.db.ui.views.internal;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.ContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import zigen.plugin.db.DbPlugin;
import zigen.plugin.db.ui.contentassist.SQLContentAssistantProcessor2;
import zigen.plugin.db.ui.views.internal.ColorManager;
import zigen.plugin.db.ui.views.internal.ISQLTokenScanner;
import zigen.plugin.db.ui.views.internal.NonRuleBasedDamagerRepairer;
import zigen.plugin.db.ui.views.internal.SQLFormattingStrategy;
import zigen.plugin.db.ui.views.internal.SQLKeywordScanner;

public class SQLCodeConfiguration
extends SourceViewerConfiguration {
    ISQLTokenScanner keyWorkScanner;
    ColorManager colorManager;
    PresentationReconciler reconciler;
    IPreferenceStore preferenceStore;

    public SQLCodeConfiguration(ColorManager colorManager) {
        this.colorManager = colorManager;
        this.preferenceStore = DbPlugin.getDefault().getPreferenceStore();
    }

    protected ISQLTokenScanner getSQLKeywordScanner() {
        if (this.keyWorkScanner == null) {
            this.keyWorkScanner = new SQLKeywordScanner(this.colorManager);
        } else {
            this.keyWorkScanner.initialize();
        }
        return this.keyWorkScanner;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__sql_comment", "__sql_string"};
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        this.reconciler = new PresentationReconciler();
        this.InitializeDamagerRepairer();
        return this.reconciler;
    }

    public void updatePreferences(IDocument document) {
        this.getSQLKeywordScanner().initialize();
        NonRuleBasedDamagerRepairer commentDR = new NonRuleBasedDamagerRepairer(new TextAttribute(this.colorManager.getColor("SQLEditorPreferencePage.ColorComment")));
        commentDR.setDocument(document);
        this.reconciler.setDamager((IPresentationDamager)commentDR, "__sql_comment");
        this.reconciler.setRepairer((IPresentationRepairer)commentDR, "__sql_comment");
        NonRuleBasedDamagerRepairer stringDR = new NonRuleBasedDamagerRepairer(new TextAttribute(this.colorManager.getColor("SQLEditorPreferencePage.ColorString")));
        stringDR.setDocument(document);
        this.reconciler.setDamager((IPresentationDamager)stringDR, "__sql_string");
        this.reconciler.setRepairer((IPresentationRepairer)stringDR, "__sql_string");
    }

    private void InitializeDamagerRepairer() {
        DefaultDamagerRepairer commentDR = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(this.colorManager.getColor("SQLEditorPreferencePage.ColorComment"))));
        this.reconciler.setDamager((IPresentationDamager)commentDR, "__sql_comment");
        this.reconciler.setRepairer((IPresentationRepairer)commentDR, "__sql_comment");
        DefaultDamagerRepairer stringDR = new DefaultDamagerRepairer((ITokenScanner)new SingleTokenScanner(new TextAttribute(this.colorManager.getColor("SQLEditorPreferencePage.ColorString"))));
        this.reconciler.setDamager((IPresentationDamager)stringDR, "__sql_string");
        this.reconciler.setRepairer((IPresentationRepairer)stringDR, "__sql_string");
        DefaultDamagerRepairer keywordDR = new DefaultDamagerRepairer((ITokenScanner)this.getSQLKeywordScanner());
        this.reconciler.setDamager((IPresentationDamager)keywordDR, "__dftl_partition_content_type");
        this.reconciler.setRepairer((IPresentationRepairer)keywordDR, "__dftl_partition_content_type");
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        SQLContentAssistantProcessor2 processor = new SQLContentAssistantProcessor2();
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        assistant.enableAutoActivation(true);
        int delayTime = this.preferenceStore.getInt("CodeAssistPreferencePage.SqlCodeAssistAutoActivateDelayTime");
        assistant.setAutoActivationDelay(delayTime);
        assistant.enableAutoInsert(true);
        return assistant;
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        ContentFormatter formatter = new ContentFormatter();
        formatter.setFormattingStrategy((IFormattingStrategy)new SQLFormattingStrategy(sourceViewer), "__dftl_partition_content_type");
        formatter.setFormattingStrategy((IFormattingStrategy)new SQLFormattingStrategy(sourceViewer), "__sql_string");
        return formatter;
    }

    static class SingleTokenScanner
    extends BufferedRuleBasedScanner {
        public SingleTokenScanner(TextAttribute attribute) {
            this.setDefaultReturnToken((IToken)new Token((Object)attribute));
        }
    }
}

