/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.epic.debug.PerlDebugPlugin;

public abstract class PerlTarget
extends DebugElement
implements IDebugTarget {
    private ILaunch launch;
    private boolean mShutDownStarted;
    private final IProject project;

    public PerlTarget(ILaunch launch) throws CoreException {
        super(null);
        this.launch = launch;
        this.project = this.initProject();
        this.fireCreationEvent();
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public String getModelIdentifier() {
        return PerlDebugPlugin.getUniqueIdentifier();
    }

    public IProject getProject() {
        return this.project;
    }

    public abstract boolean isLocal();

    protected void shutdown() {
        if (this.mShutDownStarted) {
            return;
        }
        this.mShutDownStarted = true;
        try {
            if (this.getProcess() != null) {
                this.getProcess().terminate();
            }
        }
        catch (DebugException e) {
            PerlDebugPlugin.getDefault().logError("Error terminating process " + this.getProcess().getLabel(), (Exception)((Object)e));
        }
        this.fireTerminateEvent();
    }

    protected final void unsupportedOperation() throws DebugException {
        throw new DebugException((IStatus)new Status(4, PerlDebugPlugin.getUniqueIdentifier(), 5011, "operation not supported", null));
    }

    private IProject initProject() throws CoreException {
        String projectName = this.getLaunch().getLaunchConfiguration().getAttribute("ATTR_PROJECT_NAME", "");
        return PerlDebugPlugin.getWorkspace().getRoot().getProject(projectName);
    }
}

