/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.cgi;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.help.browser.IBrowser;
import org.eclipse.help.internal.browser.BrowserDescriptor;
import org.eclipse.help.internal.browser.BrowserManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.epic.core.views.browser.BrowserView;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.cgi.server.CustomBrowser;

public class CGIBrowser {
    private final ILaunch mLaunch;
    private final int mWebserverPort;
    private final String mHtmlRootFileRel;
    private IBrowser mBrowser;

    public CGIBrowser(ILaunch launch, String relURL, int port) {
        this.mLaunch = launch;
        this.mWebserverPort = port;
        this.mHtmlRootFileRel = relURL;
    }

    public void close() {
        if (this.mBrowser != null) {
            this.mBrowser.close();
        }
    }

    public void open() {
        DebugPlugin.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    CGIBrowser.this.startBrowserImpl();
                }
                catch (Exception e) {
                    PerlDebugPlugin.getDefault().logError("Could not start browser for CGI debugging", e);
                }
            }
        });
    }

    private String getLaunchAttribute(String attrName) throws CoreException {
        return this.mLaunch.getLaunchConfiguration().getAttribute(attrName, null);
    }

    private void startBrowserImpl() throws Exception {
        String browserID = this.getLaunchAttribute("ATTR_BROWSER_ID");
        String browserPath = this.getLaunchAttribute("ATTR_CUSTOM_BROWSER_PATH");
        if (browserID.equals("org.epic.core.views.browser.BrowserView")) {
            this.showBrowserView();
            return;
        }
        if (CustomBrowser.isCustomBrowserID(browserID)) {
            this.mBrowser = new CustomBrowser(browserPath);
        } else {
            BrowserDescriptor[] browserDescr = this.getBrowserDescriptor();
            int i = 0;
            while (i < browserDescr.length) {
                BrowserDescriptor descr = browserDescr[i];
                if (descr.getID().equals(browserID)) {
                    this.mBrowser = descr.getFactory().createBrowser();
                    break;
                }
                ++i;
            }
        }
        if (this.mBrowser != null) {
            this.mBrowser.displayURL("http://localhost:" + this.mWebserverPort + "/" + this.mHtmlRootFileRel);
        } else {
            PerlDebugPlugin.getDefault().logError("Could not find browser for CGI debugging.");
        }
    }

    private BrowserDescriptor[] getBrowserDescriptor() {
        Shell shell = PerlDebugPlugin.getActiveWorkbenchShell();
        if (shell == null) {
            return new BrowserDescriptor[0];
        }
        final Object[] ret = new Object[1];
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ret[0] = BrowserManager.getInstance().getBrowserDescriptors();
            }
        });
        return (BrowserDescriptor[])ret[0];
    }

    private void showBrowserView() throws PartInitException {
        Shell shell = PerlDebugPlugin.getActiveWorkbenchShell();
        if (shell == null) {
            return;
        }
        shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbenchPage activePage = PerlDebugPlugin.getWorkbenchWindow().getActivePage();
                    BrowserView view = (BrowserView)activePage.showView("org.epic.core.views.browser.BrowserView");
                    view.setUrl("http://localhost:" + CGIBrowser.this.mWebserverPort + "/");
                }
                catch (PartInitException e) {
                    PerlDebugPlugin.getDefault().logError("Could not open browser view.", (Exception)((Object)e));
                }
            }
        });
    }
}

