/*
 * Decompiled with CFR 0.152.
 */
package org.epic.debug.ui;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.epic.core.util.FileUtilities;
import org.epic.debug.PerlBreakpoint;
import org.epic.debug.PerlDebugPlugin;
import org.epic.debug.PerlLineBreakpoint;
import org.epic.debug.PerlRegExpBreakpoint;
import org.epic.debug.db.StackFrame;
import org.epic.debug.ui.PerlDebugImages;
import org.epic.debug.ui.PerlImageDescriptor;
import org.epic.debug.varparser.PerlDebugVar;

public class DebugModelPresentation
implements IDebugModelPresentation {
    public void setAttribute(String attribute, Object value) {
    }

    public Image getImage(Object element) {
        IBreakpoint bp;
        if (element instanceof PerlDebugVar) {
            try {
                if (((PerlDebugVar)((Object)element)).isSpecial()) {
                    return PerlDebugPlugin.getDefaultDesciptorImageRegistry().get((ImageDescriptor)new PerlImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT_DISABLED"), 0));
                }
                if (((PerlDebugVar)((Object)element)).isLocalScope()) {
                    if (((PerlDebugVar)((Object)element)).hasContentChanged()) {
                        return PerlDebugPlugin.getDefaultDesciptorImageRegistry().get(PerlDebugImages.DESC_OBJS_CHANGED_DEBUG_VAR_LOCAL);
                    }
                    return PerlDebugPlugin.getDefaultDesciptorImageRegistry().get(PerlDebugImages.DESC_OBJS_DEBUG_VAR_LOCAL);
                }
                if (((PerlDebugVar)((Object)element)).hasContentChanged()) {
                    return PerlDebugPlugin.getDefaultDesciptorImageRegistry().get(PerlDebugImages.DESC_OBJS_CHANGED_DEBUG_VAR);
                }
            }
            catch (DebugException e) {
                e.printStackTrace();
            }
        }
        if (element instanceof IMarker && (bp = this.getBreakpoint((IMarker)element)) != null && bp instanceof PerlBreakpoint) {
            return this.getPerlBreakpointImage((PerlLineBreakpoint)bp);
        }
        if (element instanceof PerlBreakpoint) {
            return this.getPerlBreakpointImage((PerlBreakpoint)((Object)element));
        }
        return null;
    }

    protected Image getPerlBreakpointImage(PerlBreakpoint breakpoint) {
        try {
            int flags = this.computeBreakpointAdornmentFlags(breakpoint);
            PerlImageDescriptor descriptor = null;
            descriptor = breakpoint.isEnabled() && !breakpoint.isInvalidBreakpointPosition() ? (breakpoint instanceof PerlRegExpBreakpoint ? new PerlImageDescriptor(PerlDebugImages.DESC_OBJS_REGEXP_BP_ENABLED, flags) : new PerlImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT"), flags)) : (breakpoint instanceof PerlRegExpBreakpoint ? new PerlImageDescriptor(PerlDebugImages.DESC_OBJS_REGEXP_BP_DISABLED, flags) : new PerlImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_OBJS_BREAKPOINT_DISABLED"), flags));
            return PerlDebugPlugin.getDefaultDesciptorImageRegistry().get((ImageDescriptor)descriptor);
        }
        catch (CoreException e) {
            PerlDebugPlugin.log(e);
            return null;
        }
    }

    public String getText(Object element) {
        StringBuffer erg = new StringBuffer();
        if (element instanceof PerlLineBreakpoint) {
            PerlLineBreakpoint bp = (PerlLineBreakpoint)((Object)element);
            if (bp.getResourcePath() == null) {
                return "[]";
            }
            erg.append(bp.getResourcePath().lastSegment());
            try {
                erg.append(" [line: " + Integer.toString(bp.getLineNumber()) + "]");
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (bp.isInvalidBreakpointPosition()) {
                erg.append(" - <invalid position>");
            }
            return erg.toString();
        }
        return null;
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        try {
            listener.detailComputed(value, value.getValueString());
        }
        catch (DebugException e) {
            e.printStackTrace();
        }
    }

    public IEditorInput getEditorInput(Object element) {
        if (element instanceof StackFrame) {
            StackFrame frame = (StackFrame)((Object)element);
            if (frame.getLocalPath() == null) {
                return null;
            }
            return FileUtilities.getFileEditorInput((IPath)frame.getLocalPath());
        }
        if (element instanceof PerlBreakpoint) {
            return ((PerlBreakpoint)((Object)element)).getEditorInput();
        }
        return null;
    }

    public String getEditorId(IEditorInput input, Object element) {
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor descriptor = registry.getDefaultEditor(input.getName());
        return descriptor != null ? descriptor.getId() : null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    private int computeBreakpointAdornmentFlags(PerlBreakpoint breakpoint) {
        int flags = 0;
        if (breakpoint.isInvalidBreakpointPosition()) {
            return 0;
        }
        try {
            if (breakpoint.isEnabled()) {
                flags |= 0x20;
            }
            if (breakpoint.isInstalled()) {
                flags |= 4;
            }
        }
        catch (CoreException e) {
            PerlDebugPlugin.log(e);
        }
        return flags;
    }

    protected IBreakpoint getBreakpoint(IMarker marker) {
        return DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker);
    }
}

