/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.graph.editors;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.StringTokenizer;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.graph.Activator;
import org.tigris.subversion.subclipse.graph.cache.Node;

public class NodeTooltipFigure
extends Figure {
    private static final int BORDER_WIDTH = 5;
    private static final int BORDER_WIDTH2 = 10;
    private static DateFormat dateFormat;
    private boolean hasSources = false;
    private boolean hasTags = false;
    private int tagsAdded;
    private int tagCount;
    private int messageLines;
    private static final int NUMBER_OF_LOG_MESSAGE_LINES = 15;
    private static final int NUMBER_OF_TAG_AND_MESSAGE_LINES = 25;

    public NodeTooltipFigure(Node node) {
        ToolbarLayout layout = new ToolbarLayout();
        layout.setStretchMinorAxis(false);
        this.setLayoutManager((LayoutManager)layout);
        this.setBackgroundColor(Activator.BGCOLOR);
        this.setOpaque(true);
        layout.setSpacing(5);
        if (dateFormat == null) {
            dateFormat = SimpleDateFormat.getDateTimeInstance(2, 2);
        }
        Figure tooltip = new Figure();
        this.setToolTip((IFigure)tooltip);
        this.add((IFigure)NodeTooltipFigure.createLabel("Action and path", JFaceResources.getHeaderFont(), Activator.FONT_COLOR));
        this.add((IFigure)NodeTooltipFigure.createLabel(String.valueOf(node.getAction()) + " " + node.getPath(), JFaceResources.getTextFont()));
        this.add((IFigure)NodeTooltipFigure.createLabel("Author", JFaceResources.getHeaderFont(), Activator.FONT_COLOR));
        this.add((IFigure)NodeTooltipFigure.createLabel(node.getAuthor(), JFaceResources.getTextFont()));
        this.add((IFigure)NodeTooltipFigure.createLabel("Date", JFaceResources.getHeaderFont(), Activator.FONT_COLOR));
        this.add((IFigure)NodeTooltipFigure.createLabel(dateFormat.format(node.getRevisionDate()), JFaceResources.getTextFont()));
        this.add((IFigure)NodeTooltipFigure.createLabel("Message", JFaceResources.getHeaderFont(), Activator.FONT_COLOR));
        this.add((IFigure)NodeTooltipFigure.createLabel(this.getFirstLines(node.getMessage(), 15), JFaceResources.getTextFont()));
        if (node.getCopySrcPath() != null) {
            this.add((IFigure)NodeTooltipFigure.createLabel("From", JFaceResources.getHeaderFont(), Activator.FONT_COLOR));
            this.add((IFigure)NodeTooltipFigure.createLabel(this.format(node.getCopySrcRevision(), node.getCopySrcPath()), JFaceResources.getTextFont()));
        }
    }

    public void endLayout() {
        if (this.tagCount > this.tagsAdded) {
            this.add((IFigure)NodeTooltipFigure.createLabel(String.valueOf(this.tagCount - this.tagsAdded) + " more...", JFaceResources.getTextFont()));
        }
        Dimension d = this.getPreferredSize();
        int width = d.width + 10;
        int height = d.height + 10;
        Rectangle b = PlatformUI.getWorkbench().getDisplay().getClientArea();
        width = width > b.width ? b.width - 30 : width;
        height = height > b.height ? b.height - 50 : height;
        this.setPreferredSize(width, height);
        this.setBorder((Border)new LineBorder(Activator.BGCOLOR, 5));
    }

    public void addSource(Node node) {
        if (!this.hasSources) {
            this.add((IFigure)NodeTooltipFigure.createLabel("Source of", JFaceResources.getHeaderFont(), Activator.FONT_COLOR));
            this.hasSources = true;
        }
        this.add((IFigure)NodeTooltipFigure.createLabel(this.format(node.getRevision(), node.getPath()), JFaceResources.getTextFont()));
    }

    public void addTag(Node node) {
        if (!this.hasTags) {
            this.add((IFigure)NodeTooltipFigure.createLabel("Tagged as", JFaceResources.getHeaderFont(), Activator.FONT_COLOR));
            this.hasTags = true;
        }
        if (this.messageLines + this.tagCount < 25) {
            this.add((IFigure)NodeTooltipFigure.createLabel(this.format(node.getRevision(), node.getPath()), JFaceResources.getTextFont()));
            ++this.tagsAdded;
        }
        ++this.tagCount;
    }

    public String format(long revision, String path) {
        return "r" + Long.toString(revision) + " " + path;
    }

    public static Label createLabel(String text, Font font) {
        Label label = new Label(text);
        label.setFont(font);
        label.setTextAlignment(1);
        return label;
    }

    public static Label createLabel(String text, Font font, Color c) {
        Label label = new Label(text);
        label.setFont(font);
        label.setTextAlignment(1);
        label.setForegroundColor(c);
        return label;
    }

    public String getFirstLines(String string, int numberLines) {
        if (string == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(string, "\r\n");
        int count = tokenizer.countTokens();
        if (count <= numberLines) {
            this.messageLines = count;
            return string;
        }
        this.messageLines = numberLines;
        StringBuffer newString = new StringBuffer();
        int i = 0;
        while (i < numberLines) {
            newString.append(String.valueOf(tokenizer.nextToken()) + "\n");
            ++i;
        }
        newString.append(String.valueOf(count - numberLines) + " more message lines . . .");
        return newString.toString();
    }
}

