/*
 * Decompiled with CFR 0.152.
 */
package net.sf.colorer.eclipse.jface;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import net.sf.colorer.eclipse.jface.ColorerProjectionAnnotation;
import net.sf.colorer.eclipse.jface.IColorerEditorAdapter;
import net.sf.colorer.editor.BaseEditor;
import net.sf.colorer.editor.FoldingBuilder;
import net.sf.colorer.editor.IFoldingReciever;
import net.sf.colorer.impl.Logger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.swt.widgets.Display;

public class ColorerFoldingProvider {
    static final int FOLDING_UPDATE_PERIOD = 1500;
    FoldingBuilder builder;
    private BaseEditor fBaseEditor;
    private IDocument fDocument;
    private IColorerEditorAdapter fEditor;
    private Display rootDisplay;
    private Vector deletions = new Vector();
    private HashMap additions = new HashMap();
    static /* synthetic */ Class class$org$eclipse$jface$text$source$projection$ProjectionAnnotationModel;
    static /* synthetic */ Class class$org$eclipse$jface$text$IDocument;

    void updateAnnotations() {
        if (this.rootDisplay == null) {
            return;
        }
        ProjectionAnnotationModel model = this.getModel();
        if (model == null) {
            return;
        }
        if (this.deletions.size() == 0 && this.additions.size() == 0) {
            return;
        }
        model.modifyAnnotations(this.deletions.toArray(new Annotation[0]), (Map)this.additions, null);
        this.deletions.setSize(0);
        this.additions.clear();
    }

    ProjectionAnnotationModel getModel() {
        if (this.fEditor == null) {
            return null;
        }
        return (ProjectionAnnotationModel)this.fEditor.getAdapter(class$org$eclipse$jface$text$source$projection$ProjectionAnnotationModel == null ? (class$org$eclipse$jface$text$source$projection$ProjectionAnnotationModel = ColorerFoldingProvider.class$("org.eclipse.jface.text.source.projection.ProjectionAnnotationModel")) : class$org$eclipse$jface$text$source$projection$ProjectionAnnotationModel);
    }

    public void install(IColorerEditorAdapter editor) {
        this.fEditor = editor;
        this.fDocument = (IDocument)this.fEditor.getAdapter(class$org$eclipse$jface$text$IDocument == null ? (class$org$eclipse$jface$text$IDocument = ColorerFoldingProvider.class$("org.eclipse.jface.text.IDocument")) : class$org$eclipse$jface$text$IDocument);
        this.fBaseEditor = this.fEditor.getBaseEditor();
        Assert.isNotNull((Object)this.fBaseEditor);
        this.builder = new FoldingBuilder();
        this.builder.install(this.fBaseEditor, new FoldingReciever());
        this.rootDisplay = Display.getCurrent();
        new Thread(new Runnable(){

            public void run() {
                while (ColorerFoldingProvider.this.rootDisplay != null && !ColorerFoldingProvider.this.rootDisplay.isDisposed()) {
                    ColorerFoldingProvider.this.rootDisplay.asyncExec(new Runnable(){

                        public void run() {
                            ColorerFoldingProvider.this.updateAnnotations();
                        }
                    });
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }, "ColorerFoldingProvider").start();
    }

    public void uninstall() {
        this.rootDisplay = null;
        this.builder.uninstall();
        this.builder = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class FoldingReciever
    implements IFoldingReciever {
        private int fLastLine;

        FoldingReciever() {
        }

        public void notifyInvalidate(int lineno) {
            ColorerFoldingProvider.this.additions.clear();
            ProjectionAnnotationModel model = ColorerFoldingProvider.this.getModel();
            if (model == null) {
                return;
            }
            Iterator iter = model.getAnnotationIterator();
            while (iter.hasNext()) {
                Annotation ann;
                block5: {
                    ann = (Annotation)iter.next();
                    if (!(ann instanceof ProjectionAnnotation)) continue;
                    Position pos = model.getPosition(ann);
                    try {
                        if (ColorerFoldingProvider.this.fDocument.getLineOfOffset(pos.offset) < lineno) {
                        }
                        break block5;
                    }
                    catch (BadLocationException e) {
                        Logger.error("FoldingReciever", "notifyInvalidate", e);
                    }
                    continue;
                }
                ColorerFoldingProvider.this.deletions.addElement(ann);
            }
            this.fLastLine = lineno;
        }

        public void notifyFoldingItem(int s_line, int s_offset, int e_line, int e_offset, String schema) {
            if (this.fLastLine >= e_line) {
                return;
            }
            this.fLastLine = e_line;
            ProjectionAnnotationModel model = ColorerFoldingProvider.this.getModel();
            if (model == null) {
                return;
            }
            ColorerProjectionAnnotation ann = new ColorerProjectionAnnotation(schema);
            try {
                int offset = ColorerFoldingProvider.this.fDocument.getLineOffset(s_line);
                int len = ColorerFoldingProvider.this.fDocument.getLineOffset(e_line) + ColorerFoldingProvider.this.fDocument.getLineLength(e_line) - offset;
                Position newposition = new Position(offset, len);
                Enumeration e = ColorerFoldingProvider.this.deletions.elements();
                while (e.hasMoreElements()) {
                    ProjectionAnnotation deleted = (ProjectionAnnotation)e.nextElement();
                    if (!newposition.equals((Object)model.getPosition((Annotation)deleted))) continue;
                    if (deleted.isCollapsed()) {
                        ann.markCollapsed();
                        continue;
                    }
                    ann.markExpanded();
                }
                ColorerFoldingProvider.this.additions.put(ann, newposition);
            }
            catch (BadLocationException e) {
                Logger.error("FoldingReciever", "notifyFoldingItem", e);
            }
        }
    }
}

