/* ShellLink.cpp
 * Last update: 2016.01.04
 * (c) 2015 JOJO
 */
#if 1 // #ifdef FIX_SHELL_LINK

#if !(defined(UNICODE) && defined(_UNICODE))
#error require UNICODE. To compile: cl -DUNICODE -D_UNICODE -c ShellLink.cpp
#endif

#include <windows.h>
#include <Shlobj.h>

#include "wcs.h"

__declspec(dllexport) bool __stdcall ToShellLinkTarget(WCHAR fileName[], int max_path)
{
	bool ret = false;
	if (!wcsendsWith(fileName, L".lnk")) return ret;

	CoInitialize(NULL);
	IShellLink *shellLink;
	if (CoCreateInstance(CLSID_ShellLink, NULL, CLSCTX_INPROC_SERVER, IID_IShellLink, (void**)&shellLink) == S_OK)
	{
		IPersistFile *persistFile;
		if (shellLink->QueryInterface(IID_IPersistFile, (void**)&persistFile) == S_OK)
		{
			if (persistFile->Load(fileName, STGM_READ) == S_OK)
			{
				WIN32_FIND_DATA findData;
				shellLink->GetPath(fileName, max_path, &findData, SLGP_UNCPRIORITY);
				ret = true;
			}
			persistFile->Release();
		}
		shellLink->Release();
	}
	CoUninitialize();
	return ret;
}
#endif // FIX_SHELL_LINK
