package jp.sourceforge.larch.core.command.impl
{
    import jp.sourceforge.larch.core.command.SyncCommand;

    /**
     * 関数実行コマンド
     * @author tdott&lt;tdott@users.sourceforge.jp&gt;
     */
    public class ExecFunctionCommand extends SyncCommand
    {
        /**
         * コンストラクタ
         * @param aFunction 実行する関数
         * @param aArgs aFunctionの引数
         * @param aTarget 関数実行結果の設定先
         * @param aTargetProperty 関数実行結果の設定先のプロパティ名
         * @param aValue 設定する値
         */
        public function ExecFunctionCommand(aFunction:Function, aArgs:Array = null, aTarget:Object = null, aTargetProperty:String = null)
        {
            super(aTarget, aTargetProperty);
            func = aFunction;
            args = aArgs;
        }

        /** 実行する関数 */
        private var func:Function;
        /** 引数 */
        private var args:Array;

        /**
         * 関数を実行し、結果をresultValueに設定します。
         * @return 常にtrue
         */
        override protected function doExecute():Boolean
        {
            resultValue = func.apply(null, args);
            return true;
        }
    }
}