/*
 * Decompiled with CFR 0.152.
 */
package org.ldr4j.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.arnx.jsonic.JSON;
import org.apache.http.Header;
import org.ldr4j.LDRException;
import org.ldr4j.api.AbstractLDRHttpClient;
import org.ldr4j.api.LDRHttpResponse;
import org.ldr4j.api.methods.FeedMethod;
import org.ldr4j.api.methods.FolderMethod;
import org.ldr4j.api.methods.PinMethod;
import org.ldr4j.api.response.ApiResponseStatus;
import org.ldr4j.api.response.Article;
import org.ldr4j.api.response.Feed;
import org.ldr4j.api.response.FeedInfo;
import org.ldr4j.api.response.Folder;
import org.ldr4j.api.response.FolderOuter;
import org.ldr4j.api.response.Pin;

public class LDRClient
extends AbstractLDRHttpClient
implements FeedMethod,
PinMethod,
FolderMethod {
    private String apiKey;

    public LDRClient(String livedoorId, String password) throws LDRException {
        this.authenticate(livedoorId, password);
    }

    public LDRClient(String livedoorId, String password, String proxyHost, int proxyPort) throws LDRException {
        super(proxyHost, proxyPort);
        this.authenticate(livedoorId, password);
    }

    private void authenticate(String livedoorId, String password) throws LDRException {
        block6: {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("livedoor_id", livedoorId);
            params.put("password", password);
            LDRHttpResponse response = super.doPost("http://member.livedoor.com/login/index", params);
            if (response.getStatusCode() == 302) {
                Header[] cookieHeader;
                LDRHttpResponse response2 = super.doGet("http://reader.livedoor.com/", Collections.<String, String>emptyMap());
                Header[] headerArray = cookieHeader = response2.getCookieHeader();
                int n = cookieHeader.length;
                int n2 = 0;
                while (n2 < n) {
                    Header cookie = headerArray[n2];
                    String apiKeyName = "reader_sid=";
                    if (cookie.getValue().startsWith(apiKeyName)) {
                        this.apiKey = cookie.getValue().substring(apiKeyName.length(), apiKeyName.length() + 32);
                    }
                    ++n2;
                }
                if (this.apiKey == null || this.apiKey.equals("")) {
                    throw new LDRException("Failed authentication in livedoor.");
                }
                break block6;
            }
            throw new LDRException("Failed authentication in livedoor.");
        }
    }

    @Override
    public Folder[] getAllFolders() throws LDRException {
        LDRHttpResponse response = this.doPost("http://reader.livedoor.com/api/folders", Collections.<String, String>emptyMap());
        FolderOuter folderOuter = (FolderOuter)JSON.decode((String)response.getBody(), FolderOuter.class);
        Map<String, String> folders = folderOuter.getName2id();
        Folder[] result = new Folder[folders.size()];
        int i = 0;
        for (Map.Entry<String, String> e : folders.entrySet()) {
            Folder folder = new Folder();
            folder.setId(e.getValue());
            folder.setName(e.getKey());
            result[i++] = folder;
        }
        return result;
    }

    @Override
    public void createFolder(String folderName) throws LDRException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", folderName);
        params.put("ApiKey", this.apiKey);
        LDRHttpResponse response = this.doPost("http://reader.livedoor.com/api/folder/create", params);
        if (response.getStatusCode() == 200) {
            ApiResponseStatus result = (ApiResponseStatus)JSON.decode((String)response.getBody(), ApiResponseStatus.class);
            if (result.getErrorCode() != 0 || result.getIsSuccess() != 1) {
                throw new LDRException("Failed create folder. ErrorCode " + result.getErrorCode());
            }
        } else {
            if (response.getStatusCode() == 403) {
                throw new LDRException("Failed authentication in livedoor.");
            }
            throw new LDRException("Failed create folder.");
        }
    }

    @Override
    public void updateFolder(String folderId, String folderName) throws LDRException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("folder_id", folderId);
        params.put("name", folderName);
        params.put("ApiKey", this.apiKey);
        LDRHttpResponse response = this.doPost("http://reader.livedoor.com/api/folder/update", params);
        if (response.getStatusCode() == 200) {
            ApiResponseStatus result = (ApiResponseStatus)JSON.decode((String)response.getBody(), ApiResponseStatus.class);
            if (result.getErrorCode() != 0 || result.getIsSuccess() != 1) {
                throw new LDRException("Failed update folder. ErrorCode " + result.getErrorCode());
            }
        } else {
            if (response.getStatusCode() == 403) {
                throw new LDRException("Failed authentication in livedoor.");
            }
            throw new LDRException("Failed update folder.");
        }
    }

    @Override
    public void deleteFolder(String folderId) throws LDRException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("folder_id", folderId);
        params.put("ApiKey", this.apiKey);
        LDRHttpResponse response = this.doPost("http://reader.livedoor.com/api/folder/delete", params);
        if (response.getStatusCode() == 200) {
            ApiResponseStatus result = (ApiResponseStatus)JSON.decode((String)response.getBody(), ApiResponseStatus.class);
            if (result.getErrorCode() != 0 || result.getIsSuccess() != 1) {
                throw new LDRException("Failed delete folder. ErrorCode " + result.getErrorCode());
            }
        } else {
            if (response.getStatusCode() == 403) {
                throw new LDRException("Failed authentication in livedoor.");
            }
            throw new LDRException("Failed delete folder.");
        }
    }

    @Override
    public Pin[] getAllPins() throws LDRException {
        LDRHttpResponse response = this.doPost("http://reader.livedoor.com/api/pin/all", Collections.<String, String>emptyMap());
        return (Pin[])JSON.decode((String)response.getBody(), Pin[].class);
    }

    @Override
    public void addPin(String link, String title) throws LDRException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("link", link);
        params.put("title", title);
        params.put("ApiKey", this.apiKey);
        LDRHttpResponse response = this.doPost("http://reader.livedoor.com/api/pin/add", params);
        if (response.getStatusCode() == 200) {
            ApiResponseStatus result = (ApiResponseStatus)JSON.decode((String)response.getBody(), ApiResponseStatus.class);
            if (result.getErrorCode() != 0 || result.getIsSuccess() != 1) {
                throw new LDRException("Failed add pin. ErrorCode " + result.getErrorCode());
            }
        } else {
            if (response.getStatusCode() == 403) {
                throw new LDRException("Failed authentication in livedoor.");
            }
            throw new LDRException("Failed add pin.");
        }
    }

    @Override
    public void removePin(String link) throws LDRException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("link", link);
        params.put("ApiKey", this.apiKey);
        LDRHttpResponse response = this.doPost("http://reader.livedoor.com/api/pin/remove", params);
        if (response.getStatusCode() == 200) {
            ApiResponseStatus result = (ApiResponseStatus)JSON.decode((String)response.getBody(), ApiResponseStatus.class);
            if (result.getErrorCode() != 0 || result.getIsSuccess() != 1) {
                throw new LDRException("Failed remove pin. ErrorCode " + result.getErrorCode());
            }
        } else {
            if (response.getStatusCode() == 403) {
                throw new LDRException("Failed authentication in livedoor.");
            }
            throw new LDRException("Failed remove pin.");
        }
    }

    @Override
    public void clearPin() throws LDRException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ApiKey", this.apiKey);
        LDRHttpResponse response = this.doPost("http://reader.livedoor.com/api/pin/clear", params);
        if (response.getStatusCode() == 200) {
            ApiResponseStatus result = (ApiResponseStatus)JSON.decode((String)response.getBody(), ApiResponseStatus.class);
            if (result.getErrorCode() != 0 || result.getIsSuccess() != 1) {
                throw new LDRException("Failed clear pin. ErrorCode " + result.getErrorCode());
            }
        } else {
            if (response.getStatusCode() == 403) {
                throw new LDRException("Failed authentication in livedoor.");
            }
            throw new LDRException("Failed clear pin.");
        }
    }

    @Override
    public long addFeed(String feedUrl) throws LDRException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("feedlink", feedUrl);
        params.put("ApiKey", this.apiKey);
        LDRHttpResponse response = this.doPost("http://reader.livedoor.com/api/feed/subscribe", params);
        if (response.getStatusCode() == 200) {
            ApiResponseStatus result = (ApiResponseStatus)JSON.decode((String)response.getBody(), ApiResponseStatus.class);
            if (result.getErrorCode() != 0 || result.getIsSuccess() != 1) {
                throw new LDRException("Failed add feed. ErrorCode " + result.getErrorCode());
            }
            return result.getSubscribeId();
        }
        if (response.getStatusCode() == 403) {
            throw new LDRException("Failed authentication in livedoor.");
        }
        throw new LDRException("Failed add feed.");
    }

    @Override
    public void removeFeed(long subscribeId) throws LDRException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("subscribe_id", Long.toString(subscribeId));
        params.put("ApiKey", this.apiKey);
        LDRHttpResponse response = this.doPost("http://reader.livedoor.com/api/feed/unsubscribe", params);
        if (response.getStatusCode() == 200) {
            ApiResponseStatus result = (ApiResponseStatus)JSON.decode((String)response.getBody(), ApiResponseStatus.class);
            if (result.getErrorCode() != 0 || result.getIsSuccess() != 1) {
                throw new LDRException("Failed remove feed. ErrorCode " + result.getErrorCode());
            }
        } else {
            if (response.getStatusCode() == 403) {
                throw new LDRException("Failed authentication in livedoor.");
            }
            throw new LDRException("Failed remove feed.");
        }
    }

    @Override
    public Feed[] getAllFeeds(boolean unread) throws LDRException {
        return this.getAllFeeds(unread, 0);
    }

    @Override
    public Feed[] getAllFeeds(boolean unread, int limit) throws LDRException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("unread", unread ? "1" : "0");
        params.put("limit", Integer.toString(limit));
        LDRHttpResponse response = this.doPost("http://reader.livedoor.com/api/subs", params);
        return (Feed[])JSON.decode((String)response.getBody(), Feed[].class);
    }

    @Override
    public Feed[] getAllFeeds(boolean unread, int limit, long fromSubscribeId) throws LDRException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Article getAllArticle(long subscribeId) throws LDRException {
        return this.getAllArticle(subscribeId, 0, 200);
    }

    @Override
    public Article getAllArticle(long subscribeId, int limit, int offset) throws LDRException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("subscribe_id", Long.toString(subscribeId));
        params.put("limit", Integer.toString(limit));
        params.put("offset", Integer.toString(offset));
        LDRHttpResponse response = this.doPost("http://reader.livedoor.com/api/all", params);
        return (Article)JSON.decode((String)response.getBody(), Article.class);
    }

    @Override
    public Article getUnreadArticle(long subscribeId) throws LDRException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("subscribe_id", Long.toString(subscribeId));
        LDRHttpResponse response = this.doPost("http://reader.livedoor.com/api/unread", params);
        return (Article)JSON.decode((String)response.getBody(), Article.class);
    }

    @Override
    public void touchAll(long subscribeId) throws LDRException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("subscribe_id", Long.toString(subscribeId));
        params.put("ApiKey", this.apiKey);
        LDRHttpResponse response = this.doPost("http://reader.livedoor.com/api/touch_all", params);
        if (response.getStatusCode() == 200) {
            ApiResponseStatus result = (ApiResponseStatus)JSON.decode((String)response.getBody(), ApiResponseStatus.class);
            if (result.getErrorCode() != 0 || result.getIsSuccess() != 1) {
                throw new LDRException("Failed touch all. ErrorCode " + result.getErrorCode());
            }
        } else {
            if (response.getStatusCode() == 403) {
                throw new LDRException("Failed authentication in livedoor.");
            }
            throw new LDRException("Failed touch all.");
        }
    }

    @Override
    public void setRate(long subscribeId, int rate) throws LDRException {
        if (rate < 0 || 5 < rate) {
            throw new IllegalArgumentException("\u30ec\u30fc\u30c8\u306f0\uff5e5\u306e\u7bc4\u56f2\u3067\u6307\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("subscribe_id", Long.toString(subscribeId));
        params.put("rate", Integer.toString(rate));
        params.put("ApiKey", this.apiKey);
        LDRHttpResponse response = this.doPost("http://reader.livedoor.com/api/feed/set_rate", params);
        if (response.getStatusCode() == 200) {
            ApiResponseStatus result = (ApiResponseStatus)JSON.decode((String)response.getBody(), ApiResponseStatus.class);
            if (result.getErrorCode() != 0 || result.getIsSuccess() != 1) {
                throw new LDRException("Failed set rate. ErrorCode " + result.getErrorCode());
            }
        } else {
            if (response.getStatusCode() == 403) {
                throw new LDRException("Failed authentication in livedoor.");
            }
            throw new LDRException("Failed set rate.");
        }
    }

    @Override
    public void moveFeed(long subscribeId) throws LDRException {
        this.moveFeed(subscribeId, "");
    }

    @Override
    public void moveFeed(long subscribeId, String folderName) throws LDRException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("subscribe_id", Long.toString(subscribeId));
        params.put("to", folderName);
        params.put("ApiKey", this.apiKey);
        LDRHttpResponse response = this.doPost("http://reader.livedoor.com/api/feed/move", params);
        if (response.getStatusCode() == 200) {
            ApiResponseStatus result = (ApiResponseStatus)JSON.decode((String)response.getBody(), ApiResponseStatus.class);
            if (result.getErrorCode() != 0 || result.getIsSuccess() != 1) {
                throw new LDRException("Failed move folder. ErrorCode " + result.getErrorCode());
            }
        } else {
            if (response.getStatusCode() == 403) {
                throw new LDRException("Failed authentication in livedoor.");
            }
            throw new LDRException("Failed move folder.");
        }
    }

    @Override
    public int getNotify(String livedoorId) throws LDRException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("user", livedoorId);
        LDRHttpResponse response = this.doGet("http://rpc.reader.livedoor.com/notify", params);
        if (response.getStatusCode() == 200) {
            String[] responseText = response.getBody().split("\\|");
            return new Integer(responseText[1]);
        }
        throw new LDRException("Failed notify.");
    }

    @Override
    public FeedInfo[] discover(String url) throws LDRException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("url", url);
        LDRHttpResponse response = this.doGet("http://reader.livedoor.com/api/feed/discover", params);
        return (FeedInfo[])JSON.decode((String)response.getBody(), FeedInfo[].class);
    }
}

