/**
 * IP å󥸥饤֥(Unix)
 * IPå󥸥㥨ȥ饹
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "IpMessenger.h"
#include "IpMessengerImpl.h"

//NICκ
#define IFR_MAX 20

static IpMessengerAgent *myInstance = NULL;

#ifdef HAVE_PTHREAD
static pthread_mutex_t instanceMutex;
static int mutex_init_result = pthread_mutex_init( &instanceMutex, NULL );
#endif

IpMessengerEvent::~IpMessengerEvent(){};
/**
 * IP å󥸥㥨ȥ饹Υ󥹥󥹤롣
 * SingletonѥѤƤΤǡۥͣΥ󥹥󥹤ǤʤФʤʤ
 * Υ󥹥󥹤ϥåɥդǤʤ
 */
IpMessengerAgent *
IpMessengerAgent::GetInstance()
{
#ifdef HAVE_PTHREAD
	pthread_mutex_lock( &instanceMutex );
#endif
	if ( myInstance == NULL ) {
		myInstance = new IpMessengerAgent();
	}
#ifdef HAVE_PTHREAD
	pthread_mutex_unlock( &instanceMutex );
#endif
	return myInstance;
}

/**
 * IP å󥸥㥨ȥ饹Υ󥹥󥹤롣
 * Υ᥽åɤȤäƥ֥ȤʤФʤʤ
 * 饤֥̤ʤľdelete줿ϤθưˤĤƴΤʤ
 * Υ󥹥󥹤ϥåɥդǤʤ
 */
void
IpMessengerAgent::Release()
{
#ifdef HAVE_PTHREAD
	pthread_mutex_lock( &instanceMutex );
#endif
	if ( myInstance == NULL ) {
#ifdef HAVE_PTHREAD
		pthread_mutex_unlock( &instanceMutex );
#endif
		return;
	}
	delete myInstance;
	myInstance = NULL;
#ifdef HAVE_PTHREAD
	pthread_mutex_unlock( &instanceMutex );
#endif
}

/**
 * IP å󥸥㥨ȥ饹Υ󥹥ȥ饯
 * Ź沽ݡȤͭʾ硢ۥȤRSAԤ
 * ѥåNo˻Ѥɤǽ롣
 * ե̾Сåȥåפ롣ѴԤʤNullConverterǥեȡ
 * ͥåȥν
 * Υ󥹥󥹤ϥåɥդǤʤ
 */
IpMessengerAgent::IpMessengerAgent()
{
	ipmsgImpl = IpMessengerAgentImpl::GetInstance();
}

/**
 * IP å󥸥㥨ȥ饹Υǥȥ饯
 * ޤȡ
 * Ź沽ݡȤͭʾ硢ۥȤRSA˴Ԥ
 * ƺѤΥե̾С롣
 * åȤΥ
 * Υ󥹥󥹤ϥåɥդǤʤ
 */
IpMessengerAgent::~IpMessengerAgent()
{
	IpMessengerAgentImpl::Release();
}

/**
 * IP å󥸥㥨ȥ饹ΥͥåȥƵư롣
 * ޤȡ
 * ͥåȥ
 * ͥåȥ
 * ٥
 * Υ󥹥󥹤ϥåɥդǤʤ
 */
void
IpMessengerAgent::RestartNetwork()
{
	ipmsgImpl->RestartNetwork();
}

/**
 * ե̾СΥå
 * Υ᥽åɤϥåɥդǤʤ
 * @retval СΥɥ쥹
 */
FileNameConverter *
IpMessengerAgent::GetFileNameConverter()
{
	return ipmsgImpl->GetFileNameConverter();
}

/**
 * ե̾СΥå
 * ƺѤΥե̾С롣
 * Сγơ
 * Υ᥽åɤϥåɥդǤʤ
 * @param conv СΥɥ쥹ưŪ˺Τǡå˺ƤϤʤʤҡ׾˺뤳ȡ
 */
void
IpMessengerAgent::SetFileNameConverter( FileNameConverter *conv )
{
	ipmsgImpl->SetFileNameConverter( conv );
}

/**
 * ٥ȥ֥ȤΥå
 * Υ᥽åɤϥåɥդǤʤ
 * @retval ٥ȥ֥ȤΥɥ쥹
 */
HostListComparator *
IpMessengerAgent::GetSortHostListComparator()
{
	return ipmsgImpl->GetSortHostListComparator();
}; 

/**
 * ۥȥꥹӥ֥ȤΥå
 * ƺѤΥۥȥꥹӥ֥Ȥ롣
 * ۥȥꥹӥ֥Ȥγơ
 * Υ᥽åɤϥåɥդǤʤ
 * @param comparator ۥȥꥹӥ֥ȤΥɥ쥹ưŪ˺Τǡå˺ƤϤʤʤҡ׾˺뤳ȡ
 */
void
IpMessengerAgent::SetSortHostListComparator( HostListComparator *comparator )
{
	ipmsgImpl->SetSortHostListComparator( comparator );
}

/**
 * ٥ȥ֥ȤΥå
 * Υ᥽åɤϥåɥդǤʤ
 * @retval ٥ȥ֥ȤΥɥ쥹
 */
IpMessengerEvent *
IpMessengerAgent::GetEventObject()
{
	return ipmsgImpl->GetEventObject();
}; 

/**
 * ٥ȥ֥ȤΥå
 * ƺѤΥ٥ȥ֥Ȥ롣
 * ٥ȥ֥Ȥγơ
 * Υ᥽åɤϥåɥդǤʤ
 * @param conv ٥ȥ֥ȤΥɥ쥹ưŪ˺Τǡå˺ƤϤʤʤҡ׾˺뤳ȡ
 */
void
IpMessengerAgent::SetEventObject( IpMessengerEvent *evt )
{
	ipmsgImpl->SetEventObject( evt );
}

/**
 * NICξ롣
 * Ѥͥåȥ󥿡եIPɥ쥹롣ʥ롼ץХåΤƤNIC
 * @param nics ͥåȥ󥿡եΰ
 * Υ᥽åɤϥåɥդǤʤ
 */
void
IpMessengerAgent::GetNetworkInterfaceInfo( vector<NetworkInterface>& nics )
{
	IpMessengerAgentImpl::GetNetworkInterfaceInfo( nics );
}

/**
 * ʥӥΡˡ
 * NOOPERATIONѥåȤͥåȥѲǽɤǧǥۥȥꥹȤ
 * BR_ENTRY֥ɥ㥹ȡ
 * ѥåȤǡۥȥꥹȤټ
 * Υ᥽åɤϥåɥդǤʤ
 */
void
IpMessengerAgent::Login( string nickname, string groupName )
{
	ipmsgImpl->Login( nickname, groupName );
}

/**
 * ȡʥӥæΡˡ
 * BR_EXIT֥ɥ㥹ȡ
 * Υ᥽åɤϥåɥդǤʤ
 */
void
IpMessengerAgent::Logout()
{	
	ipmsgImpl->Logout();
}

/**
 * ۥȥꥹȼ
 * @retval ȤݻƤHostList֥
 * @retval ۥȥꥹ
 */
HostList&
IpMessengerAgent::GetHostList()
{
	return ipmsgImpl->GetHostList();
}

/**
 * ۥȥꥹȹ
 * BR_ISGETLIST2֥ɥ㥹ȡ
 * ¾Υ᥽åɡANSLISTˤˤƼޤԵʸ޲ޤǡ
 * ۥȥꥹȤιۤANSLIST˹ԤΤǡΥ᥽åɤǤϤҤԵ
 * ۥȥꥹȤANSLISTɲá뤳ȤΤǾƱۥȥꥹȤ֤Ȥϸ¤ʤ
 * Υ᥽åɤϥåɥդǤʤ
 * @retval HostList֥
 */
HostList&
IpMessengerAgent::UpdateHostList()
{
	return ipmsgImpl->UpdateHostList();
}

/**
 * Ժߥ⡼ɤɤȽꡣ
 * @retval ѤԺߥ⡼ɤ֤
 * Υ᥽åɤϥåɥդǤʤ
 */
bool
IpMessengerAgent::IsAbsence()
{
	return ipmsgImpl->IsAbsence();
}
/**
 * Ժߥ⡼ɤ򥯥ꥢ롣
 * Υ᥽åɤϥåɥդǤʤ
 */
void
IpMessengerAgent::ResetAbsence()
{
	ipmsgImpl->ResetAbsence();
}

/**
 * Ժߥ⡼ɤꤹ롣
 * @param encoding 륨󥳡ǥ
 * @param absenceModes AbsenceMode֥ȤΥ٥ʼưʣ󥳡ǥб뤿
 * Υ᥽åɤϥåɥդǤʤ
 */
void
IpMessengerAgent::SetAbsence( string encoding, vector<AbsenceMode> absenceModes )
{
	ipmsgImpl->SetAbsence( encoding, absenceModes );
}

/**
 * å
 * @param host ۥ
 * @param msg å
 * @param isSecret 񤫤ɤ򼨤ե饰
 * @param isLockPassword Ĥɤ򼨤ե饰
 * @param hostCountAtSameTime Ʊۥȿ
 * @param opt ץ
 * Υ᥽åɤϥåɥդǤʤ
 */
SentMessage
IpMessengerAgent::SendMsg( HostListItem host, string msg, bool isSecret, bool isLockPassword, int hostCountAtSameTime, unsigned long opt )
{
	return ipmsgImpl->SendMsg( host, msg, isSecret, isLockPassword, hostCountAtSameTime, opt );
}

/**
 * å
 * @param host ۥ
 * @param msg å
 * @param isSecret 񤫤ɤ򼨤ե饰
 * @param file źեե
 * @param isLockPassword Ĥɤ򼨤ե饰
 * @param hostCountAtSameTime Ʊۥȿ
 * @param opt ץ
 * Υ᥽åɤϥåɥդǤʤ
 */
SentMessage
IpMessengerAgent::SendMsg( HostListItem host, string msg, bool isSecret, AttachFile file, bool isLockPassword, int hostCountAtSameTime, unsigned long opt )
{
	return ipmsgImpl->SendMsg( host, msg, isSecret, file, isLockPassword, hostCountAtSameTime, opt );
}

/**
 * å
 * @param host ۥ
 * @param msg å
 * @param isSecret 񤫤ɤ򼨤ե饰
 * @param files źեե뷲
 * @param isLockPassword Ĥɤ򼨤ե饰
 * @param hostCountAtSameTime Ʊۥȿ
 * @param opt ץ
 * Υ᥽åɤϥåɥդǤʤ
 */
SentMessage
IpMessengerAgent::SendMsg( HostListItem host, string msg, bool isSecret, AttachFileList files, bool isLockPassword, int hostCountAtSameTime, unsigned long opt )
{
	return ipmsgImpl->SendMsg( host, msg, isSecret, files, isLockPassword, hostCountAtSameTime, opt );
}

/**
 * ϿѤΥ֥ɥ㥹ȥɥ쥹
 * @param addr ϿѤΥ֥ɥ㥹ȥɥ쥹
 * Υ᥽åɤϥåɥդǤʤ
 */
void
IpMessengerAgent::ClearBroadcastAddress()
{
	ipmsgImpl->ClearBroadcastAddress();
}

/**
 * ϿѤΥ֥ɥ㥹ȥɥ쥹
 * @param addr ϿѤΥ֥ɥ㥹ȥɥ쥹
 * Υ᥽åɤϥåɥդǤʤ
 */
void
IpMessengerAgent::DeleteBroadcastAddress( string addr )
{
	ipmsgImpl->DeleteBroadcastAddress( addr );
}

/**
 * ֥ɥ㥹ȥɥ쥹Ͽ
 * @param addr Ͽ֥ɥ㥹ȥɥ쥹
 * Υ᥽åɤϥåɥդǤʤ
 */
void
IpMessengerAgent::AddBroadcastAddress( string addr )
{
	ipmsgImpl->AddBroadcastAddress( addr );
}

/**
 * оݥۥȤΥС
 * GETINFOѥåȤ
 * ¾Υ᥽åɡANSINFOˤˤƼޤԵʸ޲ޤǡ
 * IPɥ쥹ǥޥå󥰤ANSINFOǹ줿С
 * @param host оݤΥۥ
 * @retval оݥۥȤΥС
 * Υ᥽åɤϥåɥդǤʤ
 */
string
IpMessengerAgent::GetInfo( HostListItem& host )
{
	return ipmsgImpl->GetInfo( host );
#if 0
#endif
}

/**
 * оݥۥȤԺʸ
 * GETABSENCEINFOѥåȤ
 * ¾Υ᥽åɡANSABSENCEINFOˤˤƼޤԵʸ޲ޤǡ
 * IPɥ쥹ǥޥå󥰤ANSABSENCEINFOǹ줿С
 * @param host оݤΥۥ
 * @retval оݥۥȤԺʸ
 * Υ᥽åɤϥåɥդǤʤ
 */
string
IpMessengerAgent::GetAbsenceInfo( HostListItem& host )
{
	return ipmsgImpl->GetAbsenceInfo( host );
}

/**
 * ݻΥۥȥꥹȤ饰롼ץꥹȤ롣
 * @retval 롼ץꥹ
 * Υ᥽åɤϥåɥդǤʤ
 */
vector<GroupItem>
IpMessengerAgent::GetGroupList()
{
	return ipmsgImpl->GetGroupList();
}

/**
 * ˥åȤΤ롣
 * @param msg å֥ȡ
 * Υ᥽åɤϥåɥդǤʤ
 */
void
IpMessengerAgent::DeleteNotify( RecievedMessage msg )
{
	ipmsgImpl->DeleteNotify( msg );
}

/**
 * ˥åȤΤ롣
 * @param msg å֥ȡ
 * Υ᥽åɤϥåɥդǤʤ
 */
void
IpMessengerAgent::ConfirmMessage( RecievedMessage &msg )
{
	ipmsgImpl->ConfirmMessage( msg );
}

/**
 * ѥåꥹȤ˳줿Ȥޡ롣
 * @param msg å֥ȡ
 * Υ᥽åɤϥåɥդǤʤ
 */
void
IpMessengerAgent::AcceptConfirmNotify( SentMessage msg )
{
	ipmsgImpl->AcceptConfirmNotify( msg );
}
		
// private methods start here

/**
 * ʥ桼ˡ
 * Υ᥽åɤϥåɥդǤʤ
 */
int
IpMessengerAgent::Process()
{
	return ipmsgImpl->Process();
}

/**
 * åθĿ롣
 * @retval åθĿ
 */
int
IpMessengerAgent::GetRecievedMessageCount()
{
	return ipmsgImpl->GetRecievedMessageCount();
}

/**
 * åļФåꥹȤ롣
 * @retval å֥ȡ
 */
RecievedMessage
IpMessengerAgent::PopRecievedMessage()
{
	return ipmsgImpl->PopRecievedMessage();
}

/**
 * ѥåꥹȤΥݥ󥿤롣
 * @retval ѥåꥹȤΥݥ󥿡
 */
SentMessageList *
IpMessengerAgent::GetSentMessages()
{
	return ipmsgImpl->GetSentMessages();
}

/**
 * ѥåꥹȤΥԡ롣
 * @retval ѥåꥹȤΥԡ
 */
SentMessageList
IpMessengerAgent::CloneSentMessages()
{
	return ipmsgImpl->CloneSentMessages();
}

/**
 * ̾Υå
 * @retval ̾
 */
string
IpMessengerAgent::LoginName()
{
	return ipmsgImpl->LoginName();
}

/**
 * ۥ̾Υå
 * @retval ۥ̾
 */
string
IpMessengerAgent::HostName()
{
	return ipmsgImpl->HostName();
}

/**
 * 륢åפΥå
 * @retval 륢å
 */
bool
IpMessengerAgent::IsDialup()
{
	return ipmsgImpl->IsDialup();
}

/**
 * 륢åפΥå
 * @param 륢å
 */
void
IpMessengerAgent::setIsDialup( bool isDialup )
{
	ipmsgImpl->setIsDialup( isDialup );
}

/**
 * ɻ˥ե뤬ѹ줿˶ػߤ뤫ɤΥե饰Υå
 * @retval ɻ˥ե뤬ѹ줿˶ػߤ뤫ɤΥե饰
 */
bool
IpMessengerAgent::AbortDownloadAtFileChanged()
{
	return ipmsgImpl->AbortDownloadAtFileChanged();
}

/**
 * ɻ˥ե뤬ѹ줿˶ػߤ뤫ɤΥե饰Υå
 * @param ɻ˥ե뤬ѹ줿˶ػߤ뤫ɤΥե饰
 */
void
IpMessengerAgent::setAbortDownloadAtFileChanged( bool isAbort )
{
	ipmsgImpl->setAbortDownloadAtFileChanged( isAbort );
}

/**
 * å¸뤫ɤΥե饰Υå
 * @retval å¸뤫ɤΥե饰
 */
bool
IpMessengerAgent::SaveSentMessage()
{
	return ipmsgImpl->SaveSentMessage();
}

/**
 * å¸뤫ɤΥե饰Υå
 * @param å¸뤫ɤΥե饰
 */
void
IpMessengerAgent::setSaveSentMessage( bool isSave )
{
	ipmsgImpl->setSaveSentMessage( isSave );
}

/**
 * å¸뤫ɤΥե饰Υå
 * @retval å¸뤫ɤΥե饰
 */
bool
IpMessengerAgent::SaveRecievedMessage()
{
	return ipmsgImpl->SaveRecievedMessage();
}

/**
 * å¸뤫ɤΥե饰Υå
 * @param å¸뤫ɤΥե饰
 */
void
IpMessengerAgent::setSaveRecievedMessage( bool isSave )
{
	ipmsgImpl->setSaveRecievedMessage( isSave );
}
//end of source
