/**
 * IP å󥸥饤֥(Unix)
 * IPå󥸥㥨ȥ饹
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "IpMessenger.h"
#include "IpMessengerImpl.h"
#include "ipmsg.h"
#ifdef HAVE_PTHREAD
#include <pthread.h>
#endif	// HAVE_PTHREAD
using namespace std;

static IpMessengerAgentImpl *myInstance = NULL;

void *GetFileDataThread( void *param );
void *GetDirFilesThread( void *param );

#ifdef HAVE_PTHREAD
static pthread_mutex_t instanceMutex;
static int mutex_init_result = pthread_mutex_init( &instanceMutex, NULL );
#endif

class IpMessengerNullEvent: public IpMessengerEvent {
	public:
		virtual void UpdateHostListAfter( HostList& hostList ){ printf("UpdateHostListAfter\n"); };
		virtual bool GetHostListRetryError(){ printf("GetHostListRetryError\n");return false; };
		virtual bool RecieveAfter( RecievedMessage& msg ){ printf("RecieveAfter\n");return false; };
		virtual void SendAfter( SentMessage& msg ){ printf("SendAfter\n"); };
		virtual bool SendRetryError( SentMessage& msg ){ printf("SendRetryError\n");return false; };
		virtual void OpenAfter( SentMessage& msg ){ printf("OpenAfter\n"); };
		virtual void DownloadStart( RecievedMessage& msg, AttachFile& file, DownloadInfo &info, void *data ){ printf("DownloadStart\n"); };
		virtual void DownloadProcessing( RecievedMessage& msg, AttachFile& file, DownloadInfo &info, void *data ){ printf("DownloadProcessing\n"); };
		virtual void DownloadEnd( RecievedMessage& msg, AttachFile& file, DownloadInfo &info, void *data ){ printf("DownloadEnd\n"); };
		virtual bool DownloadError( RecievedMessage& msg, AttachFile& file, DownloadInfo &info, void *data ){ printf("DownloadError\n"); return false; };
		virtual void EntryAfter( HostList& hostList ){ printf("EntryAfter\n"); };
		virtual void ExitAfter( HostList& hostList ){ printf("ExitAfter\n"); };
		virtual void AbsenceModeChangeAfter( HostList& hostList ){ printf("AbsenceModeChangeAfter\n"); };
		virtual void VersionInfoRecieveAfter( HostListItem &host, string version ){ printf("VersionInfoRecieveAfter\n"); };
		virtual void AbsenceDetailRecieveAfter( HostListItem &host, string absenceDetail ){ printf("AbsenceDetailRecieveAfter\n"); };
};

/**
 * IP å󥸥㥨ȥ饹Υ󥹥󥹤롣
 * SingletonѥѤƤΤǡۥͣΥ󥹥󥹤ǤʤФʤʤ
 * Υ󥹥󥹤ϥåɥդǤʤ
 */
IpMessengerAgentImpl *
IpMessengerAgentImpl::GetInstance()
{
#ifdef HAVE_PTHREAD
	pthread_mutex_lock( &instanceMutex );
#endif	// HAVE_PTHREAD
	if ( myInstance == NULL ) {
		myInstance = new IpMessengerAgentImpl();
	}
#ifdef HAVE_PTHREAD
	pthread_mutex_unlock( &instanceMutex );
#endif	// HAVE_PTHREAD
	return myInstance;
}

/**
 * IP å󥸥㥨ȥ饹Υ󥹥󥹤롣
 * Υ᥽åɤȤäƥ֥ȤʤФʤʤ
 * 饤֥̤ʤľdelete줿ϤθưˤĤƴΤʤ
 * Υ󥹥󥹤ϥåɥդǤʤ
 */
void
IpMessengerAgentImpl::Release()
{
#ifdef HAVE_PTHREAD
	pthread_mutex_lock( &instanceMutex );
#endif	// HAVE_PTHREAD
	if ( myInstance == NULL ) {
#ifdef HAVE_PTHREAD
		pthread_mutex_unlock( &instanceMutex );
#endif	// HAVE_PTHREAD
		return;
	}
	delete myInstance;
	myInstance = NULL;
#ifdef HAVE_PTHREAD
	pthread_mutex_unlock( &instanceMutex );
#endif	// HAVE_PTHREAD
}

/**
 * IP å󥸥㥨ȥ饹Υ󥹥ȥ饯
 * Ź沽ݡȤͭʾ硢ۥȤRSAԤ
 * ѥåNo˻Ѥɤǽ롣
 * ե̾Сåȥåפ롣ѴԤʤNullConverterǥեȡ
 * ͥåȥν
 * Υ󥹥󥹤ϥåɥդǤʤ
 */
IpMessengerAgentImpl::IpMessengerAgentImpl()
{
	CryptoInit();
	srandom( time( NULL ) );
	converter = new NullFileNameConverter();
	compare = new HostListDefaultComparator();
	setAbortDownloadAtFileChanged( false );
	setSaveSentMessage( true );
	setSaveRecievedMessage( true );
	IpMessengerAgentImpl::GetNetworkInterfaceInfo( NICs );
	NetworkInit();
	ResetAbsence();
	event = new IpMessengerNullEvent();
}

/**
 * IP å󥸥㥨ȥ饹Υǥȥ饯
 * ޤȡ
 * Ź沽ݡȤͭʾ硢ۥȤRSA˴Ԥ
 * ƺѤΥե̾С롣
 * åȤΥ
 * Υ󥹥󥹤ϥåɥդǤʤ
 */
IpMessengerAgentImpl::~IpMessengerAgentImpl()
{
	Logout();
	CryptoEnd();
	delete converter;
	delete compare;
	delete event;
	NetworkEnd();
}

/**
 * IP å󥸥㥨ȥ饹ΥͥåȥƵư롣
 * ޤȡ
 * ͥåȥ
 * ͥåȥ
 * ٥
 * Υ󥹥󥹤ϥåɥդǤʤ
 */
void
IpMessengerAgentImpl::RestartNetwork()
{
	Logout();
	NetworkEnd();
	NetworkInit();
	Login( Nickname, GroupName );
}

/**
 * ե̾СΥå
 * Υ᥽åɤϥåɥդǤʤ
 * @retval СΥɥ쥹
 */
FileNameConverter *
IpMessengerAgentImpl::GetFileNameConverter()
{
	return converter;
}

/**
 * ե̾СΥå
 * ƺѤΥե̾С롣
 * Сγơ
 * Υ᥽åɤϥåɥդǤʤ
 * @param conv СΥɥ쥹ưŪ˺Τǡå˺ƤϤʤʤҡ׾˺뤳ȡ
 */
void
IpMessengerAgentImpl::SetFileNameConverter( FileNameConverter *conv )
{
	if ( conv == NULL ){
		return;
	}
	delete converter;
	converter = conv;
}

/**
 * ۥȥꥹӥ֥ȤΥå
 * Υ᥽åɤϥåɥդǤʤ
 * @retval ۥȥꥹӥ֥ȤΥɥ쥹
 */
HostListComparator *
IpMessengerAgentImpl::GetSortHostListComparator()
{
	return compare;
}; 

/**
 * ۥȥꥹӥ֥ȤΥå
 * ƺѤΥۥȥꥹӥ֥Ȥ롣
 * ۥȥꥹӥ֥Ȥγơ
 * Υ᥽åɤϥåɥդǤʤ
 * @param comparator ۥȥꥹӥ֥ȤΥɥ쥹ưŪ˺Τǡå˺ƤϤʤʤҡ׾˺뤳ȡ
 */
void
IpMessengerAgentImpl::SetSortHostListComparator( HostListComparator *comparator )
{
	if ( comparator == NULL ){
		return;
	}
	delete compare;
	compare = comparator;
}

/**
 * ٥ȥ֥ȤΥå
 * Υ᥽åɤϥåɥդǤʤ
 * @retval ٥ȥ֥ȤΥɥ쥹
 */
IpMessengerEvent *
IpMessengerAgentImpl::GetEventObject()
{
	return event;
}; 

/**
 * ٥ȥ֥ȤΥå
 * ƺѤΥ٥ȥ֥Ȥ롣
 * ٥ȥ֥Ȥγơ
 * Υ᥽åɤϥåɥդǤʤ
 * @param evt ٥ȥ֥ȤΥɥ쥹ưŪ˺Τǡå˺ƤϤʤʤҡ׾˺뤳ȡ
 */
void
IpMessengerAgentImpl::SetEventObject( IpMessengerEvent *evt )
{
	if ( evt == NULL ){
		return;
	}
	delete event;
	event = evt;
}

/**
 * NICξ롣
 * Ѥͥåȥ󥿡եIPɥ쥹롣ʥ롼ץХåΤƤNIC
 * @param nics ͥåȥ󥿡եΰ
 * Υ᥽åɤϥåɥդǤʤ
 */
void
IpMessengerAgentImpl::GetNetworkInterfaceInfo( vector<NetworkInterface>& nics )
{
	//ΤΥåȤ
	int fd;
	fd = socket(AF_INET, SOCK_DGRAM, 0);
	struct ifconf ifc;

	struct ifreq ifr[IFR_MAX];
	ifc.ifc_len = sizeof(ifr);
	ifc.ifc_ifcu.ifcu_buf = (char *)ifr;

	ioctl(fd, SIOCGIFCONF, &ifc);
	int nifs = ifc.ifc_len / sizeof(struct ifreq);

	/* 롼ץХåΤƤIPɥ쥹о */
	/* ƤNIC */
	for( int i = 0; i < nifs; i++ ){
		char ipaddrbuf[100];
		if ( strcmp("127.0.0.1", inet_ntoa_r( ( (struct sockaddr_in *)&ifr[i].ifr_addr )->sin_addr.s_addr, ipaddrbuf, sizeof( ipaddrbuf ) ) ) == 0 ){
			continue;
		}
#if defined(DEBUG) || !defined(NDEBUG)
		printf( "dev=%s,ipaddress=%s\n", ifr[i].ifr_name, inet_ntoa_r( ( (struct sockaddr_in *)&ifr[i].ifr_addr )->sin_addr.s_addr, ipaddrbuf, sizeof( ipaddrbuf ) ) );fflush( stdout );
#endif
		NetworkInterface ni;
		ni.setDeviceName( ifr[i].ifr_name );
		ni.setPortNo( IPMSG_DEFAULT_PORT );
		ni.setIpAddress( inet_ntoa_r( ( (struct sockaddr_in *)&ifr[i].ifr_addr )->sin_addr.s_addr, ipaddrbuf, sizeof( ipaddrbuf ) ) );
		nics.push_back( ni );
#if defined(DEBUG) || !defined(NDEBUG)
		printf( "NIC device=%s[IpAddress=%s][Port=%d]\n",nics[nics.size() - 1].DeviceName().c_str(),nics[nics.size()-1].IpAddress().c_str(), nics[nics.size()-1].PortNo() );fflush( stdout );
#endif
	}

	//ΤΥåȤĤ롣
	close(fd);
}

/**
 * ͥåȥϢν
 * Ķѿۥ̾ʽʤlocalhost
 * Ķѿ桼̾ʽʤuid
 * Υ᥽åɤϥåɥդǤʤ
 */
void
IpMessengerAgentImpl::NetworkInit()
{
	char buf[100];
	char *env;

	env = getenv( "HOSTNAME" );
	if ( env == NULL ){
		_HostName = "localhost";
	} else {
		_HostName = env;
	}
	_LoginName = "";
	env = getenv( "USERNAME" );
	if ( env != NULL ){
		_LoginName = env;
	}
	if ( _LoginName == "" ){
		env = getenv( "USER" );
		if ( env != NULL ) {
			_LoginName = env;
		}
	}
	if ( _LoginName == "" ){
		_LoginName = snprintf( buf, sizeof( buf ), "%d", getuid() );
	}

#ifdef HAVE_OPENSSL
	DecryptErrorMessage = "\r\n"\
						  " ==== AutoReply(DecryptErr) ====\r\n" \
						  "  My PubKey is updated, I can't\r\n" \
						  "  receive your message.\r\n" \
						  "  Please press refresh button.\r\n" \
						  " ==============================";
#endif	//HAVE_OPENSSL
	InitSend();
	InitRecv( NICs );
}

/**
 * ͥåȥϢν
 * ƤΥåȤĤ롣
 * Υ᥽åɤϥåɥդǤʤ
 */
void
IpMessengerAgentImpl::NetworkEnd()
{
	for( unsigned int i = 0; i < udp_sd.size(); i++ ){
		close(udp_sd[i]);
	}
	for( unsigned int i = 0; i < tcp_sd.size(); i++ ){
		close(tcp_sd[i]);
	}
}

/**
 * ʥӥΡˡ
 * NOOPERATIONѥåȤͥåȥѲǽɤǧǥۥȥꥹȤ
 * BR_ENTRY֥ɥ㥹ȡ
 * ѥåȤǡۥȥꥹȤټ
 * Υ᥽åɤϥåɥդǤʤ
 */
void
IpMessengerAgentImpl::Login( string nickname, string groupName )
{
	char sendBuf[MAX_UDPBUF];
	int sendBufLen;
	char optBuf[MAX_UDPBUF];
	int optBufLen = 0;

	SendNoOperation();

#if defined(DEBUG) || !defined(NDEBUG)
	memset( sendBuf, 0, MAX_UDPBUF );
#endif
	if ( nickname != "" ) {
		Nickname = nickname;
	} else {
		Nickname = _LoginName;
	}
	GroupName = groupName;
	optBufLen = snprintf( optBuf, sizeof( optBuf ), "%s", Nickname.c_str() );
	optBuf[ optBufLen ] = '\0';
	optBufLen++;
	snprintf( &optBuf[ optBufLen ], sizeof( optBuf ) - optBufLen - 1, "%s", GroupName.c_str() );
	optBufLen += GroupName.size();
	optBuf[ optBufLen ] = '\0';
	
	sendBufLen = CreateNewPacketBuffer( AddCommonCommandOption( IPMSG_BR_ENTRY ),
										_LoginName, _HostName,
										optBuf, optBufLen,
										sendBuf, sizeof( sendBuf ) );
	SendBroadcast( IPMSG_BR_ENTRY, sendBuf, sendBufLen );
	RecvPacket();
	//0.05äޤġ
	usleep( 50000L );
	RecvPacket();

}

/**
 * ȡʥӥæΡˡ
 * BR_EXIT֥ɥ㥹ȡ
 * Υ᥽åɤϥåɥդǤʤ
 */
void
IpMessengerAgentImpl::Logout()
{
	char sendBuf[MAX_UDPBUF];
	int sendBufLen;

	sendBufLen = CreateNewPacketBuffer( AddCommonCommandOption( IPMSG_BR_EXIT ),
										_LoginName, _HostName,
										NULL, 0,
										sendBuf, sizeof( sendBuf ) );
	SendBroadcast( IPMSG_BR_EXIT, sendBuf, sendBufLen );
	RecvPacket();
}

/**
 * ۥȥꥹȼ
 * @retval ȤݻƤHostList֥
 * @retval ۥȥꥹ
 */
HostList&
IpMessengerAgentImpl::GetHostList()
{
	return hostList;
}

/**
 * ۥȥꥹȹ
 * BR_ISGETLIST2֥ɥ㥹ȡ
 * ¾Υ᥽åɡANSLISTˤˤƼޤԵʸ޲ޤǡ
 * ۥȥꥹȤιۤANSLIST˹ԤΤǡΥ᥽åɤǤϤҤԵ
 * ۥȥꥹȤANSLISTɲá뤳ȤΤǾƱۥȥꥹȤ֤Ȥϸ¤ʤ
 * Υ᥽åɤϥåɥդǤʤ
 * @retval HostList֥
 */
HostList&
IpMessengerAgentImpl::UpdateHostList( bool isRetry )
{
	char sendBuf[MAX_UDPBUF];
	int sendBufLen;

	if ( !isRetry && !hostList.IsAsking() ) {
#if defined(DEBUG)
		for(int i=0;i < 6;i++)
			printf("!! HOSTLIST CLEAR !! ");fflush( stdout );
		printf("\n");fflush(stdout);
#endif
		hostList.clear();
#if defined(DEBUG)
		for(int i=0;i < 6;i++)
			printf("!! HOSTLIST CLEARED !! ");fflush( stdout );
		printf("\n");fflush(stdout);
#endif
	}
	hostList.setIsAsking( true );
	if ( !isRetry ) {
		hostList.setAskStartTime( time( NULL ) );
		hostList.setPrevTry( hostList.AskStartTime() );
		hostList.setRetryCount( 0 );
	}
	AddDefaultHost();

	sendBufLen = CreateNewPacketBuffer( AddCommonCommandOption( IPMSG_BR_ISGETLIST2 ),
										_LoginName, _HostName,
										NULL, 0,
										sendBuf, sizeof( sendBuf ) );
	SendBroadcast( IPMSG_BR_ISGETLIST2, sendBuf, sendBufLen );
	//ػ(ȥ饤RecvPacketƤФ)
	if ( !isRetry ) {
		int pcount = RecvPacket();
		//ʬʳΥۥȤդʤȥ饤ַ֤
		for( int i = 0; i < 5; i++ ) {
			//0.01äޤġ
			usleep( 10000L );
			pcount = RecvPacket();
		}
	}

#if defined(DEBUG)
	IpMsgDumpHostList( " M Y   H O S T L I S T ( BEFORE SORT ) ", hostList );
#endif
	if ( compare != NULL ) {
		hostList.sort( compare );
	}
#if defined(DEBUG)
	IpMsgDumpHostList( " M Y   H O S T L I S T ( AFTER SORT ) ", hostList );
#endif
	if ( event != NULL ) {
		event->UpdateHostListAfter( hostList );
	}
	return hostList;
}

/**
 * Ժߥ⡼ɤɤȽꡣ
 * @retval ѤԺߥ⡼ɤ֤
 * Υ᥽åɤϥåɥդǤʤ
 */
bool
IpMessengerAgentImpl::IsAbsence()
{
	return _IsAbsence;
}
/**
 * Ժߥ⡼ɤ򥯥ꥢ롣
 * Υ᥽åɤϥåɥդǤʤ
 */
void
IpMessengerAgentImpl::ResetAbsence()
{
	_IsAbsence = false;
	localEncoding = "";
	vector<AbsenceMode> d;
	absenceModeList = d;
	SendAbsence();
}

/**
 * Ժߥ⡼ɤꤹ롣
 * @param encoding 륨󥳡ǥ
 * @param absenceModes AbsenceMode֥ȤΥ٥ʼưʣ󥳡ǥб뤿
 * Υ᥽åɤϥåɥդǤʤ
 */
void
IpMessengerAgentImpl::SetAbsence( string encoding, vector<AbsenceMode> absenceModes )
{
	_IsAbsence = true;

	localEncoding = encoding;
	absenceModeList = absenceModes;
	SendAbsence();
}

/**
 * å
 * @param host ۥ
 * @param msg å
 * @param isSecret 񤫤ɤ򼨤ե饰
 * @param isLockPassword Ĥɤ򼨤ե饰
 * @param hostCountAtSameTime Ʊۥȿ
 * @param opt ץ
 * Υ᥽åɤϥåɥդǤʤ
 */
SentMessage
IpMessengerAgentImpl::SendMsg( HostListItem host, string msg, bool isSecret, bool isLockPassword, int hostCountAtSameTime, unsigned long opt )
{
	AttachFileList files;
	return SendMsg( host, msg, isSecret, files, isLockPassword, hostCountAtSameTime, opt, false, 0UL );
}

/**
 * å
 * @param host ۥ
 * @param msg å
 * @param isSecret 񤫤ɤ򼨤ե饰
 * @param file źեե
 * @param isLockPassword Ĥɤ򼨤ե饰
 * @param hostCountAtSameTime Ʊۥȿ
 * @param opt ץ
 * Υ᥽åɤϥåɥդǤʤ
 */
SentMessage
IpMessengerAgentImpl::SendMsg( HostListItem host, string msg, bool isSecret, AttachFile file, bool isLockPassword, int hostCountAtSameTime, unsigned long opt )
{
	AttachFileList files;
	files.AddFile( file );
	return SendMsg( host, msg, isSecret, files, isLockPassword, hostCountAtSameTime, opt, false, 0UL );
}

/**
 * å
 * @param host ۥ
 * @param msg å
 * @param isSecret 񤫤ɤ򼨤ե饰
 * @param files źեե뷲
 * @param isLockPassword Ĥɤ򼨤ե饰
 * @param hostCountAtSameTime Ʊۥȿ
 * @param opt ץ
 * Υ᥽åɤϥåɥդǤʤ
 */
SentMessage
IpMessengerAgentImpl::SendMsg( HostListItem host, string msg, bool isSecret, AttachFileList files, bool isLockPassword, int hostCountAtSameTime, unsigned long opt, bool isRetry, unsigned long PrevPacketNo )
{
	char sendBuf[MAX_UDPBUF];
	int sendBufLen;
	char optBuf[GetMaxOptionBufferSize() + 1];
	int optBufLen = 0;
	struct sockaddr_in addr;
	bool isEncrypted = false;
	addr.sin_family = AF_INET;
	addr.sin_port = htons( host.PortNo() );
	addr.sin_addr.s_addr = inet_addr(host.IpAddress().c_str());

	RecvPacket();

	optBufLen = snprintf( optBuf, sizeof( optBuf ), "%s", msg.c_str() );
#ifdef HAVE_OPENSSL
	if ( isSecret && EncryptMsg( host, (unsigned char*)optBuf, optBufLen, &optBufLen, sizeof( optBuf ) ) ) {
		isEncrypted = true;
	} else {
		optBufLen = snprintf( optBuf, sizeof( optBuf ), "%s", msg.c_str() );
	}
#endif	//HAVE_OPENSSL
	//ڤΤƤ줿
	if ( optBufLen >= (int)sizeof( optBuf ) - 1 ) {
		optBufLen = sizeof( optBuf ) - 1;
	}

	optBuf[optBufLen++] = '\0';
	IpMsgPrintBuf( "optBuf:", optBuf, optBufLen );

	int fileBufLen = 0;
	char fileBuf[MAX_UDPBUF];

	for( vector<AttachFile>::iterator ixfile = files.begin(); ixfile != files.end(); ixfile++ ) {
		ixfile->GetLocalFileInfo();
		string filename = converter->ConvertLocalToNetwork( ixfile->FileName() );
		int wsize = snprintf( &fileBuf[ fileBufLen ], sizeof( fileBuf ) - fileBufLen - 1,
							"%d:%s:%llx:%lx:%lx:\a",
							ixfile->FileId(), filename.c_str(), ixfile->FileSize(), ixfile->MTime(), ixfile->Attr() );
		if ( optBufLen + fileBufLen + wsize - 1 > MAX_UDPBUF ) {
#if defined(DEBUG)
			printf( "break;\n" );fflush(stdout);
#endif
			break;
		}
		fileBufLen += wsize;
		fileBuf[fileBufLen] = '\0';
	}
#if defined(DEBUG)
	printf( "(1)optBufLen = %d, fileBufLen = %d", optBufLen, fileBufLen );fflush(stdout);
#endif
	memcpy( &optBuf[ optBufLen ], fileBuf, fileBufLen );
	optBufLen += fileBufLen;
#if defined(DEBUG)
	printf( "(2)optBufLen = %d, fileBufLen = %d", optBufLen, fileBufLen );fflush(stdout);
#endif
	IpMsgPrintBuf( "fileBuf2:", fileBuf, fileBufLen );
	if ( optBufLen >= (int)sizeof( optBuf ) - 1 ) {
		optBufLen = sizeof( optBuf ) - 1;
	}
	optBuf[ optBufLen ] = '\0';

	IpMsgPrintBuf( "optBuf2:", optBuf, optBufLen );

	unsigned long packetNo = (isRetry && PrevPacketNo != 0UL ? PrevPacketNo : random() );

	sendBufLen = CreateNewPacketBuffer( IPMSG_SENDMSG | IPMSG_SENDCHECKOPT |
#ifdef HAVE_OPENSSL
										  ( isEncrypted ? IPMSG_ENCRYPTOPT : 0UL ) |
#endif	//HAVE_OPENSSL
										  ( isSecret ? IPMSG_SECRETOPT : 0UL ) |
										  ( _IsAbsence ? IPMSG_AUTORETOPT : 0UL ) |
										  ( isLockPassword ? IPMSG_PASSWORDOPT : 0UL ) |
										  ( files.size() > 0 ? IPMSG_FILEATTACHOPT : 0UL ) | opt,
										  packetNo,
										  _LoginName, _HostName,
										  optBuf, optBufLen,
										  sendBuf, sizeof( sendBuf ) );
	SendPacket( IPMSG_SENDMSG, sendBuf, sendBufLen, addr );

	SentMessage message;
	message.setTo( addr );
	message.setHost( host );
	message.setPacketNo( packetNo );
	message.setMessage( msg );
	message.setSent( time( NULL ) );
	if ( !isRetry ) {
		message.setPrevTry( message.Sent() );
		message.setIsRetryMaxOver( false );
		message.setRetryCount( 0 );
	}
	message.setIsConfirmed( false );
	message.setIsPasswordLock( isLockPassword );
	message.setIsCrypted( isEncrypted );
	message.setIsConfirmAnswered( false );
	message.setHostCountAtSameTime( hostCountAtSameTime );
	message.setOpt( opt );
	message.setIsSecret( isSecret );
	message.setFiles( files );
	message.setIsSent( false );

#if defined(DEBUG)
	printf( "UserName[%s]\n", message.Host().UserName().c_str() );fflush( stdout );
	printf( "HostName[%s]\n", message.Host().HostName().c_str() );fflush( stdout );
	printf( "Nickname[%s]\n", message.Host().Nickname().c_str() );fflush( stdout );
#endif
	if ( SaveSentMessage() && !isRetry ){
		sentMsgList.append( message );
	}

//	RecvPacket();

#if defined(DEBUG)
	printf("sentMsgList.append() size=%d\n", sentMsgList.size() );fflush( stdout );
#endif

	return message;
}

/**
 * ϿѤΥ֥ɥ㥹ȥɥ쥹
 * @param addr ϿѤΥ֥ɥ㥹ȥɥ쥹
 * Υ᥽åɤϥåɥդǤʤ
 */
void
IpMessengerAgentImpl::ClearBroadcastAddress()
{
	broadcastAddr.clear();
}

/**
 * ϿѤΥ֥ɥ㥹ȥɥ쥹
 * @param addr ϿѤΥ֥ɥ㥹ȥɥ쥹
 * Υ᥽åɤϥåɥդǤʤ
 */
void
IpMessengerAgentImpl::DeleteBroadcastAddress( string addr )
{
	vector<struct sockaddr_in>::iterator net = FindBroadcastNetworkByAddress( addr );
	if ( net != broadcastAddr.end() ) {
#if defined(DEBUG)
		char ipaddrbuf[100];
		printf( "Delete Broadcast Address from %s(%d)\n", inet_ntoa_r( net->sin_addr.s_addr, ipaddrbuf, sizeof( ipaddrbuf ) ), ntohs( net->sin_port ) );fflush( stdout );
#endif
		broadcastAddr.erase( net );
		return;
	}
}

/**
 * ֥ɥ㥹ȥɥ쥹Ͽ
 * @param addr Ͽ֥ɥ㥹ȥɥ쥹
 * Υ᥽åɤϥåɥդǤʤ
 */
void
IpMessengerAgentImpl::AddBroadcastAddress( string addr )
{
	vector<struct sockaddr_in>::iterator net = FindBroadcastNetworkByAddress( addr );
	if ( net != broadcastAddr.end() ) {
		return;
	}
	struct sockaddr_in add_addr;
	add_addr.sin_family = AF_INET;
	add_addr.sin_port = htons(IPMSG_DEFAULT_PORT);
	add_addr.sin_addr.s_addr = inet_addr( addr.c_str() );
#if defined(DEBUG)
	char ipaddrbuf[100];
	printf( "Add Broadcast Address To %s(%d)\n", inet_ntoa_r( add_addr.sin_addr.s_addr, ipaddrbuf, sizeof( ipaddrbuf ) ), ntohs( add_addr.sin_port ) );fflush( stdout );
#endif
	broadcastAddr.push_back( add_addr );
}

/**
 * ϿѤΥ֥ɥ㥹ȥɥ쥹򸡺sockaddr_in¤ΤֵѤ롣
 * @param addr ֥ɥ㥹ȥɥ쥹ʸ
 * @retval sockaddr_in¤
 * Υ᥽åɤϥåɥդǤʤ
 */
vector<struct sockaddr_in>::iterator
IpMessengerAgentImpl::FindBroadcastNetworkByAddress( string addr )
{
	in_addr_t s_addr = inet_addr( addr.c_str() );
	for( vector<struct sockaddr_in>::iterator ixaddr = broadcastAddr.begin(); ixaddr != broadcastAddr.end(); ixaddr++ ){
		if ( ixaddr->sin_addr.s_addr == s_addr ) {
			return ixaddr;
		}
	}
	return broadcastAddr.end();
}

/**
 * оݥۥȤΥС䤤碌롣
 * GETINFOѥåȤ
 * @param host оݤΥۥ
 * Υ᥽åɤϥåɥդǤʤ
 */
void
IpMessengerAgentImpl::QueryVersionInfo( HostListItem& host )
{
	char sendBuf[MAX_UDPBUF]={0};
	int sendBufLen;
	struct sockaddr_in addr;
	addr.sin_family = AF_INET;
	addr.sin_port = htons( host.PortNo() );
	addr.sin_addr.s_addr = inet_addr(host.IpAddress().c_str());

	sendBufLen = CreateNewPacketBuffer( IPMSG_GETINFO,
										_LoginName, _HostName,
										NULL, 0,
										sendBuf, sizeof( sendBuf ) );
	SendPacket( IPMSG_GETINFO, sendBuf, sendBufLen, addr );
}

/**
 * оݥۥȤΥС
 * С䤤碌롣
 * ¾Υ᥽åɡANSINFOˤˤƼޤԵʸ޲ޤǡ
 * IPɥ쥹ǥޥå󥰤ANSINFOǹ줿С֤
 * @param host оݤΥۥ
 * @retval оݥۥȤΥС
 * Υ᥽åɤϥåɥդǤʤ
 */
string
IpMessengerAgentImpl::GetInfo( HostListItem& host )
{
	RecvPacket();
	for( int i = 0; i < 5; i++ ) {
		RecvPacket();
	}
	vector<HostListItem>::iterator hostIt = hostList.FindHostByAddress( host.IpAddress() );
	if ( hostIt != hostList.end() ) {
		return hostIt->Version();
	}
	return "";
}

/**
 * оݥۥȤԺʸ䤤碌롣
 * GETABSENCEINFOѥåȤ
 * @param host оݤΥۥ
 * Υ᥽åɤϥåɥդǤʤ
 */
void
IpMessengerAgentImpl::QueryAbsenceInfo( HostListItem& host )
{
	char sendBuf[MAX_UDPBUF]={0};
	int sendBufLen;
	struct sockaddr_in addr;
	addr.sin_family = AF_INET;
	addr.sin_port = htons( host.PortNo() );
	addr.sin_addr.s_addr = inet_addr(host.IpAddress().c_str());

	sendBufLen = CreateNewPacketBuffer( IPMSG_GETABSENCEINFO,
										_LoginName, _HostName,
										NULL, 0,
										sendBuf, sizeof( sendBuf ) );
	SendPacket( IPMSG_GETABSENCEINFO, sendBuf, sendBufLen, addr );
}

/**
 * оݥۥȤԺʸ
 * Ժʸ䤤碌롣
 * ¾Υ᥽åɡANSABSENCEINFOˤˤƼޤԵʸ޲ޤǡ
 * IPɥ쥹ǥޥå󥰤ANSABSENCEINFOǹ줿Ժʸ֤
 * @param host оݤΥۥ
 * @retval оݥۥȤԺʸ
 * Υ᥽åɤϥåɥդǤʤ
 */
string
IpMessengerAgentImpl::GetAbsenceInfo( HostListItem& host )
{
	QueryAbsenceInfo( host );
	RecvPacket();
	for( int i = 0; i < 5; i++ ) {
		RecvPacket();
	}
	vector<HostListItem>::iterator hostIt = hostList.FindHostByAddress( host.IpAddress() );
	if ( hostIt != hostList.end() ) {
		return hostIt->AbsenceDescription();
	}
	return "";
}

/**
 * ݻΥۥȥꥹȤ饰롼ץꥹȤ롣
 * @retval 롼ץꥹ
 * Υ᥽åɤϥåɥդǤʤ
 */
vector<GroupItem>
IpMessengerAgentImpl::GetGroupList()
{
	vector<GroupItem> ret;
	for( vector<HostListItem>::iterator ixhost = hostList.begin(); ixhost != hostList.end(); ixhost++ ) {
		bool is_found = false;
		for( vector<GroupItem>::iterator ixret = ret.begin(); ixret != ret.end(); ixret++){
			if ( ixhost->GroupName() == ixret->GroupName() && ixhost->EncodingName() == ixret->EncodingName() ) {
				is_found = true;
				break;
			}
		}
		if ( !is_found ){
			GroupItem item;
			item.setGroupName( ixhost->GroupName() );
			item.setEncodingName( ixhost->EncodingName() );
			ret.push_back( item );
		}
	}
	return ret;
}

/**
 * ˥åȤΤ롣
 * @param msg å֥ȡ
 * Υ᥽åɤϥåɥդǤʤ
 */
void
IpMessengerAgentImpl::DeleteNotify( RecievedMessage msg )
{
	char sendBuf[MAX_UDPBUF];
	int sendBufLen;
	char optBuf[MAX_UDPBUF];
	int optBufLen = 0;
	char *dmyptr;
	unsigned long packetNo = strtoul( msg.MessagePacket().Option().c_str(), &dmyptr, 10 );

	optBufLen = snprintf( optBuf, sizeof( optBuf ), "%lu", packetNo );
	optBuf[optBufLen++] = '\0';
	sendBufLen = CreateNewPacketBuffer( IPMSG_DELMSG,
										  _LoginName, _HostName,
										  optBuf, optBufLen,
										  sendBuf, sizeof( sendBuf ) );
	SendPacket( IPMSG_DELMSG, sendBuf, sendBufLen, msg.MessagePacket().Addr() );
	return;
}

/**
 * ˥åȤΤ롣
 * @param msg å֥ȡ
 * Υ᥽åɤϥåɥդǤʤ
 */
void
IpMessengerAgentImpl::ConfirmMessage( RecievedMessage &msg )
{
	char sendBuf[MAX_UDPBUF];
	int sendBufLen;
	char packetNoBuf[MAX_UDPBUF];
	int packetNoBufLen;

	if ( ( IPMSG_SECRETOPT & msg.MessagePacket().CommandOption() ) && !msg.IsConfirmed() ) {
		packetNoBufLen = snprintf( packetNoBuf, sizeof( packetNoBuf ), "%ld", msg.MessagePacket().PacketNo() );
		sendBufLen = CreateNewPacketBuffer( IPMSG_READMSG,
											  _LoginName, _HostName,
											  packetNoBuf, packetNoBufLen,
											  sendBuf, sizeof( sendBuf ) );
		SendPacket( IPMSG_READMSG, sendBuf, sendBufLen, msg.MessagePacket().Addr() );
	}
	msg.setIsConfirmed( true );
//	RecvPacket();
}

/**
 * ѥåꥹȤ˳줿Ȥޡ롣
 * @param msg å֥ȡ
 * Υ᥽åɤϥåɥդǤʤ
 */
void
IpMessengerAgentImpl::AcceptConfirmNotify( SentMessage msg )
{
	vector<SentMessage>::iterator sentMsg = sentMsgList.FindSentMessageByPacketNo( msg.PacketNo() );
	if ( sentMsg != sentMsgList.end() ) {
		sentMsg->setIsConfirmAnswered( true );
	}
}

// private methods start here

/**
 * 
 * ֥ɥ㥹ȥɥ쥹¤ΤνܥꥹȤ˲ࡣ
 * Υ᥽åɤϥåɥդǤʤ
 */
void
IpMessengerAgentImpl::InitSend()
{
	struct sockaddr_in addr;

	addr.sin_family = AF_INET;
	addr.sin_port = htons(IPMSG_DEFAULT_PORT);
	addr.sin_addr.s_addr = inet_addr("255.255.255.255");
	broadcastAddr.push_back( addr );
}

/**
 * TCPѥåȤԤ
 * @param sd åȥǥץ
 * @param buf Хåե
 * @param size Хåե
 * Υ᥽åɤϥåɥդǤʤ
 */
void
IpMessengerAgentImpl::SendTcpPacket( int sd, char *buf, int size )
{
#if defined(DEBUG)
	printf("== S E N D   T C P ====================================>\n");fflush( stdout );
#endif
	IpMsgPrintBuf( "SendTcpPacket:SendTcpBufer", buf, size );
	int ret = 0;
	ret = send( sd, buf, size + 1, 0 );
	if ( ret <= 0 ) {
		perror("send");
#if defined(DEBUG)
		printf("S E N D   T C P   F A I L E D\n");fflush( stdout );
#endif
	}
#if defined(DEBUG)
	printf("<= S E N D   T C P======================================\n");fflush( stdout );
#endif
}

/**
 * UDPѥåȤԤ
 * @param buf Хåե
 * @param size Хåե
 * @param to_addr IPɥ쥹
 * Υ᥽åɤϥåɥդǤʤ
 */
void
IpMessengerAgentImpl::SendPacket( const unsigned long cmd, char *buf, int size, struct sockaddr_in to_addr )
{
#if defined(DEBUG)
	printf("== S E N D ============================================>\n");fflush( stdout );
	printf( "Command[%s]\n", GetCommandString( cmd ).c_str() );fflush( stdout );
	char ipaddrbuf[100];
	printf( "Send  %s(%d)\n", inet_ntoa_r( to_addr.sin_addr.s_addr, ipaddrbuf, sizeof( ipaddrbuf ) ), ntohs( to_addr.sin_port ) );fflush( stdout );
#endif
	IpMsgPrintBuf( "SendUdpPacket:SendUdpBuffer", buf, size );
	int ret = 0;
	ret = sendto( udp_sd[0], buf, size + 1, 0, ( struct sockaddr * )&to_addr, sizeof( to_addr ) );
	if ( ret <= 0 ) {
		perror("sendto unicast");
#if defined(DEBUG)
		printf("S E N D   F A I L E D ( ret = %d)\n", ret );fflush( stdout );
#endif
	}
#if defined(DEBUG)
	printf("<= S E N D =============================================\n");fflush( stdout );
#endif
}

/**
 * UDPѥåȤΥ֥ɥ㥹ȤԤ
 * ֥ɥ㥹ȥɥ쥹ꥹȤϿѤΥɥ쥹롣
 * @param buf Хåե
 * @param size Хåե
 * Υ᥽åɤϥåɥդǤʤ
 */
void
IpMessengerAgentImpl::SendBroadcast( const unsigned long cmd, char *buf, int size )
{
#if defined(DEBUG)
	printf("== S E N D   B R O A D C A S T ========================>\n");fflush( stdout );
	printf( "Command[%s]\n", GetCommandString( cmd ).c_str() );fflush( stdout );
#endif
	IpMsgPrintBuf( "SendBroadcast:SendUdpBroadcastBuffer", buf, size );
	for( vector<struct sockaddr_in>::iterator ixaddr = broadcastAddr.begin(); ixaddr != broadcastAddr.end(); ixaddr++ ){
#if defined(DEBUG)
		char ipaddrbuf[100];
		printf( "Send To %s(%d)\n", inet_ntoa_r( ixaddr->sin_addr.s_addr, ipaddrbuf, sizeof( ipaddrbuf ) ), ntohs( ixaddr->sin_port ) );fflush( stdout );
#endif
		int ret = 0;
		for( unsigned int i = 0; i < udp_sd.size(); i++ ){
			ret = sendto( udp_sd[i], buf, size + 1, 0, ( struct sockaddr * )&(*ixaddr), sizeof( struct sockaddr ) );
			if ( ret <= 0 ) {
				perror("sendto broadcast.");
#if defined(DEBUG)
				printf("S E N D   F A I L E D\n");fflush( stdout );
#endif
			}
		}
	}
	for( vector<HostListItem>::iterator ixhost = hostList.begin(); ixhost != hostList.end(); ixhost++ ){
		if ( ixhost->CommandNo() | IPMSG_DIALUPOPT ) {
			struct sockaddr_in addr;
			addr.sin_family = AF_INET;
			addr.sin_port = htons( ixhost->PortNo() );
			addr.sin_addr.s_addr = inet_addr( ixhost->IpAddress().c_str() );
#if defined(DEBUG)
			char ipaddrbuf[100];
			printf( "Send To %s(%d)\n", inet_ntoa_r( addr.sin_addr.s_addr, ipaddrbuf, sizeof( ipaddrbuf ) ), ntohs( addr.sin_port ) );fflush( stdout );
#endif
			int ret = 0;
			for( unsigned int i = 0; i < udp_sd.size(); i++ ){
				ret = sendto( udp_sd[i], buf, size + 1, 0, ( struct sockaddr * )&addr, sizeof( struct sockaddr ) );
				if ( ret <= 0 ) {
					perror("sendto dialup host.");
#if defined(DEBUG)
					printf("S E N D   F A I L E D ( D I A L U P )\n");fflush( stdout );
#endif
				}
			}
		}
	}
	//ǰΤἫʬˤ
	struct sockaddr_in addr;
	addr.sin_family = AF_INET;
	addr.sin_port = htons( IPMSG_DEFAULT_PORT );
	addr.sin_addr.s_addr = inet_addr( "127.0.0.1" );
#if defined(DEBUG)
	char ipaddrbuf[100];
	printf( "Send To %s(%d)\n", inet_ntoa_r( addr.sin_addr.s_addr, ipaddrbuf, sizeof( ipaddrbuf ) ), ntohs( addr.sin_port ) );fflush( stdout );
#endif
	int ret = sendto( udp_sd[0], buf, size + 1, 0, ( struct sockaddr * )&addr, sizeof( struct sockaddr ) );
	if ( ret <= 0 ) {
		perror("sendto myself.");
#if defined(DEBUG)
		printf("S E N D   F A I L E D ( D I A L U P )\n");fflush( stdout );
#endif
	}

#if defined(DEBUG)
	printf("<= S E N D   B R O A D C A S T =========================\n");fflush( stdout );
#endif
}

/**
 * 
 * ֥ɥ㥹ȥɥ쥹˴ؤUDP
 * NICФUDP˴ؤ
 * NICФTCP˴ؤ
 * Υ᥽åɤϥåɥդǤʤ
 */
void
IpMessengerAgentImpl::InitRecv( vector<NetworkInterface> nics )
{
	if ( nics.size() > 0 ) {
		HostAddress = nics[0].IpAddress();
	}
	for( vector<struct sockaddr_in>::iterator addr = broadcastAddr.begin(); addr != broadcastAddr.end(); addr++ ){
		int sock = -1;

		sock = InitUdpRecv( *addr );
		if ( sock > 0 ) {
#if defined(INFO) || !defined(NDEBUG)
			printf( "UDP_SD[%d] = %d\n", udp_sd.size(),sock );fflush( stdout );
#endif
			udp_sd.push_back( sock );
		} else {
			char ipaddrbuf[100];
			printf( "UDP Error=%s\n", inet_ntoa_r( addr->sin_addr.s_addr, ipaddrbuf, sizeof( ipaddrbuf ) ) );fflush( stdout );
		}
	}
	for( unsigned int i = 0; i < nics.size(); i++ ){
		struct sockaddr_in addr;
		addr.sin_family = AF_INET;
		addr.sin_port = htons( nics[i].PortNo() );
		addr.sin_addr.s_addr = inet_addr( nics[i].IpAddress().c_str() );

		int sock = -1;

		sock = InitUdpRecv( addr );
		if ( sock > 0 ) {
#if defined(INFO) || !defined(NDEBUG)
			printf( "UDP_SD[%d] = %d\n", udp_sd.size(),sock );fflush( stdout );
#endif
			udp_sd.push_back( sock );
		} else {
			printf( "UDP Error[%s]=%s\n", nics[i].DeviceName().c_str(), nics[i].IpAddress().c_str() );fflush( stdout );
		}
		sock = InitTcpRecv( addr );
		if ( sock > 0 ) {
#if defined(INFO) || !defined(NDEBUG)
			printf( "TCP_SD[%d] = %d\n", tcp_sd.size(),sock );fflush( stdout );
#endif
			tcp_sd.push_back( sock );
		} else {
			printf( "TCP Error[%s]=%s\n", nics[i].DeviceName().c_str(), nics[i].IpAddress().c_str() );fflush( stdout );
		}
	}

	FD_ZERO( &rfds );
	for( unsigned int i = 0; i < udp_sd.size(); i++ ){
		FD_SET( udp_sd[i], &rfds );
	}
	for( unsigned int i = 0; i < tcp_sd.size(); i++ ){
		FD_SET( tcp_sd[i], &rfds );
	}
}

/**
 * UDP˴ؤ
 * 2425ԤUDPåȤ
 * UDPbroadcast
 * Υ᥽åɤϥåɥդǤʤ
 */
int
IpMessengerAgentImpl::InitUdpRecv( struct sockaddr_in addr )
{
	int sock = socket( AF_INET, SOCK_DGRAM, 0 );
	if ( bind(sock, (struct sockaddr *)&addr, sizeof(addr)) != 0 ){
		perror("bind(udp)");
		close( sock );
		return -1;
	}
	int yes = 1;
	if ( setsockopt(sock, SOL_SOCKET, SO_BROADCAST, (char *)&yes, sizeof(yes)) != 0 ) {
		perror("setsockopt(broadcast)");
		close( sock );
		return -1;
	}
	int buf_size = MAX_SOCKBUF, buf_minsize = MAX_SOCKBUF / 2;
	if ( setsockopt(sock, SOL_SOCKET, SO_SNDBUF, (char *)&buf_size, sizeof(int)) != 0 &&
		 setsockopt(sock, SOL_SOCKET, SO_SNDBUF, (char *)&buf_minsize, sizeof(int)) != 0 ) {
		perror("setsockopt(sendbuf)");
		close( sock );
		return -1;
	}
	if ( setsockopt(sock, SOL_SOCKET, SO_RCVBUF, (char *)&buf_size, sizeof(int)) != 0 &&
		 setsockopt(sock, SOL_SOCKET, SO_RCVBUF, (char *)&buf_minsize, sizeof(int)) != 0 ) {
		perror("setsockopt(recvbuf)");
		close( sock );
		return -1;
	}

#if 0
	//ޥ㥹ѤΥ󥿡եλ	
	in_addr_t my_if = addr.sin_addr.s_addr;
	if ( setsockopt(sock, IPPROTO_IP, IP_MULTICAST_IF, (char *)&my_if, sizeof(my_if) ) != 0 ){
		perror("setsockopt(multicast_if)");
		close( sock );
		return -1;
	}
	//ޥ㥹ȼν	
	struct ip_mreq mreq;
	memset(&mreq, 0, sizeof(mreq));
	mreq.imr_interface.s_addr = INADDR_ANY;
	mreq.imr_interface.s_addr = addr.sin_addr.s_addr;
	mreq.imr_multiaddr.s_addr = addr.sin_addr.s_addr;
	mreq.imr_multiaddr.s_addr = inet_addr("192.168.163.255");
	if ( setsockopt(sock, IPPROTO_IP, IP_ADD_MEMBERSHIP, (char *)&mreq, sizeof( mreq ) ) != 0 ) {
		perror("setsockopt(add_membership)");
		close( sock );
		return -1;
	}
#endif

	return sock;
}

/**
 * TCP˴ؤ
 * 2425ԤTCPåȤ
 * TCPREUSEADDR
 * litsen5ݡ
 * Υ᥽åɤϥåɥդǤʤ
 */
int
IpMessengerAgentImpl::InitTcpRecv( struct sockaddr_in addr )
{
	int sock = socket( AF_INET, SOCK_STREAM, 0 );
	if ( sock >= 0 && bind(sock, (struct sockaddr *)&addr, sizeof(addr)) != 0 ){
		perror("bind(tcp)");
		close( sock );
		return -1;
	}
	int yes = 1;
	if ( sock >= 0 && setsockopt(sock, SOL_SOCKET, SO_REUSEADDR, (char *)&yes, sizeof(yes)) != 0 ) {
		perror("setsockopt(reuseaddr)");
		close( sock );
		return -1;
	}
	if ( sock >= 0 && listen(sock, 5 ) != 0 ) {
		perror("setsockopt(reuseaddr)");
		close( sock );
		return -1;
	}
	return sock;
}

/**
 * ʥ桼ˡ
 * Υ᥽åɤϥåɥդǤʤ
 * @retval ѥåȿ
 */
int
IpMessengerAgentImpl::Process()
{
	return RecvPacket();
}

/**
 * ˡ
 * select(ॢդ)ˤƼԤ
 * ԤѥåȤ򥭥塼ˤࡣ
 * λ顢塼Ȥ롣ʳƥ٥ȤƤӽФ
 * Υ᥽åɤϥåɥդǤʤ
 * @retval ѥåȿ
 */
int
IpMessengerAgentImpl::RecvPacket()
{
	char buf[MAX_UDPBUF];
	int selret = 1;
	int ret = 0;
	int max_sd = -1;

	for( unsigned int i = 0; i < udp_sd.size(); i++ ){
		if ( max_sd < udp_sd[i] ){
			max_sd = udp_sd[i];
		}
	}
	for( unsigned int i = 0; i < tcp_sd.size(); i++ ){
		if ( max_sd < tcp_sd[i] ){
			max_sd = tcp_sd[i];
		}
	}

	time_t nowTime = time( NULL );

	vector<Packet> pack_que;

	while( selret > 0 ) {
		fd_set fds;
		memcpy( &fds, &rfds, sizeof( fd_set ) );

		memset( buf, 0, sizeof( buf ) );
		tv.tv_sec = SELECT_TIMEOUT_SEC;
		tv.tv_usec = SELECT_TIMEOUT_USEC;
		selret = select( max_sd + 1, &fds, NULL, NULL, &tv );
		if ( selret == -1 ) {
			if ( errno == EINTR ){
				continue;
			}
			perror( "select()" );
			break;
		} else if ( selret == 0 ){
#if defined(INFO) || !defined(NDEBUG)
			printf(".");fflush( stdout );
#endif
			break;
		} else {
			int tcp_socket = -1;
#if defined(DEBUG)
			printf("\n");fflush( stdout );
			printf( "select returns == %d\n\n", selret );fflush( stdout );
#endif
			struct sockaddr_in sender_addr;
			socklen_t sender_addr_len = 0;
			int sz = 0;
			//Ȥꤢ
			bool recieved = false;
			//UDPǥåȤѲͭä
			for( unsigned int i = 0; i < udp_sd.size(); i++ ){
				if ( FD_ISSET( udp_sd[i], &fds ) ){
					memset( &sender_addr, 0, sizeof( struct sockaddr_in ) );
					sender_addr_len = sizeof( struct sockaddr_in );
					sz = recvfrom( udp_sd[i], buf, sizeof( buf ), 0, (struct sockaddr *)&sender_addr, &sender_addr_len );
					if ( sz < 0 ) {
						perror("recvfrom");
					}
					IpMsgPrintBuf( "recvfrom buf", buf, sz );
					recieved = true;
					break;
				}
			}
			//UDPǥåȤѲʤ
			tcp_socket = -1;
			if ( !recieved ) {
				//TCPǥåȤѲͭä
				for( unsigned int i = 0; i < tcp_sd.size(); i++ ){
					if ( FD_ISSET( tcp_sd[i], &fds ) ){
						memset( &sender_addr, 0, sizeof( struct sockaddr_in ) );
						sender_addr_len = sizeof( struct sockaddr_in );
						tcp_socket = accept( tcp_sd[i], (struct sockaddr *)&sender_addr, &sender_addr_len );
						if ( tcp_socket < 0 ) {
							perror("accept");
						}
						sz = recv( tcp_socket, buf, sizeof( buf ), 0 );
						if ( sz < 0 ) {
							perror("recv");
						}
#if defined(INFO) || !defined(NDEBUG)
						printf("recv buf[%s]\n", buf );fflush( stdout );
#endif
						recieved = true;
						break;
					}
				}
				//UDP,TCPǥåȤѲʤ
				if ( !recieved ) {
					continue;
				}
			}
			Packet packet = DismantlePacketBuffer( buf, sz, sender_addr, nowTime );
#if defined(INFO) || !defined(NDEBUG)
			printf("recv from[%s]\n", packet.HostName().c_str() );fflush( stdout );
#endif
			packet.setTcpSocket( tcp_socket );
			ret++;
			//Ʊ쥻åѥåȤΰåʣѥåȤ̵ʸõ
			bool isFound = false;
	
			for(  int i = (int)PacketsForChecking.size() - 1; i >= 0; i-- ){
				if ( PacketsForChecking[i].PacketNo()             == packet.PacketNo() &&
					 PacketsForChecking[i].Addr().sin_addr.s_addr == packet.Addr().sin_addr.s_addr &&
					 PacketsForChecking[i].Addr().sin_port        == packet.Addr().sin_port ) {
					isFound = true;
					break;
				}
			}
			if ( !isFound ) {
				IpMsgDumpPacket( packet, packet.Addr() );
				pack_que.push_back( packet );
				PacketsForChecking.push_back( packet );
			}
		}
	}
	while( !pack_que.empty() ) {
		DoRecvCommand( pack_que.front() );
		pack_que.erase( pack_que.begin() );
	}

	//ʾΥåѤΥѥåȥ٥ä
	for( vector<Packet>::iterator pack = PacketsForChecking.begin(); pack != PacketsForChecking.end(); pack++ ){
		if ( nowTime > pack->Recieved() + PACKET_CHECK_FOR_SAVING_INTERVAL ) {
			pack = PacketsForChecking.erase( pack ) - 1;
		} else {
			break;
		}
	}

	//åȥ饤Υå
	for( vector<SentMessage>::iterator ixmsg = sentMsgList.begin(); ixmsg != sentMsgList.end(); ixmsg++ ) {
		if ( ixmsg->needSendRetry( nowTime ) ) {
			//
			ixmsg->setRetryCount( ixmsg->RetryCount() + 1 );
			ixmsg->setPrevTry( nowTime );
			SendMsg( ixmsg->Host(),
					 ixmsg->Message(),
					 ixmsg->IsSecret(),
					 ixmsg->Files(),
					 ixmsg->IsPasswordLock(),
					 ixmsg->HostCountAtSameTime(),
					 ixmsg->Opt(),
					 true,
					 ixmsg->PacketNo() );
		}
		if ( ixmsg->isRetryMaxOver() ) {
#if defined(INFO) || !defined(NDEBUG)
			printf("Retry Max Over\n");fflush( stdout );
#endif
			ixmsg->setRetryCount( 0 );
			ixmsg->setIsRetryMaxOver( true );
			if ( event != NULL ){
				//ȥ饤³True򥻥åȡ³ʤFalse򥻥åȡ
				//RetryMaxOver(åϥ顼)֤ˤС³ޤ
				//٥Ȥͤtrue:³false:Ǥˤʤޤ
				ixmsg->setIsRetryMaxOver( !event->SendRetryError( *ixmsg ) );
			}
			//٥ȤǷ³ꤷʤϥȥ饤ޥåС롣
		}
	}
	//ۥȥꥹȤΥȥ饤å
	if ( hostList.IsAsking() ){
		hostList.setPrevTry( time( NULL ) );
		if ( hostList.PrevTry() - hostList.AskStartTime() > GETLIST_RETRY_INTERVAL ) {
			hostList.setAskStartTime( time( NULL ) );
			hostList.setPrevTry( hostList.AskStartTime() );
			hostList.setRetryCount( hostList.RetryCount() + 1 );
			if ( hostList.RetryCount() < GETLIST_RETRY_MAX ) {
				UpdateHostList( true );
			} else {
				hostList.setAskStartTime( 0L );
				hostList.setPrevTry( 0L );
				hostList.setRetryCount( 0 );
				hostList.setIsAsking( false );
				if ( event != NULL ) {
					//ȥ饤³True򥻥åȡ³ʤFalse򥻥åȡ
					//٥Ȥͤtrue:³false:Ǥˤʤޤ
					hostList.setIsAsking( event->GetHostListRetryError() );
				}
			}
		}
	}
	return ret;
}

/**
 * ѥåȤΥޥɥ⡼ɤǼ٥Ȥ򿶤ʬ롣
 * @param packet ѥåȥ֥
 */
void
IpMessengerAgentImpl::DoRecvCommand( Packet packet )
{
#if defined(DEBUG)
	printf( "PACKET.COMMAND=[%s]\n", GetCommandString( packet.CommandMode() ).c_str() );fflush( stdout );
#endif
	switch( packet.CommandMode() ) {
		case IPMSG_NOOPERATION:     UdpRecvEventNoOperation( packet ); break;
		case IPMSG_BR_ENTRY:        UdpRecvEventBrEntry( packet ); break;
		case IPMSG_BR_EXIT:         UdpRecvEventBrExit( packet ); break;
		case IPMSG_ANSENTRY:        UdpRecvEventAnsEntry( packet ); break;
		case IPMSG_BR_ABSENCE:      UdpRecvEventBrAbsence( packet );break;
		case IPMSG_BR_ISGETLIST:    UdpRecvEventBrIsGetList( packet ); break;
		case IPMSG_OKGETLIST:       UdpRecvEventOkGetList( packet ); break;
		case IPMSG_GETLIST:         UdpRecvEventGetList( packet ); break;
		case IPMSG_ANSLIST:         UdpRecvEventAnsList( packet ); break;
		case IPMSG_BR_ISGETLIST2:   UdpRecvEventBrIsGetList2( packet ); break;
		case IPMSG_SENDMSG:         UdpRecvEventSendMsg( packet ); break;
		case IPMSG_RECVMSG:         UdpRecvEventRecvMsg( packet ); break;
		case IPMSG_READMSG:         UdpRecvEventReadMsg( packet); break;
		case IPMSG_DELMSG:          UdpRecvEventDelMsg( packet); break;
		case IPMSG_ANSREADMSG:      UdpRecvEventAnsReadMsg( packet ); break;
		case IPMSG_GETINFO:         UdpRecvEventGetInfo( packet ); break;
		case IPMSG_SENDINFO:        UdpRecvEventSendInfo( packet ); break;
		case IPMSG_GETABSENCEINFO:  UdpRecvEventGetAbsenceInfo( packet ); break;
		case IPMSG_SENDABSENCEINFO: UdpRecvEventSendAbsenceInfo( packet ); break;
		case IPMSG_GETFILEDATA:     TcpRecvEventGetFileData( packet); break;
		case IPMSG_RELEASEFILES:    UdpRecvEventReleaseFiles( packet ); break;
		case IPMSG_GETDIRFILES:     TcpRecvEventGetDirFiles( packet ); break;
		case IPMSG_GETPUBKEY:       UdpRecvEventGetPubKey( packet ); break;
		case IPMSG_ANSPUBKEY:       UdpRecvEventAnsPubKey( packet ); break;
	}
}

/**
 * ʸ٥ȡNOOPERATION
 * ⤷ʤ
 * @param packet ѥåȥ֥
 */
int
IpMessengerAgentImpl::UdpRecvEventNoOperation( Packet packet )
{
#if defined(INFO) || !defined(NDEBUG)
	printf("UdpRecvNoOperation\n");fflush( stdout );
#endif
	return 0;
}

/**
 * ʸ(NOOPERATION)
 * NOOPERATION
 */
int
IpMessengerAgentImpl::SendNoOperation()
{
	char sendBuf[MAX_UDPBUF];
	int sendBufLen;

	sendBufLen = CreateNewPacketBuffer( IPMSG_NOOPERATION,
										  _LoginName, _HostName,
										  NULL, 0,
										  sendBuf, sizeof( sendBuf ) );
	SendBroadcast( IPMSG_NOOPERATION, sendBuf, sendBufLen );
	return 0;
}

/**
 * ʸ٥ȡBR_ENTRY
 * ANSENTRY롣
 * Ժߥ⡼ɤξ硢ԺߤȤ
 * @param packet ѥåȥ֥
 */
int
IpMessengerAgentImpl::UdpRecvEventBrEntry( Packet packet )
{
	char sendBuf[MAX_UDPBUF];
	int sendBufLen;
	char optBuf[MAX_UDPBUF];
	int optBufLen = 0;

#if defined(INFO) || !defined(NDEBUG)
	printf("UdpRecvBrEntry\n");fflush( stdout );
#endif
	if ( _IsAbsence ) {
		string AbsenceName = "";
		for( vector<AbsenceMode>::iterator i = absenceModeList.begin(); i != absenceModeList.end(); i++ ){
			if ( i->EncodingName() == localEncoding ) {
				AbsenceName = i->AbsenceName();
				break;
			}
		}
		optBufLen = snprintf( optBuf, sizeof( optBuf ), "%s[%s]", Nickname.c_str(), AbsenceName.c_str() );
	} else {
		optBufLen = snprintf( optBuf, sizeof( optBuf ), "%s", Nickname.c_str() );
	}
	optBuf[optBufLen] = '\0';
	optBufLen++;
	snprintf( &optBuf[ optBufLen ], sizeof( optBuf ) - optBufLen - 1, "%s", GroupName.c_str() );
	optBufLen += GroupName.size();
	optBuf[optBufLen ] = '\0';
	sendBufLen = CreateNewPacketBuffer( AddCommonCommandOption( IPMSG_ANSENTRY ),
										_LoginName, _HostName,
										optBuf, optBufLen,
										sendBuf, sizeof( sendBuf ) );
	SendPacket( IPMSG_ANSENTRY, sendBuf, sendBufLen, packet.Addr() );
	// ۥȥꥹȤɲ
	AddHostListFromPacket( packet ); 
	if ( event != NULL ) {
		event->EntryAfter( hostList );
	}
	return 0;
}

/**
 * ʸBR_ABSENCE
 * ԺΡԺ߲ʸ롣
 */
int
IpMessengerAgentImpl::SendAbsence()
{
	char sendBuf[MAX_UDPBUF];
	int sendBufLen;
	char optBuf[MAX_UDPBUF];
	int optBufLen = 0;

#if defined(INFO) || !defined(NDEBUG)
	printf("SendBrAbsence\n");fflush( stdout );
#endif
	if ( _IsAbsence ) {
		string AbsenceName = "";
		for( vector<AbsenceMode>::iterator i = absenceModeList.begin(); i != absenceModeList.end(); i++ ){
			if ( i->EncodingName() == localEncoding ) {
				AbsenceName = i->AbsenceName();
				break;
			}
		}
		optBufLen = snprintf( optBuf, sizeof( optBuf ), "%s[%s]", Nickname.c_str(), AbsenceName.c_str() );
	} else {
		optBufLen = snprintf( optBuf, sizeof( optBuf ), "%s", Nickname.c_str() );
	}
	optBuf[optBufLen] = '\0';
	optBufLen++;
	snprintf( &optBuf[ optBufLen ], sizeof( optBuf ) - optBufLen - 1, "%s", GroupName.c_str() );
	optBufLen += GroupName.size();
	optBuf[optBufLen ] = '\0';

	sendBufLen = CreateNewPacketBuffer( AddCommonCommandOption( IPMSG_BR_ABSENCE ),
										_LoginName, _HostName,
										optBuf, optBufLen,
										sendBuf, sizeof( sendBuf ) );
	SendBroadcast( IPMSG_BR_ABSENCE, sendBuf, sendBufLen );
	return 0;
}

/**
 * ʸ٥ȡBR_ABSENCE
 * ʬΥۥȥꥹȤ򹹿롣
 * @param packet ѥåȥ֥
 */
int
IpMessengerAgentImpl::UdpRecvEventBrAbsence( Packet packet )
{
#if defined(INFO) || !defined(NDEBUG)
	printf("UdpRecvBrAbsence\n");fflush( stdout );
#endif
	hostList.DeleteHost( packet.HostName() );
	hostList.AddHost( HostList::CreateHostListItemFromPacket( packet ) );
	if ( event != NULL ){
		event->AbsenceModeChangeAfter( hostList );
	}
	return 0;
}

/**
 * ʸ٥ȡBR_EXIT
 * ʬΥۥȥꥹȤۥȤ롣
 * @param packet ѥåȥ֥
 */
int
IpMessengerAgentImpl::UdpRecvEventBrExit( Packet packet )
{
#if defined(INFO) || !defined(NDEBUG)
	printf("UdpRecvBrExit\n");fflush( stdout );
#endif
	hostList.DeleteHost( packet.HostName() );
	if ( event != NULL ) {
		event->ExitAfter( hostList );
	}
	return 0;
}

/**
 * ʸ٥ȡBR_RECVMSG
 * ʬѥåꥹȤγåѥե饰ΩƤ롣
 * @param packet ѥåȥ֥
 */
int
IpMessengerAgentImpl::UdpRecvEventRecvMsg( Packet packet )
{
	char *dmyptr;
	unsigned long packetNo = strtoul( packet.Option().c_str(), &dmyptr, 10 );
	vector<SentMessage>::iterator sentMsg = sentMsgList.FindSentMessageByPacketNo( packetNo );
	if ( sentMsg != sentMsgList.end() ) {
		sentMsg->setIsSent( true );
		sentMsg->setRetryCount( 0 );
		sentMsg->setIsRetryMaxOver( true );
		if ( event != NULL ){
			event->SendAfter( *sentMsg );
		}
	}

#if defined(INFO) || !defined(NDEBUG)
	printf("UdpRecvRecvMsg\n");fflush( stdout );
#endif
	return 0;
}

/**
 * ʸ٥ȡBR_READMSG
 * READCHECKOPTդƤ硢ANSREADMSGꤲ롣
 * ʬѥåꥹȤγå˴ɥե饰ΩƤ롣
 * @param packet ѥåȥ֥
 */
int
IpMessengerAgentImpl::UdpRecvEventReadMsg( Packet packet )
{
	char sendBuf[MAX_UDPBUF];
	int sendBufLen;
	char packetNoBuf[MAX_UDPBUF];
	int packetNoBufLen;
	
	if ( packet.CommandOption() & IPMSG_READCHECKOPT ) {
		packetNoBufLen = snprintf( packetNoBuf, sizeof( packetNoBuf ), "%ld", packet.PacketNo() );
		sendBufLen = CreateNewPacketBuffer( IPMSG_ANSREADMSG,
											  _LoginName, _HostName,
											  packetNoBuf, packetNoBufLen,
											  sendBuf, sizeof( sendBuf ) );
		SendPacket( IPMSG_ANSREADMSG, sendBuf, sendBufLen, packet.Addr() );
	}

	char *dmyptr;
	unsigned long packet_no = strtoul( packet.Option().c_str(), &dmyptr, 10 );
	vector<SentMessage>::iterator sentMsg = sentMsgList.FindSentMessageByPacketNo( packet_no );
	if ( sentMsg != sentMsgList.end() ) {
		sentMsg->setIsConfirmed( true );
		if ( event != NULL ) {
			event->OpenAfter( *sentMsg );
		}
	}
#if defined(INFO) || !defined(NDEBUG)
	printf("UdpRecvReadMsg\n");fflush( stdout );
#endif
	return 0;
}

/**
 * ʸ٥ȡBR_DELMSG
 * ʬѥåꥹȤγå
 * @param packet ѥåȥ֥
 */
int
IpMessengerAgentImpl::UdpRecvEventDelMsg( Packet packet )
{
	char *dmyptr;
	unsigned long packet_no = strtoul( packet.Option().c_str(), &dmyptr, 10 );
	vector<SentMessage>::iterator sentMsg = sentMsgList.FindSentMessageByPacketNo( packet_no );
	if ( sentMsg != sentMsgList.end() ) {
		sentMsgList.erase(sentMsg);
	}
#if defined(INFO) || !defined(NDEBUG)
	printf("UdpRecvDelMsg\n");fflush( stdout );
#endif
	return 0;
}

/**
 * ʸ٥ȡBR_ANSREADMSG
 * ⤷ʤ
 * @param packet ѥåȥ֥
 */
int
IpMessengerAgentImpl::UdpRecvEventAnsReadMsg( Packet packet )
{
#if defined(INFO) || !defined(NDEBUG)
	printf("UdpRecvAnsReadMsg\n");fflush( stdout );
#endif
	return 0;
}

/**
 * ʸ٥ȡBR_SENDMSG
 * BROADCASTOPT or AUTORETOPTʤ鼫ưʤ
 * SENDCHECKOPTդʤRECVMSGꤲ롣
 * ʬԺߤʤԺ߱򤹤롣
 * Ź沽åʤ档
 * ѥåɲá
 * @param packet ѥåȥ֥
 */
int
IpMessengerAgentImpl::UdpRecvEventSendMsg( Packet packet )
{
	char sendBuf[MAX_UDPBUF];
	int sendBufLen;
	char packetNoBuf[MAX_UDPBUF];
	int packetNoBufLen;

#if defined(DEBUG) || !defined(NDEBUG)
	printf("ѥå(%d)\n", recvMsgList.size() );fflush( stdout );
#endif
	for( vector<RecievedMessage>::iterator ixmsg = recvMsgList.begin(); ixmsg != recvMsgList.end(); ixmsg++ ) {
#if defined(DEBUG) || !defined(NDEBUG)
			printf("å...߽Υѥå(%ld) ΥåΥѥå(%ld)\n",
					packet.PacketNo(), ixmsg->MessagePacket().PacketNo() );fflush( stdout );
#endif
		if ( packet.PacketNo() == ixmsg->MessagePacket().PacketNo() ) {
#if defined(DEBUG) || !defined(NDEBUG)
			printf("ǤɲúѤ\n");fflush( stdout );
#endif
			return 0;
		}
	}
#if defined(INFO) || !defined(NDEBUG)
	printf("UdpRecvSendMsg[Packet = %lu]\n", packet.PacketNo() );fflush( stdout );
#endif
	bool noRaiseEvent = false;
	if ( packet.CommandOption() & IPMSG_BROADCASTOPT ||  packet.CommandOption() & IPMSG_AUTORETOPT ) {
		;
	} else {
		if ( packet.CommandOption() & IPMSG_SENDCHECKOPT ) {
			packetNoBufLen = snprintf( packetNoBuf, sizeof( packetNoBuf ), "%ld", packet.PacketNo() );
			sendBufLen = CreateNewPacketBuffer( IPMSG_RECVMSG,
												  _LoginName, _HostName,
												  packetNoBuf, packetNoBufLen,
												  sendBuf, sizeof( sendBuf ) );
			SendPacket( IPMSG_RECVMSG, sendBuf, sendBufLen, packet.Addr() );
		}
		if ( _IsAbsence ) {
			HostListItem host;
			char ipaddrbuf[100];
			host.setIpAddress( inet_ntoa_r( packet.Addr().sin_addr.s_addr, ipaddrbuf, sizeof( ipaddrbuf ) ) );
			host.setPortNo( ntohs( packet.Addr().sin_port ) );
			host.setEncodingName( localEncoding );
			vector<HostListItem>::iterator hostIt = hostList.FindHostByAddress( host.IpAddress() );
			if ( hostIt != hostList.end() ) {
				host.setEncodingName( hostIt->EncodingName() );
			}
			string AbsenceDescription = "";
			for( vector<AbsenceMode>::iterator i = absenceModeList.begin(); i != absenceModeList.end(); i++ ){
				if ( i->EncodingName() == localEncoding ) {
					AbsenceDescription = i->AbsenceDescription();
					break;
				}
			}
			SendMsg( host, AbsenceDescription.c_str(), false );
		}
	}

	if ( packet.CommandOption() & IPMSG_ENCRYPTOPT ){
		if ( !DecryptMsg( packet ) ) {
			HostListItem host;
			char ipaddrbuf[100];
			host.setIpAddress( inet_ntoa_r( packet.Addr().sin_addr.s_addr, ipaddrbuf, sizeof( ipaddrbuf ) ) );
			host.setPortNo( ntohs( packet.Addr().sin_port ) );
			SendMsg( host, DecryptErrorMessage.c_str(), false, IPMSG_AUTORETOPT );
			packet.setOption("");
			//ŹԤˤ뼫ưϥ٥Ȥ򵯤ʤ
			noRaiseEvent = true;
		}
	}
	RecievedMessage message;
	message.setMessagePacket( packet );
	message.setMessage( packet.Option().c_str() );
	message.setRecieved( time( NULL ) );
	message.setIsSecret( IPMSG_SECRETOPT & packet.CommandOption() );
	message.setIsCrypted( IPMSG_ENCRYPTOPT & packet.CommandOption() );
	message.setIsPasswordLock( IPMSG_PASSWORDOPT & packet.CommandOption() );
	message.setIsMulticast( IPMSG_MULTICASTOPT & packet.CommandOption() );
	message.setIsBroadcast( IPMSG_BROADCASTOPT & packet.CommandOption() );
	message.setIsConfirmed( false );
	for( vector<HostListItem>::iterator ixhost = hostList.begin(); ixhost != hostList.end(); ixhost++ ) {
		if ( ixhost->UserName() == packet.UserName() && ixhost->HostName() == packet.HostName() ) {
			message.setHost( *ixhost );
			break;
		}
	}

	message.setHasAttachFile( false );
	AttachFileList files = message.Files();
	if ( CreateAttachedFileList( packet.Option().c_str(), files ) != 0 ) {
		message.setHasAttachFile( true );
	}
	bool eventRet = false;
	message.setFiles( files );
	if ( !noRaiseEvent && event != NULL ) {
		eventRet = event->RecieveAfter( message );
	}
	if ( SaveRecievedMessage() && !eventRet ){
		recvMsgList.append( message );
	}
	return 0;
}

/**
 * ʸ٥ȡBR_ISGETLIST
 * OKGETLISTꤲ롣
 * @param packet ѥåȥ֥
 */
int
IpMessengerAgentImpl::UdpRecvEventBrIsGetList( Packet packet )
{
	char sendBuf[MAX_UDPBUF];
	int sendBufLen;

#if defined(INFO) || !defined(NDEBUG)
	printf("UdpRecvBrIsGetList\n");fflush( stdout );
#endif
	sendBufLen = CreateNewPacketBuffer( AddCommonCommandOption( IPMSG_OKGETLIST ),
										_LoginName, _HostName,
										NULL, 0,
										sendBuf, sizeof( sendBuf ) );
	SendPacket( IPMSG_OKGETLIST, sendBuf, sendBufLen, packet.Addr() );
	return 0;
}

/**
 * ʸ٥ȡBR_ISGETLIST2
 * OKGETLISTꤲ롣
 * @param packet ѥåȥ֥
 */
int
IpMessengerAgentImpl::UdpRecvEventBrIsGetList2( Packet packet )
{
	char sendBuf[MAX_UDPBUF];
	int sendBufLen;

#if defined(INFO) || !defined(NDEBUG)
	printf("UdpRecvBrIsGetList2\n");fflush( stdout );
#endif
	sendBufLen = CreateNewPacketBuffer( AddCommonCommandOption( IPMSG_OKGETLIST ),
										_LoginName, _HostName,
										NULL, 0,
										sendBuf, sizeof( sendBuf ) );
	SendPacket( IPMSG_OKGETLIST, sendBuf, sendBufLen, packet.Addr() );
	return 0;
}

/**
 * ʸ٥ȡBR_GETLIST
 * ANSLISTꤲ롣
 * @param packet ѥåȥ֥
 */
int
IpMessengerAgentImpl::UdpRecvEventGetList( Packet packet )
{
	char sendBuf[MAX_UDPBUF];
	int sendBufLen;
	int start = 0;
	char *dmy;
	string hosts;

#if defined(INFO) || !defined(NDEBUG)
	printf("UdpRecvGetList[%s]\n", packet.Option().c_str());fflush( stdout );
#endif
	start = strtoul( packet.Option().c_str(), &dmy, 10 );
	hosts = hostList.ToString( start );
	sendBufLen = CreateNewPacketBuffer( AddCommonCommandOption( IPMSG_ANSLIST ),
										_LoginName, _HostName,
										hosts.c_str(), hosts.length(),
										sendBuf, sizeof( sendBuf ) );
	SendPacket( IPMSG_ANSLIST, sendBuf, sendBufLen, packet.Addr() );
	return 0;
}

/**
 * ʸ٥ȡBR_OKGETLIST
 * GETLISTꤲ롣
 * @param packet ѥåȥ֥
 */
int
IpMessengerAgentImpl::UdpRecvEventOkGetList( Packet packet )
{
	char sendBuf[MAX_UDPBUF];
	int sendBufLen;
	string hosts;

#if defined(INFO) || !defined(NDEBUG)
	printf("UdpRecvOkGetList[%s]\n", packet.Option().c_str());fflush( stdout );
#endif
	sendBufLen = CreateNewPacketBuffer( AddCommonCommandOption( IPMSG_GETLIST ),
										_LoginName, _HostName,
										NULL, 0,
										sendBuf, sizeof( sendBuf ) );
	SendPacket( IPMSG_GETLIST, sendBuf, sendBufLen, packet.Addr() );
	return 0;
}

/**
 * ʸ٥ȡBR_ANSENTRY
 * ⤷ʤ
 * @param packet ѥåȥ֥
 */
int
IpMessengerAgentImpl::UdpRecvEventAnsEntry( Packet packet )
{
#if defined(INFO) || !defined(NDEBUG)
	printf("UdpRecvAnsEntry\n");fflush( stdout );
#endif
	// ۥȥꥹȤɲ
	AddHostListFromPacket( packet ); 
	if ( event != NULL ) {
		event->EntryAfter( hostList );
	}
	return 0;
}

/**
 * ʸ٥ȡBR_ANSLIST
 * ׵˱ۥȥꥹȤʬGETLIST˵ͤꤲ롣
 * @param packet ѥåȥ֥
 */
int
IpMessengerAgentImpl::UdpRecvEventAnsList( Packet packet )
{
	char sendBuf[MAX_UDPBUF];
	int sendBufLen;
	char nextbuf[1024];

#if defined(INFO) || !defined(NDEBUG)
	printf("UdpRecvAnsList\n");fflush( stdout );
#endif
	AddDefaultHost();
	char ipaddrbuf[100];
	int nextstart = CreateHostList( inet_ntoa_r( packet.Addr().sin_addr.s_addr, ipaddrbuf, sizeof( ipaddrbuf ) ),
									packet.HostName().c_str(),
									packet.Option().c_str(),
									packet.Option().length() );
	if ( nextstart > 0 ) {
		int nextbuf_len = snprintf( nextbuf, sizeof( nextbuf ), "%d", hostList.size() + 1 );
#if defined(INFO) || !defined(NDEBUG)
		printf("nextbuf_len = %d\n", nextbuf_len );fflush( stdout );
#endif
		sendBufLen = CreateNewPacketBuffer( AddCommonCommandOption( IPMSG_GETLIST ),
											_LoginName, _HostName,
											nextbuf, nextbuf_len,
											sendBuf, sizeof( sendBuf ) );
		SendPacket( IPMSG_GETLIST, sendBuf, sendBufLen, packet.Addr() );
	}
	string packetIpAddress = inet_ntoa_r( packet.Addr().sin_addr.s_addr, ipaddrbuf, sizeof( ipaddrbuf ) );
	for( unsigned int i = 0; i < NICs.size(); i++ ){
		if ( packetIpAddress == NICs[i].IpAddress() ){
			return 0;
		}
	}
	//ʬʳΥۥȥꥹΤСȥ饤Ϣѿ򥯥ꥢ
	hostList.setIsAsking( false );
	hostList.setAskStartTime( 0L );
	hostList.setPrevTry( 0L );
	hostList.setRetryCount( 0 );
	return 0;
}

/**
 * ʸ٥ȡBR_GETINFO
 * СSENDINFO˵ͤꤲ롣
 * @param packet ѥåȥ֥
 */
int
IpMessengerAgentImpl::UdpRecvEventGetInfo( Packet packet )
{
	char sendBuf[MAX_UDPBUF];
	int sendBufLen;
	string version = IPMSG_AGENT_VERSION;

#if defined(INFO) || !defined(NDEBUG)
	printf("UdpRecvGetInfo[%s]\n", packet.Option().c_str());fflush( stdout );
#endif
	sendBufLen = CreateNewPacketBuffer( AddCommonCommandOption( IPMSG_SENDINFO ),
										_LoginName, _HostName,
										version.c_str(), version.length(),
										sendBuf, sizeof( sendBuf ) );
	SendPacket( IPMSG_SENDINFO, sendBuf, sendBufLen, packet.Addr() );
	return 0;
}

/**
 * ʸ٥ȡBR_SENDINFO
 * СۥȥꥹȤ˹롣
 * @param packet ѥåȥ֥
 */
int
IpMessengerAgentImpl::UdpRecvEventSendInfo( Packet packet )
{
	char ipaddrbuf[100];
	string pIpAddress = inet_ntoa_r( packet.Addr().sin_addr.s_addr, ipaddrbuf, sizeof( ipaddrbuf ) );
	vector<HostListItem>::iterator hostIt = hostList.FindHostByAddress( pIpAddress );
	if ( hostIt != hostList.end() ) {
		hostIt->setVersion( packet.Option() );
		if ( event != NULL ){
			event->VersionInfoRecieveAfter( *hostIt, packet.Option() );
		}
	}
	return 0;
}

/**
 * ʸ٥ȡBR_GETABSENCEINFO
 * Ժ߾ܺپSENDINFO˵ͤꤲ롣
 * @param packet ѥåȥ֥
 */
int
IpMessengerAgentImpl::UdpRecvEventGetAbsenceInfo( Packet packet )
{
	char sendBuf[MAX_UDPBUF];
	int sendBufLen;

#if defined(INFO) || !defined(NDEBUG)
	printf("UdpRecvGetAbsenceInfo[%s]\n", packet.Option().c_str());fflush( stdout );
#endif
	string AbsenceDescription = "";
	if ( _IsAbsence  ){
		char ipaddrbuf[100];
		string IpAddress = inet_ntoa_r( packet.Addr().sin_addr.s_addr, ipaddrbuf, sizeof( ipaddrbuf ) );
		string EncodingName = localEncoding;
		vector<HostListItem>::iterator hostIt = hostList.FindHostByAddress( IpAddress );
		if ( hostIt != hostList.end() ) {
			EncodingName = hostIt->EncodingName();
		}
		for( vector<AbsenceMode>::iterator i = absenceModeList.begin(); i != absenceModeList.end(); i++ ){
			if ( i->EncodingName() == localEncoding ) {
				AbsenceDescription = i->AbsenceDescription();
				break;
			}
		}
	} else {
		AbsenceDescription = "Not Absence mode";
	}
	sendBufLen = CreateNewPacketBuffer( AddCommonCommandOption( IPMSG_SENDABSENCEINFO ),
										_LoginName, _HostName,
										AbsenceDescription.c_str(), AbsenceDescription.length(),
										sendBuf, sizeof( sendBuf ) );
	SendPacket( IPMSG_SENDABSENCEINFO, sendBuf, sendBufLen, packet.Addr() );
	return 0;
}

/**
 * ʸ٥ȡBR_SENDABSENCEINFO
 * Ժ߾ܺپۥȥꥹȤ˹롣
 * @param packet ѥåȥ֥
 */
int
IpMessengerAgentImpl::UdpRecvEventSendAbsenceInfo( Packet packet )
{
	char ipaddrbuf[100];
	string pIpAddress = inet_ntoa_r( packet.Addr().sin_addr.s_addr, ipaddrbuf, sizeof( ipaddrbuf ) );
	vector<HostListItem>::iterator hostIt = hostList.FindHostByAddress( pIpAddress );
	if ( hostIt != hostList.end() ) {
		hostIt->setAbsenceDescription( packet.Option() );
		if ( event != NULL ){
			event->AbsenceDetailRecieveAfter( *hostIt, packet.Option() );
		}
	}
	return 0;
}

/**
 * ѥåȤ饪եåȤޤ
 * ѥåȤ饪եåȤФ֤ޤ
 * @param packet ѥåȥ֥
 * @retval ե륪եåȡ
 */
static unsigned long
GetSendFileOffsetInPacket( Packet packet )
{
	char *dmyptr;
	char *startptr;
	strtoul( packet.Option().c_str(), &dmyptr, 16 );
	startptr = ++dmyptr;
	strtoul( startptr, &dmyptr, 16 );
	startptr = ++dmyptr;
	unsigned long offset = strtoul( startptr, &dmyptr, 16 );

	return offset;
}

/**
 * ʸ٥ȡBR_GETFILEDATA
 * եTCPåȤˤΤθեɤ롣
 * @param packet ѥåȥ֥
 */
int
IpMessengerAgentImpl::TcpRecvEventGetFileData( Packet packet )
{
#if defined(INFO) || !defined(NDEBUG)
	printf( "TcpRecvEventGetFileData\n" );fflush( stdout );
#endif

#ifdef HAVE_PTHREAD
	pthread_t t_id;

	Packet *packetClone = new Packet( packet );

	if ( pthread_create( &t_id, NULL, GetFileDataThread, (void *)packetClone ) != 0 ){
		perror("TcpRecvEventGetFileData:pthread_create");
		return -1;
	}
	if ( pthread_detach( t_id ) != 0 ){
		perror("TcpRecvEventGetFileData:pthread_detach");
		return -1;
	}
	return 0;
#else	// HAVE_PTHREAD
	Packet *packetClone = new Packet( packet );
	GetFileDataThread( packetClone );
#endif	// HAVE_PTHREAD
}

/**
 * եɥå
 * եɤ롣
 * @param param ѥåȥ֥(void*)
 */
void *
GetFileDataThread( void *param )
{
#if defined(INFO) || !defined(NDEBUG)
	printf( "GetFileDataThread\n" );fflush( stdout );
#endif

	Packet *packet = (Packet *)param;

	vector<SentMessage>::iterator msg = IpMessengerAgentImpl::GetInstance()->GetSentMessages()->FindSentMessageByPacket( *packet );
	if ( msg == IpMessengerAgentImpl::GetInstance()->GetSentMessages()->end() ){
		close( packet->TcpSocket() );
		delete packet;
		return 0;
	}
	vector<AttachFile>::iterator FoundFile = msg->FindAttachFileByPacket( *packet );
	if ( FoundFile == msg->Files().end() ){
		close( packet->TcpSocket() );
		delete packet;
		return 0;
	}

	FoundFile->setIsDownloading( true );
	IpMessengerAgentImpl::GetInstance()->SendFile( packet->TcpSocket(),
												   FoundFile->FullPath(),
												   FoundFile->MTime(),
												   FoundFile->FileSize(),
												   &(*FoundFile),
												   GetSendFileOffsetInPacket( *packet ) );
	FoundFile->setIsDownloading( false );
	FoundFile->setIsDownloaded( true );
	close( packet->TcpSocket() );
	delete packet;
	return NULL;
}

/**
 * TODO Ρ
 * ʸ٥ȡBR_RELEASEFILES
 *  TODO Ρ
 * @param packet ѥåȥ֥
 */
int
IpMessengerAgentImpl::UdpRecvEventReleaseFiles( Packet packet )
{
#if defined(INFO) || !defined(NDEBUG)
	printf( "TcpRecvEventReleaseFiles\n" );fflush( stdout );
#endif
	char *dmyptr;
	unsigned long packetNo = strtoul( packet.Option().c_str(), &dmyptr, 10 );
	vector<SentMessage>::iterator sentMsg = sentMsgList.FindSentMessageByPacketNo( packetNo );
	if ( sentMsg != sentMsgList.end() ) {
		sentMsgList.erase(sentMsg);
	}
	return 0;
}

/**
 * ʸ٥ȡBR_GETPUBKEY
 * RSAANSPUBKEYˤΤ롣
 * @param packet ѥåȥ֥
 */
int
IpMessengerAgentImpl::UdpRecvEventGetPubKey( Packet packet )
{
#ifdef HAVE_OPENSSL
	char sendBuf[MAX_UDPBUF];
	int sendBufLen;
	char optBuf[MAX_UDPBUF];
	int optBufLen;

#if defined(INFO) || !defined(NDEBUG)
	printf("UdpRecvGetPubKey[%s]\n", packet.Option().c_str());fflush( stdout );
#endif
	char *dmyptr;
	unsigned long cap = strtoul( packet.Option().c_str(), &dmyptr, 16 );
	RSA *rsa = GetOptimizedRsa( cap );
	if ( rsa != NULL ){
		optBufLen = snprintf( optBuf, sizeof( optBuf ), "%lx:%s-%s", encryptionCapacity, BN_bn2hex(rsa->e), BN_bn2hex(rsa->n) );
		sendBufLen = CreateNewPacketBuffer( IPMSG_ANSPUBKEY,
											  _LoginName, _HostName,
											  optBuf, optBufLen,
											  sendBuf, sizeof( sendBuf ) );
		SendPacket( IPMSG_ANSPUBKEY, sendBuf, sendBufLen, packet.Addr() );
	}
#endif
	return 0;
}

/**
 * ʸ٥ȡBR_ANSPUBKEY
 * RSAۥȥꥹȤ˹롣
 * @param packet ѥåȥ֥
 */
int
IpMessengerAgentImpl::UdpRecvEventAnsPubKey( Packet packet )
{
#ifdef HAVE_OPENSSL
#if defined(INFO) || !defined(NDEBUG)
	printf("UdpRecvAnsPubKey[%s]\n", packet.Option().c_str());fflush( stdout );
#endif
	//OptionHexɽ
	//XXXXX:EEEEE-NNNNN
	//XXXXX=ǽϥե饰HEXɽ
	//EEEEE=RSAʻؿ
	//NNNNN=RSA⥸塼
	char *opt = (char *)calloc( packet.Option().length() + 1, 1 );
	if ( opt == NULL ){
		return 0;
	}
	memcpy( opt, packet.Option().c_str(), packet.Option().length() );
	opt[packet.Option().length()] = 0;
	char *nextpos;
	char *token = strtok_r( opt,PACKET_DELIMITER_STRING, &nextpos );
	unsigned long cap = 0UL;
	if ( token != NULL ){
		char *dmyptr;
		cap = strtoul( opt, &dmyptr, 16 );
	} else {
		free( opt );
		return 0;
	}
	token = nextpos;
	token = strtok_r( token, "-", &nextpos );
	string meth;
	if ( nextpos != NULL ) {
		meth = token;
	} else {
		free( opt );
		return 0;
	}
	string pkey;
	if ( token != NULL ) {
		pkey = nextpos;
	} else {
		free( opt );
		return 0;
	}
	free( opt );
	char ipaddrbuf[100];
	string pIpAddress = inet_ntoa_r( packet.Addr().sin_addr.s_addr, ipaddrbuf, sizeof( ipaddrbuf ) );
	vector<HostListItem>::iterator hostIt = hostList.FindHostByAddress( pIpAddress );
	if ( hostIt != hostList.end() ) {
		hostIt->setEncryptionCapacity( cap );
		hostIt->setPubKeyHex( pkey );
		hostIt->setEncryptMethodHex( meth );
	}
#endif
	return 0;
}

/**
 * ʸ٥ȡGETDIRFILES
 * ѥåȤǻꤵ줿ǥ쥯ȥ롣
 * @param packet ѥåȥ֥
 */
int
IpMessengerAgentImpl::TcpRecvEventGetDirFiles( Packet packet )
{
#ifdef HAVE_PTHREAD
	pthread_t t_id;
	Packet *packetClone = new Packet( packet );

	if ( pthread_create( &t_id, NULL, GetDirFilesThread, (void *)packetClone ) != 0 ){
		perror("TcpRecvEventGetFileData:pthread_create");
		return -1;
	}
	if ( pthread_detach( t_id ) != 0 ){
		perror("TcpRecvEventGetFileData:pthread_detach");
		return -1;
	}

#else	// HAVE_PTHREAD
	Packet *packetClone = new Packet( packet );
	GetDirFilesThread( (void *) packetClone );
#endif	// HAVE_PTHREAD
	return 0;
}

/**
 * ǥ쥯ȥɥå
 * ǥ쥯ȥɤ롣
 * @param param ѥåȥ֥(void*)
 */
void *
GetDirFilesThread( void *param )
{
	Packet *packet = (Packet *)param;
#if defined(INFO) || !defined(NDEBUG)
	printf( "TcpRecvEventGetDirFiles\n" );fflush( stdout );
#endif
	vector<SentMessage>::iterator msg = myInstance->GetSentMessages()->FindSentMessageByPacket( *packet );
	if ( msg == myInstance->GetSentMessages()->end() ){
		close( packet->TcpSocket() );
		delete packet;
		return 0;
	}
	vector<AttachFile>::iterator FoundFile = msg->FindAttachFileByPacket( *packet );
	if ( FoundFile == msg->Files().end() ){
		close( packet->TcpSocket() );
		delete packet;
		return 0;
	}

	vector<string> DownloadFileList;
	FoundFile->setIsDownloading( true );
	myInstance->SendDirData( packet->TcpSocket(), FoundFile->FileName(), FoundFile->FullPath(), DownloadFileList );
	FoundFile->setIsDownloading( false );
	FoundFile->setIsDownloaded( true );
	close( packet->TcpSocket() );
	delete packet;

	return NULL;
}

/**
 * ǥ쥯ȥ
 * @param sock TCPå
 * @param cd ؤƤǥ쥯ȥ̾
 * @param dir ƥǥ쥯ȥΥեѥ
 * @param files ե
 */
bool
IpMessengerAgentImpl::SendDirData( int sock, string cd, string dir, vector<string> &files )
{
	DIR *d= opendir( dir.c_str() );
	struct dirent *dent;
	struct stat st;
	char headbuf[8192];

	if ( d == NULL ) {
		return false;
	}

	stat( cd.c_str(), &st );
	int head_len = snprintf( headbuf, sizeof( headbuf ), "0000:%s:%llx:%lx:%lx=%lx:%lx=%lx:",
														converter->ConvertLocalToNetwork( cd.c_str() ).c_str(),
														(unsigned long long)st.st_size,
														IPMSG_FILE_DIR,
														IPMSG_FILE_MTIME, st.st_mtime,
														IPMSG_FILE_CREATETIME, st.st_ctime );
	headbuf[ snprintf( headbuf, sizeof(headbuf),"%04x", head_len) ] = ':';
	send( sock, headbuf, head_len, 0 );

	dent = readdir( d );
	while( dent != NULL ) {
		if ( strcmp(dent->d_name, "." ) != 0 && strcmp(dent->d_name, ".." ) != 0 ) {
			string dir_name = dir + "/" + dent->d_name;
#if defined(INFO) || !defined(NDEBUG)
			printf( "dir[%s]", dir_name.c_str() );fflush( stdout );
#endif
			stat( dir_name.c_str(), &st );
			files.push_back( dir_name );
			if ( S_ISDIR( st.st_mode ) ){
#if defined(INFO) || !defined(NDEBUG)
				printf( "DIR\n" );fflush( stdout );
#endif
				if ( !SendDirData( sock, dent->d_name, dir_name, files ) ){
					closedir( d );
					return false;
				}
			} else {
#if defined(INFO) || !defined(NDEBUG)
				printf( "FILE\n" );fflush( stdout );
#endif
				int head_len = snprintf( headbuf, sizeof( headbuf ), "0000:%s:%llx:%lx:%lx=%lx:%lx=%lx:",
																	converter->ConvertLocalToNetwork( dent->d_name ).c_str(),
																	(unsigned long long)st.st_size,
																	IPMSG_FILE_REGULAR,
																	IPMSG_FILE_MTIME, st.st_mtime,
																	IPMSG_FILE_CREATETIME, st.st_ctime );
				headbuf[ snprintf( headbuf, sizeof(headbuf),"%04x", head_len) ] = ':';
				send( sock, headbuf, head_len, 0 );

				if ( !SendFile( sock, dir_name, st.st_mtime, st.st_size, NULL , 0 ) ){
					closedir( d );
					return false;
				}
			}
		}
		dent = readdir( d );
	}
	head_len = snprintf( headbuf, sizeof( headbuf ), "0000:.:0:%lx:", IPMSG_FILE_RETPARENT );
	headbuf[ snprintf( headbuf, sizeof(headbuf),"%04x", head_len) ] = ':';
	send( sock, headbuf, head_len, 0 );
	closedir( d );
	return true;
}

/**
 * ե
 * @param sock TCPå
 * @param FileName եΥեѥ
 * @param offset եå
 * @retval true:false:
 */
bool
IpMessengerAgentImpl::SendFile( int sock, string FileName, time_t mtime, unsigned long long size, AttachFile *file, off_t offset )
{
	string localFileName = converter->ConvertNetworkToLocal( FileName.c_str() );
	char readbuf[8192];
	struct stat st_init;
	int read_size;
	unsigned long long transSize = 0LL;
	int fd = open( localFileName.c_str(), O_RDONLY );

	if ( file != NULL ) file->setTransSize( offset );

	if ( fd < 0 ) {
		perror( "open" );
#ifdef DEBUG
		printf("FileName.c_str() [%s]\n", FileName.c_str() );fflush(stdout);
#endif
		return false;
	}
	int rc = fstat( fd, &st_init );
	if ( rc != 0 ){
		close( fd );
		return false;
	}
	lseek( fd, offset, SEEK_SET );
	read_size = read( fd, readbuf, sizeof( readbuf ) );
	while( read_size > 0 ){
		if ( AbortDownloadAtFileChanged() ){
			struct stat st_progress;
			int rc = stat( localFileName.c_str(), &st_progress );
			if ( rc != 0 ){
#ifdef DEBUG
				printf("FileName.c_str() [%s]\nFile Changed.\n", FileName.c_str() );fflush(stdout);
#endif
				close( fd );
				return false;
			}
			if ( mtime            != st_progress.st_mtime ||
				 st_init.st_ctime != st_progress.st_ctime ||
				 st_init.st_uid   != st_progress.st_uid   ||
				 st_init.st_gid   != st_progress.st_gid   ||
				 size             != (unsigned long long)st_progress.st_size ) {
#ifdef DEBUG
				printf("FileName.c_str() [%s]\nFile Changed.\n", FileName.c_str() );fflush(stdout);
#endif
				close( fd );
				return false;
			}
#ifdef DEBUG
			printf("FileName.c_str() [%s]\nFile Unchanged.\n", FileName.c_str() );fflush(stdout);
#endif
		}
		send( sock, readbuf, read_size, 0 );
		transSize += read_size;
		if ( file != NULL ) file->setTransSize( transSize );
		read_size = read( fd, readbuf, sizeof( readbuf ) );
	}
	close( fd );
	return true;
}

/**
 * åѥåȥåʸ'\0'ʹߤե롣
 * @param option ѥåȥץ
 * @param files źեեΰ
 */
int
IpMessengerAgentImpl::CreateAttachedFileList( const char *option, AttachFileList &files )
{
	files.clear();
	int filelist_startpos = strlen( option ) + 1;
	int alloc_size = strlen( &option[filelist_startpos] );
	if ( alloc_size == 0 ) {
		return 0;
	}
	alloc_size++;

	char *file_list_tmp_ptr;
	char *nextpos;
	char *token;
	char *ptrdmy;
	char *file_list_tmp_buf = (char *)calloc( alloc_size, 1 );
	if ( file_list_tmp_buf == NULL ) {
		return 0;
	}
	memset( file_list_tmp_buf, 0, alloc_size );
	memcpy( file_list_tmp_buf,  &option[filelist_startpos] , alloc_size - 1 );
#if defined(INFO) || !defined(NDEBUG)
	printf("File List Buffer = [%s]\n", file_list_tmp_buf);fflush( stdout );
#endif

	IpMsgPrintBuf("CreateAttachedFileList:file_list_tmp_buf",  file_list_tmp_buf, alloc_size );

	// USER NAME(1st)
	file_list_tmp_ptr = file_list_tmp_buf;
	token = strtok_r( file_list_tmp_ptr, PACKET_DELIMITER_STRING, &nextpos );
	IpMsgPrintBuf("CreateAttachedFileList:file_list_tmp_ptr",  file_list_tmp_ptr, alloc_size );
	IpMsgPrintBuf("CreateAttachedFileList:token",  token, alloc_size );

	while( token != NULL ) {
		bool eob = false;
		while( 1 ) {
			AttachFile file;
#if defined(DEBUG) || !defined(NDEBUG)
			printf("AttachFile(-1)\n" );fflush(stdout);
#endif
			// FILE ID
			if ( token != NULL && *token == '\a' ) eob = true;
			if ( token == NULL || *token == '\a' ) break;
			file.setFileId( strtoul( token, &ptrdmy, 10 ) );
#if defined(DEBUG) || !defined(NDEBUG)
			printf( "file.FileId() %d token [%s]\n", file.FileId(), token );fflush(stdout);
#endif
			// FILE NAME
			file_list_tmp_ptr = nextpos;
			token = strtok_r( file_list_tmp_ptr, PACKET_DELIMITER_STRING, &nextpos );
			if ( token != NULL && *token == '\a' ) eob = true;
			if ( token == NULL || *token == '\a' ) break;
			file.setFileName( token );
			// FILE SIZE
			file_list_tmp_ptr = nextpos;
			token = strtok_r( file_list_tmp_ptr, PACKET_DELIMITER_STRING, &nextpos );
			if ( token != NULL && *token == '\a' ) eob = true;
			if ( token == NULL || *token == '\a' ) break;
			file.setFileSize( strtoul( token, &ptrdmy, 16 ) );
			// MTIME
			file_list_tmp_ptr = nextpos;
			token = strtok_r( file_list_tmp_ptr, PACKET_DELIMITER_STRING, &nextpos );
			if ( token != NULL && *token == '\a' ) eob = true;
			if ( token == NULL || *token == '\a' ) break;
			file.setMTime( strtoul( token, &ptrdmy, 16 ) );
			// ATTR
			file_list_tmp_ptr = nextpos;
			token = strtok_r( file_list_tmp_ptr, PACKET_DELIMITER_STRING, &nextpos );
			if ( token != NULL && *token == '\a' ) eob = true;
			if ( token == NULL || *token == '\a' ) break;
			file.setAttr( strtoul( token, &ptrdmy, 16 ) );
			while( token != NULL && *token != '\a' ) {
				file_list_tmp_ptr = nextpos;
				token = strtok_r( file_list_tmp_ptr, PACKET_DELIMITER_STRING, &nextpos );
				if ( token != NULL && *token == '\a' ) eob = true;
				if ( token == NULL || *token == '\a' ) break;
				int pos = -1;
				for( int i = 0; token[i] != '\0'; i++ ){ 
					if ( token[i] == '=' ) {
						token[i] = '\0';
						pos = i + 1;
						break;
					}
				}
				if ( pos >= 0 ) {
					ptrdmy = &token[pos];
					char *topchar = ptrdmy;
					while( *ptrdmy != '\0' ) {
						file.addExtAttrs( token, strtoul( topchar, &ptrdmy, 16 ) );
						topchar = ++ptrdmy;
					}
				}
			}
#if defined(DEBUG) || !defined(NDEBUG)
			printf("\n\n");fflush(stdout);
			printf("== FILE  ==============================>\n");fflush( stdout );
			printf("FILE ID[%d]\n", file.FileId());fflush( stdout );
			printf("FILE NAME[%s]\n", file.FileName().c_str());fflush( stdout );
			printf("FILE SIZE[%lld]\n", file.FileSize());fflush( stdout );
			time_t tt = file.MTime();
			printf("MTIME[%s]\n", ctime( &tt ) );fflush( stdout );
			printf("ATTR[%lu]\n", file.Attr() );fflush( stdout );
			for( map<string, vector<unsigned long> >::iterator ixextattr = file.beginExtAttrs(); ixextattr != file.endExtAttrs(); ixextattr++){
				printf("EXT ATTR[%s]==", ixextattr->first.c_str() );fflush( stdout );
				for( vector<unsigned long>::iterator ixextattrv = ixextattr->second.begin(); ixextattrv != ixextattr->second.end(); ixextattrv++){
					printf("[%lu]", *ixextattrv );fflush( stdout );
				}
				printf("\n" );fflush( stdout );
			}
			printf("<= FILE  ===============================\n");fflush( stdout );
#endif
			// ADD FILELIST
#if defined(DEBUG) || !defined(NDEBUG)
			printf("AddFile()\n" );fflush( stdout );
#endif
			files.AddFile( file );
			break;
		}
		// FILE ID(not 1st)
		if ( token == NULL ){
#if defined(DEBUG) || !defined(NDEBUG)
			printf("File END,break;\n" );fflush( stdout );
#endif
			break;
		}
		if ( *token == '\a' ){
			token++;
		} else {
			file_list_tmp_ptr = nextpos;
			token = strtok_r( file_list_tmp_ptr, PACKET_DELIMITER_STRING, &nextpos );
		}
	}
	free( file_list_tmp_buf );
	return files.size();
}

/**
 * ۥȥꥹȼѥåȥץʥХåեˤۥȰ롣
 * @param hostListBuf Хåե
 * @param buf_len ХåեĹ
 */
int
IpMessengerAgentImpl::CreateHostList( const char * packetIpAddress, const char *packetHostName, const char *hostListBuf, int buf_len )
{
	int alloc_size = buf_len + 1;
	int add_count = 0;
	char *hostListTmpPtr;
	char *nextpos;
	char *token;
	char *ptrdmy;
	char *hostListTmpBuf = (char *)calloc( alloc_size, 1 );

#if defined(DEBUG) || !defined(NDEBUG)
IpMsgPrintBuf( "hostListBuf", hostListBuf, buf_len );
#endif
	AddDefaultHost();
	if ( hostListTmpBuf == NULL ) {
		return 0;
	}
	memset( hostListTmpBuf, 0, alloc_size );
	memcpy( hostListTmpBuf, hostListBuf, buf_len );
	hostListTmpPtr = hostListTmpBuf;
	// CONTINUE POSITION
	token = strtok_r( hostListTmpPtr, "\a", &nextpos );
	if ( token == NULL ) {
		free( hostListTmpBuf );
		return 0;
	}
	// LIST COUNTS
	hostListTmpPtr = nextpos;
	token = strtok_r( hostListTmpPtr, "\a", &nextpos );
	if ( token == NULL ) {
		free( hostListTmpBuf );
		return 0;
	}
	// USER NAME(1st)
	hostListTmpPtr = nextpos;
	token = strtok_r( hostListTmpPtr, "\a", &nextpos );

	while( token != NULL ) {
		HostListItem item;
		item.setVersion( "" );
		item.setAbsenceDescription( "" );
		item.setUserName( "" );
		item.setHostName( "" );
		item.setCommandNo( 0UL );
		item.setIpAddress( "" );
		item.setNickname( "" );
		item.setGroupName( "" );
		item.setEncodingName( "" );
		item.setPriority( "" );
		item.setPortNo( 0UL );
		item.setEncryptionCapacity( 0UL );
		item.setPubKeyHex( "" );
		item.setEncryptMethodHex( "" );
		// USER NAME
		if ( *token == '\b' ) {
			item.setUserName( "" );
			//'\b'ȶڤʸ'\a'ʬФ
			token += 2;
			nextpos = token;
		} else {
			item.setUserName( token );
		}
		hostListTmpPtr = nextpos;
		token = strtok_r( hostListTmpPtr, "\a", &nextpos );
		if ( token == NULL ) break;
		// HOST NAME
		hostListTmpPtr = nextpos;
		if ( *token == '\b' ) {
			item.setHostName( "" );
			//'\b'ȶڤʸ'\a'ʬФ
			token += 2;
			nextpos = token;
		} else {
			item.setHostName( token );
		}
		hostListTmpPtr = nextpos;
		token = strtok_r( hostListTmpPtr, "\a", &nextpos );
		if ( token == NULL ) break;
		// CommandNo
		hostListTmpPtr = nextpos;
		if ( *token == '\b' ) {
			item.setCommandNo( 0L );
			//'\b'ȶڤʸ'\a'ʬФ
			token += 2;
			nextpos = token;
		} else {
			item.setCommandNo( strtoul( token, &ptrdmy, 10 ) );
		}
		hostListTmpPtr = nextpos;
		token = strtok_r( hostListTmpPtr, "\a", &nextpos );
		if ( token == NULL ) break;
		// IP ADDRESS
		hostListTmpPtr = nextpos;
		if ( *token == '\b' ) {
			item.setIpAddress( "" );
			//'\b'ȶڤʸ'\a'ʬФ
			token += 2;
			nextpos = token;
		} else {
			//ANSLISTƤۥȥꥹȤIPɥ쥹롼ץХåξ礬ͭ롣IPå󥸥㡼ΥХʤΤʡ
			if ( strcmp( token, "127.0.0.1" ) == 0 ){
				//ѥåȤۥȤIPɥ쥹롼ץХåξϥѥåոIPɥ쥹ꤹ롣
				if ( item.HostName() == packetHostName ) {
					item.setIpAddress( packetIpAddress );
				} else {
					//ǤʤϤ롣AddHost᥽å̵뤵ۥȥꥹȤɲäʤ
					item.setIpAddress( token );
				}
			} else {
				//롼ץХåɥ쥹Ǥ̵ϤΤޤꤹ롣
				item.setIpAddress( token );
			}
		}
		hostListTmpPtr = nextpos;
		token = strtok_r( hostListTmpPtr, "\a", &nextpos );
		if ( token == NULL ) break;
		// PORTNO
		hostListTmpPtr = nextpos;
		if ( *token == '\b' ) {
			item.setPortNo( 0L );
			//'\b'ȶڤʸ'\a'ʬФ
			token += 2;
			nextpos = token;
		} else {
			item.setPortNo( ntohs( strtoul( token, &ptrdmy, 10 ) ) );
		}
		hostListTmpPtr = nextpos;
		token = strtok_r( hostListTmpPtr, "\a", &nextpos );
		if ( token == NULL ) break;
		// NICKNAME
		hostListTmpPtr = nextpos;
		if ( *token == '\b' ) {
			item.setNickname( "" );
			//'\b'ȶڤʸ'\a'ʬФ
			token += 2;
			nextpos = token;
		} else {
			item.setNickname( token );
		}
		hostListTmpPtr = nextpos;
		token = strtok_r( hostListTmpPtr, "\a", &nextpos );
		if ( token == NULL ) break;
		// GROUPNAME
		hostListTmpPtr = nextpos;
		if ( *token == '\b' ) {
			item.setGroupName( "" );
			//'\b'ȶڤʸ'\a'ʬФ
			token += 2;
			nextpos = token;
		} else {
			item.setGroupName( token );
		}
		hostListTmpPtr = nextpos;
		token = strtok_r( hostListTmpPtr, "\a", &nextpos );
		//ǸΥȡϺǸȽꤹ롣(A)ʬ
		// ADD HOSTLIST
		hostList.DeleteHost( item.HostName() );
		hostList.AddHost( item );

#ifdef HAVE_OPENSSL
		char sendBuf[MAX_UDPBUF];
		int sendBufLen;
		char optBuf[MAX_UDPBUF];
		int optBufLen;
		optBufLen = snprintf( optBuf, sizeof( optBuf ), "%lx", encryptionCapacity );
		sendBufLen = CreateNewPacketBuffer( IPMSG_GETPUBKEY,
											  _LoginName, _HostName,
											  optBuf, optBufLen,
											  sendBuf, sizeof( sendBuf ) );
		struct sockaddr_in addr;
		addr.sin_family = AF_INET;
		addr.sin_port = htons( item.PortNo() );
		addr.sin_addr.s_addr = inet_addr( item.IpAddress().c_str() );
		SendPacket( IPMSG_GETPUBKEY, sendBuf, sendBufLen, addr );
#endif
		//(A)ǸΥȡϺǸȽꤹ롣(A)
		if ( token == NULL ) break;
		add_count++;
	}
	free( hostListTmpBuf );
	return add_count;
}

/**
 * åθĿ롣
 * @retval åθĿ
 */
int
IpMessengerAgentImpl::GetRecievedMessageCount()
{
	return recvMsgList.size();
}

/**
 * åļФåꥹȤ롣
 * @retval å֥ȡ
 */
RecievedMessage
IpMessengerAgentImpl::PopRecievedMessage()
{
	RecievedMessage ret;
	for( vector<RecievedMessage>::iterator ix = recvMsgList.begin(); ix != recvMsgList.end(); ix++ ){
		ret = *ix;
		recvMsgList.erase( ix );
		break;
	}
	return ret;
}

/**
 * ѥåꥹȤΥݥ󥿤롣
 * @retval ѥåꥹȤΥݥ󥿡
 */
SentMessageList *
IpMessengerAgentImpl::GetSentMessages()
{
	return &sentMsgList;
}

/**
 * ѥåꥹȤΥԡ롣
 * @retval ѥåꥹȤΥԡ
 */
SentMessageList
IpMessengerAgentImpl::CloneSentMessages()
{
	return sentMsgList;
}

/**
 * ץκĹ롣
 * @retval ץƤХåեĹ
 */
int
IpMessengerAgentImpl::GetMaxOptionBufferSize()
{
	char tmp[MAX_UDPBUF];
	int headSize = snprintf(tmp, sizeof(tmp), "%d:0000000000:%s:%s:0000000000:", IPMSG_VERSION, _LoginName.c_str(), _HostName.c_str() );
	int ret = MAX_UDPBUF - headSize;
	return ret < 0 ? 0 : ret;
}

unsigned long
IpMessengerAgentImpl::AddCommonCommandOption( const unsigned long cmd )
{
	unsigned long ret = cmd | IPMSG_FILEATTACHOPT
#ifdef HAVE_OPENSSL
							| ( encryptionCapacity != 0UL ?  IPMSG_ENCRYPTOPT : 0UL )
#endif	//HAVE_OPENSSL
							| ( IsAbsence() ? IPMSG_ABSENCEOPT : 0UL ) | ( IsDialup() ? IPMSG_DIALUPOPT : 0UL );
#if defined(INFO) || !defined(NDEBUG)
	printf("<<<<<<<<<<<<<<<<<<<<<<<<<<<AddCommonCommandOption<<<<<<<<<<<<<<<<<<<<<<<<<<<\n");fflush( stdout );
	printf( "Option=%lu\n", ret );fflush( stdout );
	printf(">>>>>>>>>>>>>>>>>>>>>>>>>>>AddCommonCommandOption>>>>>>>>>>>>>>>>>>>>>>>>>>>\n");fflush( stdout );
#endif
	return ret;
}

/**
 * ѥХåե롣
 * @param cmd ޥ
 * @param packetNo ѥåֹ
 * @param user ΥۥȤΥ桼̾
 * @param host ΥۥȤΥۥ̾
 * @param opt Ϣ뤹륪ץʸ
 * @param optLen ץĹ
 * @param buf Хåե
 * @param size Хåեκ祵
 * @retval ХåեĹ
 */
int
IpMessengerAgentImpl::CreateNewPacketBuffer(unsigned long cmd, unsigned long packetNo, string user, string host, const char *opt, int optLen, char *buf, int size )
{
#if defined(INFO) || !defined(NDEBUG)
	printf( "CMD[%s]\n", GetCommandString( GET_MODE( cmd ) ).c_str() );fflush( stdout );
#endif
	memset( buf, 0, size );
	//Version:PacketNo:UserName:HostName:Command[:Option]
	int send_size = snprintf(buf, size, "%d:%ld:%s:%s:%ld:",
										IPMSG_VERSION,
										packetNo,
										user == "" ? "\b" : user.c_str(),
										host == "" ? "\b" : host.c_str(),
										cmd );
	if ( optLen > 0 && opt != NULL) {
		memcpy(&buf[send_size], opt, optLen );
	} else {
		optLen = 0;
	}
	return send_size + optLen;
}

/**
 * ѥХåե롣(ѥåֹ漫ư)
 * @param cmd ޥ
 * @param user ΥۥȤΥ桼̾
 * @param host ΥۥȤΥۥ̾
 * @param opt Ϣ뤹륪ץʸ
 * @param optLen ץĹ
 * @param buf Хåե
 * @param size Хåեκ祵
 * @retval ХåեĹ
 */
int
IpMessengerAgentImpl::CreateNewPacketBuffer(unsigned long cmd, string user, string host, const char *opt, int optLen, char *buf, int size )
{
	unsigned long packetNo = random();
	return CreateNewPacketBuffer(cmd, packetNo, user, host, opt, optLen, buf, size );
}

/**
 * Хåեѥåȥ֥Ȥ롣
 * @param packet_buf Хåե
 * @param size ХåեΥ
 * @param sender ɥ쥹
 * @retval ѥåȥ֥
 */
Packet
IpMessengerAgentImpl::DismantlePacketBuffer( char *packet_buf, int size, struct sockaddr_in sender, time_t nowTime )
{
	Packet ret;
	int alloc_size = size + 1;
	char *packet_tmp_buf;
	char *packet_tmp_ptr;
	char *nextpos;
	char *token;
	char *ptrdmy;

	ret.setRecieved( nowTime );
	packet_tmp_buf = (char *)calloc( alloc_size, 1 );
	if ( packet_tmp_buf == NULL ) {
		return ret;
	}
	memset( packet_tmp_buf, 0, alloc_size );
	memcpy( packet_tmp_buf, packet_buf, size );
	//VERSION NUMBER
	packet_tmp_ptr = packet_tmp_buf;
	token = strtok_r( packet_tmp_buf, PACKET_DELIMITER_STRING, &nextpos );
	if ( token == NULL ) {
		free( packet_tmp_buf );
		return ret;
	}
	ret.setVersionNo( strtoul( token, &ptrdmy, 10 ) );

	//PACKET NUMBER
	packet_tmp_ptr = nextpos;
	token = strtok_r( packet_tmp_ptr, PACKET_DELIMITER_STRING, &nextpos );
	if ( token == NULL ) {
		free( packet_tmp_buf );
		return ret;
	}
	ret.setPacketNo( strtoul( token, &ptrdmy, 10 ) );

	//USER
	packet_tmp_ptr = nextpos;
	token = strtok_r( packet_tmp_ptr, PACKET_DELIMITER_STRING, &nextpos );
	if ( token == NULL ) {
		free( packet_tmp_buf );
		return ret;
	}
	ret.setUserName( token );

	//HOST
	packet_tmp_ptr = nextpos;
	token = strtok_r( packet_tmp_ptr, PACKET_DELIMITER_STRING, &nextpos );
	if ( token == NULL ) {
		free( packet_tmp_buf );
		return ret;
	}
	ret.setHostName( token );

	//COMMAND
	packet_tmp_ptr = nextpos;
	token = strtok_r( packet_tmp_ptr, PACKET_DELIMITER_STRING, &nextpos );
	if ( token == NULL ) {
		free( packet_tmp_buf );
		return ret;
	}
	unsigned long command = strtoul( token, &ptrdmy, 10 ); 
	ret.setCommandMode( GET_MODE(command) );
	ret.setCommandOption( GET_OPT(command) );

	//OPTION
	int optLen = size - ( nextpos - packet_tmp_buf );
	ret.setOption( string( nextpos, optLen ) );
	free( packet_tmp_buf );

	vector<HostListItem>::iterator hostIt = hostList.FindHostByHostName( ret.HostName() );
	if ( hostIt != hostList.end() ) {
		struct sockaddr_in hostaddr;
		hostaddr.sin_family = AF_INET;
		hostaddr.sin_addr.s_addr = inet_addr( hostIt->IpAddress().c_str() );
		hostaddr.sin_port = htons( hostIt->PortNo() );
		ret.setAddr( hostaddr );
	} else {
		sender.sin_port = htons( IPMSG_DEFAULT_PORT );
		ret.setAddr( sender );
	}

	return ret;
}

/**
 * ѥåȤۥȥꥹȤ˲ä롣
 */
void
IpMessengerAgentImpl::AddHostListFromPacket( Packet packet )
{
#if defined(INFO) || !defined(NDEBUG)
	printf("===================================\n");fflush( stdout );
	printf("AddHostListFromPacket\n");fflush( stdout );
	printf("===================================\n");fflush( stdout );
	IpMsgDumpPacket( packet, packet.Addr() );
	printf("===================================\n");fflush( stdout );
#endif
	AddDefaultHost();
	// ǥեȤNIC()ʳμʬȤIPɥ쥹Ͽꤵ줿̵롣
	char ipaddrbuf[100];
	string packetIpAddress = inet_ntoa_r( packet.Addr().sin_addr.s_addr, ipaddrbuf, sizeof( ipaddrbuf ) );
	for( unsigned int i = 1; i < NICs.size(); i++ ){
		if ( packetIpAddress == NICs[i].IpAddress() ){
			AddDefaultHost();
			return;
		}
	}
	//ǥեȥ
	HostListItem item;
	item.setUserName( packet.UserName() );
	item.setHostName( packet.HostName() );
	item.setCommandNo( packet.CommandOption() );
	item.setIpAddress( inet_ntoa_r( packet.Addr().sin_addr.s_addr, ipaddrbuf, sizeof( ipaddrbuf ) ) );
	int NicknameLen = strlen( packet.Option().c_str() );
	item.setNickname( packet.Option().c_str() );
	item.setGroupName( packet.Option().c_str() + NicknameLen + 1 );
	item.setEncodingName( "" );
	item.setPriority( "" );
	item.setPortNo( ntohs( packet.Addr().sin_port ) );
	item.setEncryptionCapacity( 0UL );
	item.setPubKeyHex( "" );
	item.setEncryptMethodHex( "" );
	hostList.AddHost( item );
}

/**
 * ǰΤۥȥꥹȤ˼ʬäƤ
 * @retval Ͽۥȿ
 */
int
IpMessengerAgentImpl::AddDefaultHost()
{
	vector<HostListItem>::iterator hostIt = hostList.FindHostByAddress( HostAddress );
	if ( hostIt == hostList.end() ) {
		HostListItem myHost;
		myHost.setUserName( _LoginName );
		myHost.setHostName( _HostName );
		myHost.setCommandNo( AddCommonCommandOption( 0UL ) );
		myHost.setIpAddress( HostAddress );
		myHost.setNickname( Nickname );
		myHost.setGroupName( GroupName );
		myHost.setPortNo( IPMSG_DEFAULT_PORT );
		hostList.AddHost( myHost );
#if defined(INFO) || !defined(NDEBUG)
		printf("MyHost Add.[%s][%s]\n", myHost.UserName().c_str(), myHost.GroupName().c_str() );fflush( stdout );
#endif
		return 1;
	}
	return 0;
}
//end of source
