#pragma once
#include "Interface.h"
#include "Camera.h"
#include "VmdMotionController.h"

/// XLbV
class SkinMesh : public Drawable3D {
protected:
	/// { ///
	SkinMesh(LPDIRECT3DDEVICE9 pDevice);// IuWFNg֎~
	LPDIRECT3DDEVICE9 pDevice;			// Direct3DfoCXIuWFNg
	/// bV ///
	LPD3DXMESH pMesh;					// bV
	vector<D3DMATERIAL9> materials;		// }eAz
	vector<LPDIRECT3DTEXTURE9> textures;// eNX`z
	vector<D3DXBONECOMBINATION> boneCombination;// {[Rrl[Vz
	virtual LPD3DXSKININFO CreateSkinInfo(const vector<BlendVertex>, const unsigned int, const D3DVERTEXELEMENT9*);	// bV̂߂̃XL쐬
	virtual void DivideMesh(unsigned int numFace, LPD3DXMESH pOrgMesh, LPD3DXSKININFO pSkinInfo);					// uhspbg̃TCYzȂ悤ɃbV𕪊
	/// {[ ///
	vector<Bone> bones;					// {[\
	vector<ID3DXMesh*> boneObj;			// \p{[
	virtual void CreateBoneObj();													// \p{[쐬
	virtual vector<D3DXMATRIX> GetWorlds(const D3DXMATRIX* world);					// {[s񂩂ϊ[hϊs̔z擾
	/// VF[_ ///
	D3DXHANDLE hTech, hWorld, hView, hProj, hAmbient, hDiffuse, hLightDir, hTexture;// nh
	LPD3DXEFFECT pFX;		// VF[_
	void CreateShader();	// VF[_̍쐬
	/// {[s̍XV
	virtual void UpdateBoneMatrix() = 0;	// pɎ
public:
	virtual ~SkinMesh();
	virtual void AdvanceTime() = 0;						// Ԃ߂
	virtual void Draw(D3DXVECTOR3* position, D3DXMATRIX* rotation, D3DLIGHT9* light, Camera* camera);		// `
	virtual void DrawBoneObj(D3DXVECTOR3* position, D3DXMATRIX* rotation, D3DLIGHT9* light, Camera* camera);// {[\
};


/// MMDXLbV
class MmdSkinMesh sealed : public SkinMesh {
private:
	VmdMotionController* vmdMotionController;
	vector<MmdStruct::PmdIkData> pmdIkData;
	void LoadPmdfile(const LPCTSTR&, vector<MmdStruct::PmdVertex>&, vector<unsigned short>&, vector<MmdStruct::PmdMaterial>&, vector<MmdStruct::PmdBone>&);
	void CreateMesh(vector<MmdStruct::PmdVertex>, vector<unsigned short>, vector<MmdStruct::PmdMaterial>, const unsigned int numBone);
	void CreateBoneMatrix(vector<MmdStruct::PmdBone> pmdBones);
	void CopyMaterial(D3DMATERIAL9&, const MmdStruct::PmdMaterial&);
	void UpdateBoneMatrix() override;
public:
	MmdSkinMesh(LPCTSTR pmdFilename, LPCTSTR vmdFilename, LPDIRECT3DDEVICE9 pDevice);
	~MmdSkinMesh();
	void AdvanceTime();
};

