/**
 *
 *  You can modify and use this source freely
 *  only for the development of application related Live2D.
 *
 *  (c) Live2D Inc. All rights reserved.
 */
#pragma once

namespace live2d
{
	namespace framework
	{
		class L2DMatrix44
		{
		protected:
			float tr[16];// sf[^
			
		public:
			L2DMatrix44();
			virtual ~L2DMatrix44(){}
			
			// Pʍsɏ
			void identity() ;
			
			//  sz擾
			float* getArray(){ return tr; }
			
			//  sݒ
			void setMatrix( float* _tr );
			
			//  x̊g嗦擾
			float getScaleX(){return tr[0] ;}
			
			//  ẙg嗦擾
			float getScaleY(){return tr[5] ;}
			
			float getTranslateX(){return tr[12] ;}
			
			float getTranslateY(){return tr[13] ;}
			
			//  x̒l݂̍sŌvZ
			float transformX( float src );
			
			//  y̒l݂̍sŌvZ
			float transformY( float src );
			
			//  x̒l݂̍sŋtvZ
			float invertTransformX( float src );
			
			//  y̒l݂̍sŋtvZ
			float invertTransformY( float src );
			
			//  ړʂ̌vZ
			void multTranslate( float shiftX, float shiftY );
			void translate( float shiftX, float shiftY );
			void translateX( float shiftX ) {tr[12]=shiftX;}
			void translateY( float shiftY ) {tr[13]=shiftY;}
			
			//  g嗦̌vZ
			void multScale( float scaleX,float scaleY );
			void scale( float scaleX,float scaleY );
			
			//  󂯎Q̍s̊|Zs
			static void mul( float* a, float* b, float* dst );
			
			void append(L2DMatrix44* m);
		};
	}
}