/**
 *  DDTexture.h
 *
 *  Copyright(c) Live2D Inc. All rights reserved.
 *  [[ CONFIDENTIAL ]]
 */
#ifndef __LIVE2D_DDTEXTURE_H__
#define __LIVE2D_DDTEXTURE_H__


#ifndef __SKIP_DOC__

#include "../Live2D.h"
#include "IDrawData.h"
#include "../param/PivotManager.h"
#include "IDrawContext.h"

#ifdef L2D_TARGET_D3D
# include <d3dx9.h>
# include "../graphics/DrawParam_D3D.h"
#endif

#ifdef L2D_TARGET_D3D11
#include <d3d11.h>
# include "../graphics/DrawParam_D3D11.h"
#endif

#ifdef L2D_TARGET_PS4
#include <gnmx.h>
#endif

//------------ LIVE2D NAMESPACE ------------
namespace live2d
{ 
	class DDTextureContext ;
	
	
	
	class DDTexture : public IDrawData
	{
	public:
		static const int OPTION_FLAG_BARCODE_KANOJO_COLOR_CONVERT = 0x1 ;// o[R[hJmWŐFςsvf̏ꍇ 
		
		static const int MASK_COLOR_COMPOSITION = 0x1E ;//011110 
	
		static const int COLOR_COMPOSITION_NORMAL  = 0 ;// ʏ
		static const int COLOR_COMPOSITION_SCREEN  = 1 ;// XN[
		static const int COLOR_COMPOSITION_MULTIPLY= 2 ;// Z
	
		static int INSTANCE_COUNT ;
	
	public:
		DDTexture() ;
		virtual ~DDTexture(void) ;
		
	public:
		virtual void readV2(BReader & br , MemoryParam* memParam ) ;

		void initDirect(MemoryParam* memParam) ;
	
		//  w肵eNX`ԍɃZbg
		void setTextureNo(int no){ this->textureNo = no ; }
	
		//  eNX`ԍ擾
		int getTextureNo(){ return this->textureNo ; }
		
		//  uvz [ numPts*2 ]
		l2d_uvmapf * getUvMap(){ return this->uvmap ; }
		
		//  _Ԃ
		int getNumPoints(){ return this->numPts ; }
	
		//  |SԂ
		int getNumPolygons(){ return this->numPolygons ; }
		
		virtual IDrawContext* init(ModelContext &mdc) ;
		
		virtual void setupInterpolate(ModelContext &mdc , IDrawContext* cdata ) ;
		
		virtual void setupTransform(ModelContext &mdc , IDrawContext* cdata ) ;
	
		virtual void preDraw(DrawParam& dp, ModelContext& mdc, IDrawContext* cdata) ;

		virtual void draw( DrawParam & dp , ModelContext &mdc , IDrawContext* cdata ) ;
	
	#ifdef L2D_TARGET_D3D
	
		void setupBufD3D( DrawParam_D3D& dpD3D , ModelContext &mdc , DDTextureContext* cdata ) ;
	
		virtual void deviceLost( IDrawContext* drawContext ) ;
	#endif
	#ifdef L2D_TARGET_D3D11

		void setupBufD3D(DrawParam_D3D11& dpD3D, ModelContext &mdc, DDTextureContext* cdata);

		virtual void deviceLost(IDrawContext* drawContext);
	#endif

		//  eNX`^Cv擾
		virtual int getType(){ return TYPE_DD_TEXTURE ; }// 
	
		int getOptionFlag(){ return this->optionFlag ; }
	
		virtual void setZ_TestImpl( ModelContext &mdc , IDrawContext* _cdata , float z ) ;
	
		l2d_index*  getIndexArray(int* polygonCount);

	#if AVATAR_OPTION_A
		//  F擾	
		int getOption_KanojoColor(){ return this->optionKanojoColor ; }
	
	#endif
	
	#ifdef L2D_DEBUG
		virtual void dump() ;
	#endif
	
	private:
		// Prevention of copy Constructor
		DDTexture( const DDTexture & ) ;				
		DDTexture& operator=( const DDTexture & ) ;		
	
	private:
		int						textureNo ;				// gpeNX`ԍif̊ǗeNX`ԍj
		int						numPts ;				// _̐iPSPsceGumDrawArray ł 65535܂łɂȂj
		int						numPolygons ;			// |S̐
		int						optionFlag ;			// IvVݒ
		
		// --- KvɉĐݒ肳IvVl
	#if AVATAR_OPTION_A
		int						optionKanojoColor ;		// Avatar̃IvVioptionFlag & DDMorph.OPTION_FLAG_BARCODE_KANOJO_COLOR_CONVERTĂꍇj
	#endif
		
		l2d_index *				indexArray ;			// _CfbNXz [numPolygons*3]
	
		//  points ( Pivotz )̃[ (   xnum=3 , ynum=4 , znum=2 ̃p[^̏ꍇ )
		//  [x0,y0,z0],[x1,y0,z0],[x2,y0,z0]  , [x0,y1,z0],[x1,y1,z0],[x2,y1,z0].. ƂȂ
		
		LDVector<l2d_paramf*>*	pivotPoints ;			// ԗppivotSĎ_z [numPivots][numPts*2]
		l2d_uvmapf *			uvmap ;					// uvz [ numPts*2 ]
		int						colorCompositionType ;	// F̃^Cv
		bool					culling ;				// 1.0beta3
	};
	
	
	class DDTextureContext : public IDrawContext 
	{
	public:
		DDTextureContext(IDrawData* src) ;
		virtual ~DDTextureContext() ;
		
	public:		
		// ϊς݂̓_Ԃ 
		// pointCount ͓_̐Ԃi_ix,yjpointCountԂ̂ŁApointCount*2̔zƂȂj
		l2d_pointf* getTransformedPoints( int* pointCount ) ;
	
	public:		
		int 				tmpBaseDataIndex ;		// IBaseDatãCfbNXBsςȂ̂ňx擾΂悢
		l2d_pointf * 		interpolatedPoints ;	// Ԃꂽ_ 	PSP̏ꍇ́A[numPts*5]@/ OpenGL̏ꍇ [numPts*2]( texture x,y , ԁEό`ꂽ̓_ x,y , z=0 ) 
		l2d_pointf * 		transformedPoints ;		// ό`ꂽ_
		l2d_pointf * 		drawPoints ;			// `p̓_i_uobt@p̏ꍇ̓XbvĎgj0.9.00b14
		
		unsigned char 		not_updated_count ;		// XVȂ񐔂JEg\nPڂƂQڂňӖB\ndouble buffer̂ƂXVȂ΂̂܂ܑO̒lg
		
	#ifdef L2D_TARGET_D3D
		LPDIRECT3DVERTEXBUFFER9 		pUvBuf ; // Uvz
		LPDIRECT3DINDEXBUFFER9 			pIndexBuf ; // CfbNXz
	#endif

	#ifdef L2D_TARGET_D3D11
		ID3D11Buffer* pUvBuf;		// eNX`uvobt@
		ID3D11Buffer* pIndexBuf;	// CfbNXobt@
	#endif

	#ifdef L2D_TARGET_PS4
		bool initializedBuffer;
		float* color;//x܂߂|킹FBfloat[4]BVF[_p
		sce::Gnm::Buffer buffers[2];//position , textureUV 
	#endif
	} ;
} 
//------------ LIVE2D NAMESPACE ------------

#endif // __SKIP_DOC__

#endif	// __LIVE2D_DDTEXTURE_H__
