/**
 * Live2D SDK for DirectX 
 *
 *  You can modify and use this source freely
 *  only for the development of application related Live2D.
 *
 *  (c) Live2D Inc. All rights reserved.
 */

#ifndef BENCHMARK_MAIN_H
#define BENCHMARK_MAIN_H

#include <windows.h>
#include <d3d11.h>
#include <vector>

// KvȃCut@C̃[h
#pragma comment(lib,"d3d11.lib")
#pragma comment(lib, "winmm.lib")

// 萔`
const SIZE WINDOW_SIZE = { 800, 800 };
LPCWSTR APP_NAME = L"Benchmark";
const int NUM_MODELS = 10; // \郂f̐

// O錾
namespace live2d
{
	class Live2DModelD3D11;
	class MotionQueueManager;
	class Live2DMotion;
}

class Application
{
public:
	static LRESULT CALLBACK wndProcWrapper(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

	Application();
	~Application();

	// EBhEvV[W
	LRESULT wndProc(HWND hWnd, UINT iMsg, WPARAM wParam, LPARAM lParam);

	// EBhȄ
	HRESULT initWindow(HINSTANCE hInstance, INT x, INT y, 
		SIZE windowSize, LPCWSTR windowName);

	// Direct3D̏
	HRESULT initGraphics();

	// Live2D̏
	HRESULT initLive2D();

	// Live2DModel𐶐
	HRESULT initModel();

	// AvP[ṼbZ[W[v
	void mainLoop();

	// AvP[ṼC
	// t[Ă΂
	void process();

	// `揈s
	void render();

	// FPŠvZs
	void calculateFPS();

	// Live2D̉s
	void destroyLive2D();

	// Live2DModelj
	void destroyModel();

	// Direct3DIuWFNgj
	void destroyGraphics();

private:
	HWND _hWnd;
	SIZE _windowSize;
	ID3D11Device* _device;
	ID3D11DeviceContext* _deviceContext;
	IDXGISwapChain* _swapChain;
	ID3D11RenderTargetView* _backBufferRTV;

	live2d::Live2DModelD3D11* _live2DModels[NUM_MODELS];
	int _modelPositions[NUM_MODELS];
	std::vector<ID3D11ShaderResourceView*> _textures; // f̃eNX`
	live2d::MotionQueueManager* _motionMgr;
	live2d::Live2DMotion* _idleMotion;

	int _frame;
	INT64 _prevTime;
};

#endif //BENCHMARK_MAIN_H
