/**
 *
 *  You can modify and use this source freely
 *  only for the development of application related Live2D.
 *
 *  (c) Live2D Inc. All rights reserved.
 */

#include "FileManager.h"
#include "MyLive2DAllocator.h"
#include <WICTextureLoader.h>
#include <stdio.h>
#include "type/LDString.h"


unsigned char* FileManager::loadFile(const char* filepath,int* ret_bufsize)
{
		FILE *fp; //  (1)t@C|C^̐錾
		unsigned char * buf;
	
		//  (2)t@C̃I[vBŁAt@C|C^擾
		if ( fopen_s( &fp , filepath, "rb") ) //return nonzero if error
		{
			L2D_DEBUG_MESSAGE("file open error %s!!" , filepath );
			return NULL;
		}
	
		// ------------ TCY̔ ------------
		fseek(fp, 0, SEEK_END );
		int size = ftell(fp);// TCY擾
	
		buf = (unsigned char*)malloc( size );// ̊mہiOŊJj
		L2D_ASSERT_S( buf != 0 , "malloc( %d ) is NULL @ fileload %s" , size , filepath ) ;
		
	
		fseek(fp, 0, SEEK_SET);
	
		//  ǂݍ
		int loaded = (int)fread(buf, sizeof(char), size, fp);
		fclose(fp); //  (5)t@C̃N[Y
	
		// ------------ ǂݍ߂ ------------
		if (loaded != size)
		{
			L2D_DEBUG_MESSAGE("file load error / loaded size is wrong / %d != %d\n" , loaded , size );
	
	
			return NULL;
		}
	
		*ret_bufsize = size ;
		return buf;

}


void FileManager::releaseBuffer(void* ptr)
{
	free(ptr);
}


/***********************************************************
	eNX`ǂݍ
************************************************************/
void FileManager::loadTexture(ID3D11Device* device, ID3D11DeviceContext* deviceContext, const char* textureFilePath, ID3D11ShaderResourceView** tex)
{
	WCHAR filePath[256];
	size_t len;

	// textureFilePathchar -> WCHARɕς
	mbstowcs_s(&len, filePath, textureFilePath, _TRUNCATE);

	if (FAILED(DirectX::CreateWICTextureFromFileEx(device, deviceContext, filePath, 0,
		D3D11_USAGE_DEFAULT, D3D11_BIND_SHADER_RESOURCE, 0, 0, false, NULL, tex)))
	{
		L2D_DEBUG_MESSAGE("Could not create texture \n", textureFilePath);
	}
}


/***********************************************************
	efBNg̎擾
************************************************************/
void FileManager::getParentDir( const char* path , std::string* return_dir ){
	(*return_dir) = path ;
	(*return_dir) += "\\..\\" ;

}
