/**
 *
 *  You can modify and use this source freely
 *  only for the development of application related Live2D.
 *
 *  (c) Live2D Inc. All rights reserved.
 */
#include "LAppRenderer.h"

#include "LAppLive2DManager.h"
#include "LAppModel.h"
#include "LAppDefine.h"

#include <DirectXMath.h>



LAppRenderer::LAppRenderer()
{

	// \͈͂̐ݒ
	viewMatrix.identity() ;
	viewMatrix.setMaxScale( VIEW_MAX_SCALE );// Eg嗦
	viewMatrix.setMinScale( VIEW_MIN_SCALE );// Ek

	// \łő͈
	viewMatrix.setMaxScreenRect(
			VIEW_LOGICAL_MAX_LEFT,
			VIEW_LOGICAL_MAX_RIGHT,
			VIEW_LOGICAL_MAX_BOTTOM,
			VIEW_LOGICAL_MAX_TOP
			);

	// 
	setDeviceSize( 800 , 600 ) ;// {Oݒ肷̂ŕsvݒYẴTCYŕ`悳悤ɏ
}


LAppRenderer::~LAppRenderer()
{
	
}

/***********************************************************
	Live2D`̕WIȍWn͉ʒS 0,0
	(-1,1) , E(1,-1)ƂWƂĐݒ肷
************************************************************/
void LAppRenderer::setDeviceSize( int width , int height )
{
	live2d::UtDebug::println(" set Device size : %d , %d" , width , height ) ;

	// \͈
	float ratio=(float)height/width;
	float left = VIEW_LOGICAL_LEFT;
	float right = VIEW_LOGICAL_RIGHT;
	float bottom = -ratio;
	float top = ratio;
	viewMatrix.setScreenRect(left,right,bottom,top);// foCXɑΉʂ͈̔́B X̍[, X̉E[, Ỷ[, Y̏[

	float screenW=abs(left-right);

	deviceToScreen.identity() ;
	deviceToScreen.multTranslate(-width/2.0f,-height/2.0f );
	deviceToScreen.multScale( screenW/width , -screenW/width );
}



void LAppRenderer::draw()
{
	// ʂLeft Top (-1,1) , Right Bottom (1,-1) , z = 0 ƂȂViewOLive2D`
	// ̂߂̓eϊs`
	DirectX::XMMATRIX ortho = DirectX::XMMatrixOrthographicOffCenterLH(
		viewMatrix.getScreenLeft(),
		viewMatrix.getScreenRight(),
		viewMatrix.getScreenBottom(),
		viewMatrix.getScreenTop(), -1.0f, 1.0f);
	DirectX::XMMATRIX view(viewMatrix.getArray());

	int numModels=live2DMgr->getModelNum();
	for (int i=0; i<numModels; i++)
	{
		LAppModel* model = live2DMgr->getModel(i);
		model->update();
		model->draw(view, ortho);
	}
}

void LAppRenderer::setLive2DManager(LAppLive2DManager* mgr)
{
	this->live2DMgr = mgr;
}


void LAppRenderer::scaleView(float cx,float cy,float scale)
{
	viewMatrix.adjustScale(cx,cy,scale);
}


void LAppRenderer::translateView(float shiftX,float shiftY)
{
	viewMatrix.adjustTranslate(shiftX,shiftY);
}


// }EXvX
void LAppRenderer::mousePress(int x,int y)
{
	float vx=transformDeviceToViewX( (float)x );
	float vy=transformDeviceToViewY( (float)y );

	if(LAppDefine::DEBUG_TOUCH_LOG) live2d::UtDebug::println( "mouse press / device(%4d,%4d) > logical( %5.3f , %5.3f )  @LAppRenderer#touchMove()" , x , y , vx , vy ) ;
	this->live2DMgr->tapEvent( vx , vy ) ;
}

// hbO
void LAppRenderer::mouseDrag(int x,int y)
{
	float vx=transformDeviceToViewX( (float)x );
	float vy=transformDeviceToViewY( (float)y );

	if(LAppDefine::DEBUG_TOUCH_LOG) live2d::UtDebug::println( "mouse drag / device(%4d,%4d) > logical( %5.3f , %5.3f )  @LAppRenderer#touchMove()" , x , y , vx , vy ) ;

	live2DMgr->setDrag(vx,vy);
}



void LAppRenderer::updateViewMatrix( float dx , float dy , float cx , float cy , float scale )
{
	bool isMaxScale=viewMatrix.isMaxScale();
	bool isMinScale=viewMatrix.isMinScale();
	
	// gk
	viewMatrix.adjustScale(cx, cy, scale);

	// ړ(zC[̏ꍇ͈ړ𔺂Ȃ̂0,0(Ȃ)B^b`̏ꍇ͈ړ{gɂȂj
	viewMatrix.adjustTranslate(dx, dy) ;
	
	// ʂőɂȂƂ̃Cxg
	if( ! isMaxScale)
	{
		if(viewMatrix.isMaxScale())
		{
			// ő\ɂȂɉ炩̃CxgiANVjsꍇ͂ɋLq
			if(LAppDefine::DEBUG_LOG) live2d::UtDebug::println( "max scale" ) ;
		}
	}
	// ʂŏɂȂƂ̃Cxg
	if( ! isMinScale)
	{
		if(viewMatrix.isMinScale())
		{
			// ŏ\ɂȂɉ炩̃CxgiANVjsꍇ͂ɋLq
			if(LAppDefine::DEBUG_LOG) live2d::UtDebug::println( "min scale" ) ;
		}
	}
	
}

// }EXzC[
void LAppRenderer::mouseWheel( int delta , int x , int y ){
	float x_onScreen = deviceToScreen.transformX((float)x) ;
	float y_onScreen = deviceToScreen.transformY((float)y) ;

	//float scale = delta < 0 ? 0.5f : 2.0f ; 
	float scale = delta < 0 ? 1.0f/1.4142f : 1.41421f ; 
	

	// ʂ̊gkAړ̐ݒ
	updateViewMatrix( 0 , 0 , x_onScreen , y_onScreen , scale ) ;
}



float LAppRenderer::transformDeviceToViewX(float deviceX)
{
	float screenX = deviceToScreen.transformX( deviceX );	// _WϊW擾B
	return  viewMatrix.invertTransformX(screenX);			// gAkAړ̒lB
}


float LAppRenderer::transformDeviceToViewY(float deviceY)
{
	float screenY = deviceToScreen.transformY( deviceY );	// _WϊW擾B
	return  viewMatrix.invertTransformY(screenY);			// gAkAړ̒lB
}

