/**
 *  You can modify and use this source freely
 *  only for the development of application related Live2D.
 *
 *  (c) Live2D Inc. All rights reserved.
 */
#include "PlatformManager.h"
#include "FileManager.h"
#include "util/UtDebug.h"
#include "LAppTextureDesc.h"

using namespace live2d;
using namespace live2d::framework;

PlatformManager::PlatformManager(void)
	: _device(NULL)
	, _deviceContext(NULL)
{
}


PlatformManager::~PlatformManager(void)
{
}

void PlatformManager::setGraphicsContext(ID3D11Device* device, ID3D11DeviceContext* context)
{
	_device = device;
	_deviceContext = context;
}

unsigned char* PlatformManager::loadBytes(const char* path,size_t* size)
{
	unsigned char* data=FileManager::loadFile(path ,(int *)size);
	return data;
}

void PlatformManager::releaseBytes(void* data)
{
	FileManager::releaseBuffer(data);
}

ALive2DModel* PlatformManager::loadLive2DModel(const char* path)
{
	size_t size;
	unsigned char* buf = loadBytes(path,&size);
	
	//Create Live2D Model Instance
	ALive2DModel* live2DModel = Live2DModelD3D11::loadModel(buf,(int)size);
	free(buf);
    return live2DModel;
}

L2DTextureDesc* PlatformManager::loadTexture(ALive2DModel* model, int no, const char* path)
{
	ID3D11ShaderResourceView*	texture;

	FileManager::loadTexture( _device, _deviceContext, path, &texture ) ;

	((Live2DModelD3D11*)model)->setTexture( no , texture ) ;// eNX`ƃfт
	
	LAppTextureDesc* desc=new LAppTextureDesc(texture);

	return desc;
}

void PlatformManager::log(const char* txt)
{
	UtDebug::print( txt );	
}