/*
* Live2D SDK for DirectX / SampleApp1
*
* Live2D̃TvAvP[Vł
*
* @\
* E̕ʂNbNƕ\ύXAANVs܂
* EhbOŊ̌ύX܂
* EENbNŃLN^[ύX܂B
* E'W'L[ŃEChE[hAtXN[[h؂ւ܂B
*
*  You can modify and use this source freely
*  only for the development of application related Live2D.
*
*  (c) Live2D Inc. All rights reserved.
*/

#ifndef SAMPLE_MAIN_H
#define SAMPLE_MAIN_H

#define STRICT					// ^`FbNɍsȂ
#define WIN32_LEAN_AND_MEAN		// wb_[炠܂gȂ֐Ȃ
#define WINVER        0x0600	// Windows Vistaȍ~ΉAvw
#define _WIN32_WINNT  0x0600	// 

#include <windows.h>
#include <crtdbg.h>
#include <d3d11.h>
#include "LAppRenderer.h"
#include "LAppLive2DManager.h"

// KvȃCut@C̃[h
#pragma comment(lib,"d3d11.lib")

// 萔`
const SIZE INITIAL_WINDOW_SIZE = { 1280, 720 };
LPCWSTR APP_NAME = L"SampleApp1";

const SIZE FULLSCREEN_SIZE = { 1280, 720 };

// LwTCYŃtXN[sꍇ1ɂ
#define FULLSCREEN_FIXED_RESOLUTION 0
// Live2D𗘗pꍇ1ApȂꍇ0 (fobOp)
#define ENABLE_LIVE2D 1


// O錾
namespace live2d
{
	class  Live2DModelD3D11;
}

class Application
{
public:
	static LRESULT CALLBACK wndProcWrapper(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

	Application();
	~Application();

	// EBhEvV[W
	LRESULT wndProc(HWND hWnd, UINT iMsg, WPARAM wParam, LPARAM lParam);

	// EBhȄ
	HRESULT initWindow(HINSTANCE hInstance, INT x, INT y, 
		SIZE windowSize, SIZE fullscreenSize, LPCWSTR windowName);

	// Direct3D̏
	HRESULT initGraphics();

	// Live2D̏
	HRESULT initLive2D();

	// Live2DModel𐶐
	HRESULT initModel();

	// obNobt@̏
	HRESULT initBackBuffer();

	// AvP[ṼbZ[W[v
	void mainLoop();

	// AvP[ṼC
	// t[Ă΂
	// return true: false:s
	bool appProcess();

	// foCX̏mF
	HRESULT isDeviceRemoved();

	// Direct3D̃Jos
	HRESULT recoverGraphics();

	// `揈s
	HRESULT render();

	// obNobt@̃TCYs
	HRESULT resizeBackBuffer(int width, int height);

	// EBhEƃtXN[ؑւ
	HRESULT toggleFullscreen();

	// EBhETCY̕ύXNGXg
	HRESULT requestResizeTarget(int width, int height);

	// Live2D̉s
	void destroyLive2D();

	// Live2DModelj
	void destroyModel();

	// Direct3DIuWFNgj
	void destroyGraphics();

private:
	HWND _hWnd;
	SIZE _initialWindowSize;
	SIZE _fullscreenSize;
	ID3D11Device* _device;
	ID3D11DeviceContext* _deviceContext;
	IDXGISwapChain* _swapChain;
	ID3D11RenderTargetView* _backBufferRTV;
	bool _standbyMode;

	SIZE _prevWindowSize;

	LAppRenderer* _renderer;
	LAppLive2DManager* _live2DMgr;
};

#endif //SAMPLE_MAIN_H
