/**
 * Live2D SDK for DirectX 
 *
 *  You can modify and use this source freely
 *  only for the development of application related Live2D.
 *
 *  (c) Live2D Inc. All rights reserved.
 */

#ifndef SIMPLE_MAIN_H
#define SIMPLE_MAIN_H

#include <windows.h>
#include <d3d11.h>
#include <vector>

// KvȃCut@C̃[h
#pragma comment(lib,"d3d11.lib")

// 萔`
const SIZE WINDOW_SIZE = { 800, 800 };
LPCWSTR APP_NAME = L"Simple";

// O錾
namespace live2d
{
	class Live2DModelD3D11;
}

class Application
{
public:
	static LRESULT CALLBACK wndProcWrapper(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

	Application();
	~Application();

	// EBhEvV[W
	LRESULT wndProc(HWND hWnd, UINT iMsg, WPARAM wParam, LPARAM lParam);

	// EBhȄ
	HRESULT initWindow(HINSTANCE hInstance, INT x, INT y, 
		SIZE windowSize, LPCWSTR windowName);

	// Direct3D̏
	HRESULT initGraphics();

	// Live2D̏
	HRESULT initLive2D();

	// Live2DModel𐶐
	HRESULT initModel();

	// AvP[ṼbZ[W[v
	void mainLoop();

	// AvP[ṼC
	// t[Ă΂
	void process();

	// `揈s
	void render();

	// Live2D̉s
	void destroyLive2D();

	// Live2DModelj
	void destroyModel();

	// Direct3DIuWFNgj
	void destroyGraphics();

private:
	HWND _hWnd;
	SIZE _windowSize;
	ID3D11Device* _device;
	ID3D11DeviceContext* _deviceContext;
	IDXGISwapChain* _swapChain;
	ID3D11RenderTargetView* _backBufferRTV;

	live2d::Live2DModelD3D11* live2DModel;
	std::vector<ID3D11ShaderResourceView*> _textures; // f̃eNX`
};

#endif //SIMPLE_MAIN_H
