// -*- mode:c++; indent-tabs-mode:nil; tab-width:2; -*-
//
// UssConnectionMonitor.cpp
// $Id: UssConnectionMonitor.cpp,v 1.17 2001/08/10 06:20:51 seagull Exp $
//

#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>

#include "UssCommon.h"
#include "UssFileDescriptor.h"
#include "UssConnectionMonitor.h"



bool
IUssConnectionEvent::isNeedHandleToRead() const
{
  return true;
}



bool
IUssConnectionEvent::isNeedHandleToWrite() const
{
  return true;
}


bool
IUssConnectionEvent::isNeedHandleToException() const
{
  return false;
}




void
IUssConnectionEvent::onReadSignal()
{
}



void
IUssConnectionEvent::onWriteSignal()
{
}



void
IUssConnectionEvent::onExceptionSignal()
{
  // Ǥ
  onDisconnectSignal();
}


void
IUssConnectionEvent::onConnectSignal()
{
  flushAutoDisconnectTimer();
}



void
IUssConnectionEvent::onDisconnectSignal()
{
  getFileDescriptor()->close();
}













void
UssConnectionMonitor::setupFDs(list<IUssConnectionEvent*>& lst)
{
  for (list<IUssConnectionEvent*>::iterator i = lst.begin();
       i != lst.end(); i++)
    {
      IUssConnectionEvent* conn = *i;
      UssFileDescriptor* fd = conn->getFileDescriptor();

      // Ԥ碌ν򤹤롣
      if (fd && fd->isOpened() && conn->onPrepareForWaiting())
        {
          if (conn->isNeedHandleToRead())
            FD_SET(fd->getFD(), &m_readfds);
            
          if (conn->isNeedHandleToWrite())
            FD_SET(fd->getFD(), &m_writefds);
            
          if (conn->isNeedHandleToException())
            FD_SET(fd->getFD(), &m_exceptfds);
        }
    }
}


void 
UssConnectionMonitor::dispatchEvent(list<IUssConnectionEvent*>& lst)
{
  for (list<IUssConnectionEvent*>::iterator i = lst.begin();
       i != lst.end(); i++)
    {
      IUssConnectionEvent* conn = *i;
      UssFileDescriptor* fd = conn->getFileDescriptor();

      if (fd->isOpened())
        {
          try
            {
              //
              // ƥ٥Ȥȯ򸡽Фƥǥѥåޤ
              // NOTE: ٥ȥϥɥ close ǽΤǡ
              //       åɬפޤ
              if (fd->isOpened() && conn->isNeedHandleToRead() && FD_ISSET(fd->getFD(), &m_readfds) )
                  conn->onReadSignal();
              if (fd->isOpened() && conn->isNeedHandleToWrite() && FD_ISSET(fd->getFD(), &m_writefds) )
                conn->onWriteSignal();
              if (fd->isOpened() && conn->isNeedHandleToException() && FD_ISSET(fd->getFD(), &m_exceptfds) )
                conn->onExceptionSignal();
            }
          catch (EUssException* e)
            {
              e->report();
              delete e;
            }
        }
    }
}


int
UssConnectionMonitor::WaitForEvent(bool autodispatch/*=true*/)
{
  struct timeval tv(m_Timeout);
  getTimeout(&tv);

  FD_ZERO(&m_readfds);
  FD_ZERO(&m_writefds);
  FD_ZERO(&m_exceptfds);


  //
  // ϿƤ³ˤĤԤ碌
  //
  setupFDs(m_listConnections);


  //
  // ϿƤ륵ФդԤ碌
  //
  for (list<UssServerSocketConnectionEvent*>::iterator i = m_listServers.begin();
       i != m_listServers.end(); i++)
    {
      UssServerSocketConnectionEvent* server = *i;
      FD_SET(server->getSocket()->getFD(), &m_readfds);

      // Фտ路Ƥ³סˤĤԤ碌
      setupFDs(server->m_listClients);
    }

  int result = ::select(FD_SETSIZE,
                        &m_readfds, &m_writefds, &m_exceptfds, &tv);
  if (result < 0)
    { // error occured
      if (errno == EINTR)
        return result;
      throw new EUssOSError();
    }
  else if (result == 0)
    return 0; // timed out


  //
  // ưǥѥå׵ᤵƤ(ǥե)
  // ưŪƤ ConnectionEvent Фƥ٥ȤΤޤ
  //
  if (autodispatch)
    {
      dispatchEvent(m_listConnections);

      // ϿƤ륵Фդƥǥѥå
      for (list<UssServerSocketConnectionEvent*>::iterator i = m_listServers.begin();
           i != m_listServers.end(); i++)
        {
          UssServerSocketConnectionEvent* p = *i;
          if (FD_ISSET(p->getSocket()->getFD(), &m_readfds))
            {
              try
                {
                  p->onConnectSignal();
                }
              catch (EUssException* e)
                {
                  e->report();
                  delete e;
                }
            }

          dispatchEvent(p->m_listClients);
        }
    }

  return result;
}



bool
IUssConnectionEvent::onPrepareForWaiting()
{
  if (m_nTimeup > 0)
    {
      /*
        ưǥޤꤵƤС򸡺
        ưǤ
       */
      timeval tv, tvtimeup;

      ::gettimeofday(&tv, NULL);
      if (tv.tv_sec == 0 && tv.tv_usec == 0)
        {
          m_tvLast.tv_sec = tv.tv_sec;
          m_tvLast.tv_usec = tv.tv_usec;
          return true;
        }
      tvtimeup.tv_sec = m_tvLast.tv_sec + m_nTimeup / 1000;
      tvtimeup.tv_usec = m_tvLast.tv_usec + (m_nTimeup % 1000) * 1000;

      if (tvtimeup.tv_usec >= 1000000)
        {
          tvtimeup.tv_sec += tvtimeup.tv_usec / 1000000;
          tvtimeup.tv_usec %= 1000000;
        }

      if (tv.tv_sec > tvtimeup.tv_sec ||
          (tv.tv_sec == tvtimeup.tv_sec && tv.tv_usec > tvtimeup.tv_usec) )
        {
          onDisconnectSignal();
          return false;
        }
    }
  
  return true;
}



void
UssConnectionMonitor::closeAll()
{
  for (list<UssServerSocketConnectionEvent*>::iterator i = m_listServers.begin();
       i != m_listServers.end(); i++)
  {
    (*i)->closeAllClients();
    (*i)->close();
  }

  for (list<IUssConnectionEvent*>::iterator i = m_listConnections.begin();
       i != m_listConnections.end(); i++)
    (*i)->close();
}

