// -*- mode:c++; indent-tabs-mode:nil; tab-width:2; -*-
//
// Exception.h
// $Id: UssException.h,v 1.13 2001/09/08 07:47:16 seagull Exp $
//

#if !defined(USS_H_Exception)
#define USS_H_Exception

#include <stdlib.h>
#include <sys/time.h>
#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>

#include <memory.h>
#include <exception>


/**
   Uss饤֥꤬㳰饹κ쥯饹Ǥ

   㳰ˤϡϢ륪֥ȤݻǤޤ
 */
class EUssException : public exception
{
public:
  /**
     EUssException ֥Ȥۤޤ

     @param  obj 㳰˴Ϣ֥
   */
  EUssException(void* obj = NULL);

  /**
     ֥ȤθԤޤ
   */
  virtual ~EUssException();


  /**
     ǥХååޤ

     @return
     åʸᤵݥ󥿤ХåեؤƤޤ
     ɬפǤХԡƤ
   */
  virtual char const* getDebugMessage()
  {
    return getErrorMessage();
  }

  /**
     åޤ

     @return
     åʸᤵݥ󥿤ХåեؤƤޤ
     ɬפǤХԡƤ
   */
  virtual char const* getLogMessage()
  {
    return getErrorMessage();
  }


  /**
     顼åޤ

     @return
     åʸᤵݥ󥿤ХåեؤƤޤ
     ɬפǤХԡƤ
   */
  virtual char const* getErrorMessage()
  {
    return what();
  }

  /**
     㳰줿(̾ΤƱ)ޤ

     @return 㳰줿
   */
  struct timeval const& getRaisedTime() const
  {
    return m_RaisedTime;
  }

  /**
     㳰Ƥ򼨤ʸޤ

     @return
     åʸᤵݥ󥿤ХåեؤƤޤ
     ɬפǤХԡƤ
   */
  virtual char const* what();


  /**
     㳰˴Ϣդ줿֥ȤؤΥݥ󥿤ޤ

     @return ֥ȤؤΥݥ󥿡
              ɬפ˱ƥ㥹ȤƤ
   */
  void* getObject() const
  {
    return m_pObj;
  }

  
  /**
     㳰˴Ϣդ줿֥ȤؤΥݥ󥿤ޤ

     @return ֥ȤؤΥݥ󥿡
             ƥץ졼ȤǤΤǡꤵ줿˥㥹Ȥᤵޤ
   */
  template <typename T>
  T getObject() const
  {
    return reinterpret_cast<T>(m_pObj);
  }


  /**
     顼å (getErrorMessage)򥹥ȥ꡼ؽϤޤ

     @param fp  Ϥ륹ȥ꡼
   */
  int report(FILE* fp = stderr);

protected:
  /// 㳰()줿
  struct timeval m_RaisedTime;
  /// 㳰˴Ϣդ줿֥
  void* m_pObj;
};





/**
   OS٥Υ顼ɽ㳰饹
   顼ɤȤƤϡC errorno 򰷤ޤ
 */
class EUssOSError : public EUssException
{
public:
  /**
     ֥Ȥۤޤ
     @param error    顼
     @param obj      㳰˴Ϣդ륪֥
   */
  EUssOSError(int error, void* obj = NULL)
    : EUssException(obj)
  {
    m_errno = error;
  }

  /**
     ֥Ȥۤޤ
     顼ɤˤϡߤerrornoѤޤ
     @param obj      㳰˴Ϣդ륪֥
   */
  EUssOSError(void* obj = NULL)
    : EUssException(obj)
  {
    m_errno = errno;
  }

  /**
     顼ɤбʸᤷޤ
   */
  virtual char const* what()
  {
    return strerror(m_errno);
  }

  /**
     㳰˴Ϣդ顼 errorno ᤷޤ
   */
  int getErrorno() const { return m_errno; }

protected:
  int m_errno;
};



/**
   UssǡĤʤ(Ƥʤ)Ԥä
   򼨤㳰饹Ǥ
 */
class EUssBadOperation : EUssException
{
public:
  /**
     ֥Ȥۤޤ
     @param obj      㳰˴Ϣդ륪֥
   */
  EUssBadOperation(void* p)
    : EUssException(p)
  {
  }
};

#endif
// EOF
