// -*- mode:c++; indent-tabs-mode:nil; tab-width:2; -*-
//
// UssIOBuffer.h
// $Id: UssIOBuffer_Null.cpp,v 1.3 2001/07/19 15:11:59 seagull Exp $
//

#include "UssCommon.h"
#include "UssIOBuffer.h"



int
UssIOBuffer_Null::read(void* buf, int len)
{
  return 0;
}

int
UssIOBuffer_Null::write(void const* buf, int len)
{
  return len;
}


size_t
UssIOBuffer_Null::getBufferSize() const
{
  return 0;
}



size_t
UssIOBuffer_Null::getFreeSize() const
{
  return 0;
}



size_t
UssIOBuffer_Null::getUsedSize() const
{
  return 0;
}


bool
UssIOBuffer_Null::isEmpty() const
{
  return false;
}


bool
UssIOBuffer_Null::isFull() const
{
  return true;
}

int
UssIOBuffer_Null::flush()
{
  testRedirected();
  return 0;
}


int
UssIOBuffer_Null::fetch()
{
  testRedirected();
  
  // ³褫ɤ߼ΤƤޤ
  char tmp[512];
  return getRedirectTo()->read(tmp, 512);
}

bool
UssIOBuffer_Null::lookAhead(int offset, uint8_t* p)
{
  return false;
}
