// -*- mode:c++; indent-tabs-mode:nil; tab-width:2; -*-
//
// $Id: UssIOBuffer_Slide.cpp,v 1.10 2001/07/19 15:11:59 seagull Exp $
//

#include <string.h>
#include <stdlib.h>
#include <memory.h>

#include "UssCommon.h"
#include "UssIOBuffer.h"


int
UssIOBuffer_Slide::read(void* buf, int len)
{
  if ((size_t)len > getUsedSize())
    len = m_pWritePtr - m_pBuffer;

  memcpy(buf, m_pBuffer, len);
  
  if ((size_t)len < getUsedSize())
    memcpy(m_pBuffer, m_pBuffer + len, getUsedSize() - len);
    
  m_pWritePtr -= len;
    
  return len;
}



int
UssIOBuffer_Slide::write_impl(void const* buf, int len)
{
  if (getFreeSize() < (size_t)len)
    {
      throw new EUssIOBufferOverflow(this);
      return 0;
    }

  int n = m_pBufferTail - m_pWritePtr;
  if (n > len) n = len;

  memcpy(m_pWritePtr, buf, n);
  m_pWritePtr += n;
  return n;
}



int
UssIOBuffer_Slide::flush()
{
  testRedirected();  // raise error if not redirected

  int n = getRedirectTo()->write(m_pBuffer, getUsedSize());

  //
  // ;äʬХåեƬإ饤ɤ
  //
  if (n > 0)
    {
      memcpy(m_pBuffer, m_pBuffer + n, getUsedSize() - n);
      m_pWritePtr -= n;
    }
  return n;
}


int
UssIOBuffer_Slide::fetch()
{
  testRedirected(); // raise error if not redirected

  int n = getFreeSize();
  if (n > 0)
    {
      n = getRedirectTo()->read(m_pWritePtr, n);
      if (n > 0)
        {
          m_pWritePtr += n;

          if (getEventListener() != NULL)
            getEventListener()->onWrite(this, n);
        }
    }

  return n;
}




bool
UssIOBuffer_Slide::lookAhead(int offset, uint8_t* p)
{
  if (m_pWritePtr <= m_pBuffer + offset)
    return false;
  *p = *(m_pBuffer + offset);
  return true;
}


