// -*- mode:c++; indent-tabs-mode:nil; tab-width:2; -*-
//
// $Id: UssPacketCracker_Ref.cpp,v 1.2 2001/07/23 09:01:59 seagull Exp $
//


#include "UssCommon.h"
#include "UssIOBuffer.h"


void
UssPacketCracker_Ref::onWrite(UssIOBufferBase* buffer, int /*len*/)
{
  uint8_t c;

  // ʸФ֥롼
  for (;;)
    {
      // Ĺեɤɤߤޤ
      uint32_t length = 0;
      for (uint n = 0; n < getSize(); n++)
        {
          if (! buffer->lookAhead(m_nOffset + n, &c))
            return ; // Ĺեɤ夷Ƥʤ

          if (isLittleEndian())
            length |= (uint32_t)c << (n * 8);
          else
            length = (length << 8) | c;
        }

      // ĥΰ(ꤵƤͤ¾ɬפʥ)̣ޤ
      length += getExtra();

      // ʤȤĹȽΤǡХåեˤĹ
      if (buffer->getUsedSize() < length)
        return; // ­Ƥʤ

      dispatchOnPacket(buffer, length); // 򸡽
    }
}


