// -*- mode:c++; indent-tabs-mode:nil; tab-width:2; -*-
//
// $Id: UssSerialPort.cpp,v 1.3 2001/08/10 04:16:29 seagull Exp $
//

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <termios.h>

#include "UssSerialPort.h"

int
UssSerialPort::open(char const* device,
                    int baudrate, parity_t parity, flowctrl_t flow,
                    bool blocal, uint databit, bool stop2)
{
  m_curtio.c_iflag = IGNBRK;
  if (parity != PAR_NONE) m_curtio.c_iflag |= IGNPAR | INPCK;
  if (flow == FLOW_XONOFF) m_curtio.c_iflag |= IXON | IXOFF;

  m_curtio.c_oflag = 0;

  speed_t speed;
  switch (baudrate)
    {
    default: throw new EUssBadBaudRate(this);
    case 9600: speed = B9600; break;
    case 19200: speed = B19200; break;
    case 38400: speed = B38400; break;
    }
  m_curtio.c_cflag = speed
    | HUPCL
    | CREAD
    | (stop2? CSTOPB : 0)
    | (blocal? CLOCAL : 0)
    | ((flow == FLOW_HW)? CRTSCTS : 0)
    ;

  switch (databit)
    {
    default: throw new EUssBadDataBit(this);
    case 5: m_curtio.c_cflag |= CS5; break;
    case 6: m_curtio.c_cflag |= CS6; break;
    case 7: m_curtio.c_cflag |= CS7; break;
    case 8: m_curtio.c_cflag |= CS8; break;
    }

  switch (parity)
    {
    case PAR_ODD:   m_curtio.c_cflag |= PARODD; // fall tough 
    case PAR_EVEN:  m_curtio.c_cflag |= PARENB;
    default:
      break;
    }
  ::cfsetispeed(&m_curtio, speed);
  ::cfsetospeed(&m_curtio, speed);


  UssFileDescriptor::open(device, O_RDWR | O_NOCTTY | O_NONBLOCK);

  if (::tcflush(getFD(), TCIOFLUSH) < 0 ||
      ::tcgetattr(getFD(), &m_oldtio) < 0 ||
      ::tcsetattr(getFD(), TCSANOW, &m_curtio) < 0)
    {
      close();
      throw new EUssOSError();
    }
  
  // NOBLOCK
  ::fcntl(getFD(), F_SETFL, 0);

  return getFD();
}

