// -*- mode:c++; indent-tabs-mode:nil; tab-width:2; -*-
//
// $Id: UssServerSocketConnectionEvent.cpp,v 1.3 2001/08/06 04:44:21 seagull Exp $
//

#include "UssConnectionMonitor.h"


UssServerSocketConnectionEvent::~UssServerSocketConnectionEvent()
{
  if (m_Socket.isOpened())
    m_Socket.close();

  clearPool();
}




//
// 饤Ȥ³򸡽ФΤǡѲǽʥ饤ȥå
// 򸡺ơ³Ĥޤ
//
void
UssServerSocketConnectionEvent::onConnectSignal()
{
  // ̤Ѥ³õ
  for (list<IUssConnectionEvent *>::iterator i = m_listClients.begin();
       i != m_listClients.end(); i++)
    {
      IUssConnectionEvent* p = *i;
      if (! p->getFileDescriptor()->isOpened())
        {
          UssSocket* sock = dynamic_cast<UssSocket*>(p->getFileDescriptor());
          if (sock == NULL)
            throw new EUssBadConnectionPool(); // UssSocket Ǥʤ
          else
            { // ³դơUssSocket֥Ȥ˳Ƥ롣
              m_Socket.accept(sock);
              p->onConnectSignal(); // onConnectSignal ȯ
            }

          break ;
        }
    }
}



void
UssServerSocketConnectionEvent::clearPool()
{
  for (set<IUssConnectionEvent*>::iterator i = m_CreatedClients.begin();
       i != m_CreatedClients.end(); i++)
    delete *i;
  
  m_listClients.clear();
  m_CreatedClients.clear();
}



void
UssServerSocketConnectionEvent::removeSession(IUssConnectionEvent* p)
{
  m_listClients.remove(p);
  
  set<IUssConnectionEvent*>::iterator i = m_CreatedClients.find(p);
  if (i != m_CreatedClients.end())
  {
    m_CreatedClients.erase(i);
    delete p;
  }
}



void
UssServerSocketConnectionEvent::close()
{
  if (m_Socket.isOpened())
    m_Socket.close();
}

void
UssServerSocketConnectionEvent::closeAllClients()
{
  for (list<IUssConnectionEvent*>::iterator i = m_listClients.begin();
       i != m_listClients.end(); i++)
    (*i)->close();
}

