// -*- mode:c++; indent-tabs-mode:nil; tab-width:2; -*-
//
// $Id: UssTimerEvent.cpp,v 1.5 2001/07/25 08:47:08 seagull Exp $
//

#include <algorithm>

#include "UssCommon.h"
#include "UssTimerEvent.h"


void
UssTimerEvent::start(timerstate_t type, int interval = -1)
{
  if (interval > 0)
    m_nInterval = interval;
  
  m_state = type;
  ::gettimeofday(&m_starttime, NULL);
  
  m_timeuptime = m_starttime;
  m_timeuptime.tv_usec += m_nInterval * 1000;
  if (m_timeuptime.tv_usec >= 1000000l)
    {
      m_timeuptime.tv_sec += m_timeuptime.tv_usec / 1000000l;
      m_timeuptime.tv_usec %= 1000000l;
    }
}





void 
UssTimerEvent::pump()
{
  if (m_state == TE_STOP) // ϤƤʤ
    return ;
  
  timeval tv;
  ::gettimeofday(&tv, NULL);
  
  if (tv.tv_sec > m_timeuptime.tv_sec ||
      (tv.tv_sec > m_timeuptime.tv_sec && tv.tv_usec > m_timeuptime.tv_usec) )
    { // ȥꥬ
      
      // ξϺƵưƤޤ
      if (m_state == TE_CYCLE || m_state == TE_CLOCK)
        {
          // ֳ֤狼ˤäơ׻
          m_starttime = (m_state == TE_CLOCK)? m_timeuptime : tv;
          
          m_timeuptime = m_starttime;
          m_timeuptime.tv_usec += m_nInterval * 1000;
          if (m_timeuptime.tv_usec >= 1000000l)
            {
              m_timeuptime.tv_sec += m_timeuptime.tv_usec / 1000000l;
              m_timeuptime.tv_usec %= 1000000l;
            }
        }
      
      // ٥Ȥȥꥬޤ
      onTimerSignal();

      // ñȯޤǤС¨¤
      if (m_state == TE_TIMER)
        m_state = TE_STOP;
    }
}




UssTimerEventMonitor::UssTimerEventMonitor()
{
}



UssTimerEventMonitor::~UssTimerEventMonitor()
{
}


template<typename T>
void pumpTimer(T* p)
{
  p->pump();
}

void
UssTimerEventMonitor::pump()
{
  for_each(m_events.begin(), m_events.end(), pumpTimer<UssTimerEvent>);
}

