############################################################
# Copyright (C) 2008 Masahiko SAWAI All Rights Reserved. 
############################################################

# 1 : enable force feedback
# 2 : disable force feedback
# A + B : quit

require 'wiiremote'

WRMT::init()

num = WRMT::num_wiiremote
if num == 0 then
	puts "No WiiRemote found."
	exit
end

WRMT::wiiremotes.each(){ |wiiremote|
	wiiremote.open()
}

done = false
until done do
	while (updated_index = WRMT::poll()) >= 0 do
		wiiremote = WRMT::wiiremotes[updated_index]
		if wiiremote.check_button_any(WRMT::MASK_BUTTON_ONE|WRMT::MASK_BUTTON_TWO) then
			f = wiiremote[WRMT::DATA_FORCE_FEEDBACK]
			if f == 0 and wiiremote.check_button(WRMT::MASK_BUTTON_ONE) then
				wiiremote[WRMT::DATA_FORCE_FEEDBACK] = 1;
			elsif f == 1 and wiiremote.check_button(WRMT::MASK_BUTTON_TWO) then
				wiiremote[WRMT::DATA_FORCE_FEEDBACK] = 0;
			end
		end

		done = true if wiiremote.check_button_all(WRMT::MASK_BUTTON_A|WRMT::MASK_BUTTON_B)
	end
	sleep(0.03);
end

WRMT::quit()
