############################################################
# Copyright (C) 2008 Masahiko SAWAI All Rights Reserved. 
############################################################

# + : led += 1
# - : led -= 1
# A + B : quit

require 'wiiremote'

WRMT::init()

num = WRMT::num_wiiremote
if num == 0 then
	puts "No WiiRemote found."
	exit
end

WRMT::wiiremotes.each(){ |wiiremote|
	wiiremote.open()
}

done = false
until done do
	while (updated_index = WRMT::poll()) >= 0 do
		wiiremote = WRMT::wiiremotes[updated_index]
		if wiiremote.check_button_any(WRMT::MASK_BUTTON_PLUS|WRMT::MASK_BUTTON_MINUS) then
			led = wiiremote[WRMT::DATA_LEDS]
			led += 1 if wiiremote.check_button(WRMT::MASK_BUTTON_PLUS)
			led -= 1 if wiiremote.check_button(WRMT::MASK_BUTTON_MINUS) 
			if led < 0 then
				led = 0
			elsif led > 0x0f then
				led = 0x0f
			end
			wiiremote[WRMT::DATA_LEDS] = led;
		end

		done = true if wiiremote.check_button_all(WRMT::MASK_BUTTON_A|WRMT::MASK_BUTTON_B)
	end
	sleep(0.03);
end

WRMT::quit()
