############################################################
# Copyright (C) 2008 Masahiko SAWAI All Rights Reserved. 
############################################################

require 'wiiremote'

WRMT::init()

num = WRMT::num_wiiremote
if num == 0 then
	puts "No WiiRemote found."
	exit
end

WRMT::wiiremotes.each(){ |wiiremote|
	wiiremote.open()
	wiiremote.set_enabled(WRMT::FUNCTION_MOTION, true)
}

done = false
until done do
	while (updated_index = WRMT::poll()) >= 0 do
		wiiremote = WRMT::wiiremotes[updated_index]
		printf("[%d] : x:%d, y:%d, z:%d\n",
			updated_index,
			wiiremote[WRMT::DATA_MOTION_X],
			wiiremote[WRMT::DATA_MOTION_Y],
			wiiremote[WRMT::DATA_MOTION_Z])
		done = true if wiiremote.check_button_all(WRMT::MASK_BUTTON_A|WRMT::MASK_BUTTON_B)
	end
	sleep(0.03);
end

WRMT::quit()
