############################################################
# Copyright (C) 2008 Masahiko SAWAI All Rights Reserved. 
############################################################
MANUAL = <<EOD
button state viewer
A + B : exit program.
EOD

require 'wiiremote'

WRMT::init()

num = WRMT::num_wiiremote
if num == 0 then
	puts "No WiiRemote found."
	exit
end

WRMT::wiiremotes.each(){ |wiiremote|
	wiiremote.open()
}

print MANUAL

done = false
until done do
	while (updated_index = WRMT::poll()) >= 0 do
		wiiremote = WRMT::wiiremotes[updated_index]
		button_state = wiiremote[WRMT::DATA_BUTTONS]
		printf("[%d] : 2:%s, 1:%s, B:%s, A:%s, -:%s, H:%s, L:%s, R:%s, D:%s, U:%s, +:%s\n",
			updated_index,
			((button_state & WRMT::MASK_BUTTON_TWO) != 0),
			((button_state & WRMT::MASK_BUTTON_ONE) != 0),
			((button_state & WRMT::MASK_BUTTON_B) != 0),
			((button_state & WRMT::MASK_BUTTON_A) != 0),
			((button_state & WRMT::MASK_BUTTON_MINUS) != 0),
			((button_state & WRMT::MASK_BUTTON_HOME) != 0),
			((button_state & WRMT::MASK_BUTTON_LEFT) != 0),
			((button_state & WRMT::MASK_BUTTON_RIGHT) != 0),
			((button_state & WRMT::MASK_BUTTON_DOWN) != 0),
			((button_state & WRMT::MASK_BUTTON_UP) != 0),
			((button_state & WRMT::MASK_BUTTON_PLUS) != 0)
		)
#		done = true if wiiremote.check_button_all(WRMT::MASK_BUTTON_A|WRMT::MASK_BUTTON_B)
		done = true if  wiiremote.check_button_all("AB")
	end
	sleep(0.03);
end

WRMT::quit()
