############################################################
# Copyright (C) 2008 Masahiko SAWAI All Rights Reserved. 
############################################################
MANUAL = <<EOD
force feedback test
1 : enable force feedback
2 : disable force feedback
A + B : quit
EOD

require 'wiiremote'

WRMT::init()

num = WRMT::num_wiiremote
if num == 0 then
	puts "No WiiRemote found."
	exit
end

WRMT::wiiremotes.each(){ |wiiremote|
	wiiremote.open()
}
print MANUAL

done = false
until done do
	while (updated_index = WRMT::poll()) >= 0 do
		wiiremote = WRMT::wiiremotes[updated_index]
		if wiiremote.check_button_any(WRMT::MASK_BUTTON_ONE|WRMT::MASK_BUTTON_TWO) then
			f = wiiremote[WRMT::DATA_FORCE_FEEDBACK]
			if f == 0 and wiiremote.check_button(WRMT::MASK_BUTTON_ONE) then
				f = 1
			elsif f == 1 and wiiremote.check_button(WRMT::MASK_BUTTON_TWO) then
				f = 0
			end
			wiiremote[WRMT::DATA_FORCE_FEEDBACK] = f;
			wiiremote.update()
		end
		done = true if wiiremote.check_button_all("AB")
	end
	sleep(0.03);
end

WRMT::quit()
