############################################################
# Copyright (C) 2008 Masahiko SAWAI All Rights Reserved. 
############################################################
MANUAL = <<EOD
motion sensor state viewer
A + B : exit program.
EOD

require 'wiiremote'

WRMT::init()

num = WRMT::num_wiiremote
if num == 0 then
	puts "No WiiRemote found."
	exit
end

WRMT::wiiremotes.each(){ |wiiremote|
	wiiremote.open()
	wiiremote.motion = true;
	wiiremote.update()
}

print MANUAL

done = false
until done do
	while (updated_index = WRMT::poll()) >= 0 do
		wiiremote = WRMT::wiiremotes[updated_index]
		printf("[%d] : x:%d, y:%d, z:%d\n",
			updated_index,
			wiiremote.motion_x,
			wiiremote.motion_y,
			wiiremote.motion_z)
		done = true if wiiremote.check_button_all("AB")
	end
	sleep(0.03);
end

WRMT::quit()
