############################################################
# Copyright (C) 2008 Masahiko SAWAI All Rights Reserved. 
############################################################

require 'wiiremote'

class SpeakerTest
	include WRMT
	SOUND_DATA = "<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<"

	def initialize
		@wiiremote = nil
		@done = false
	end

	attr :done

	def init_wiiremote
		if num_wiiremote == 0 then
			raise "No WiiRemote found."
		end

		@wiiremote = wiiremotes[0]
		@wiiremote.open();
		@wiiremote.continuous = true;
		@wiiremote.speaker = true;
		@wiiremote[DATA_SPEAKER_FORMAT] = 0
		@wiiremote[DATA_SPEAKER_SAMPLE_RATE] = 0x11
		@wiiremote[DATA_SPEAKER_VOLUME] = 4
		@wiiremote.update()
	end

	def main_loop
		until @done do
			update_all()

			# change volume
			if @wiiremote.check_button_any("UD") then
				volume = @wiiremote[DATA_SPEAKER_VOLUME]
				volume -= 1 if @wiiremote.check_button("D") 
				volume += 1 if @wiiremote.check_button("U") 
				if volume < 0 then
					volume = 0
				elsif volume > 0xff then
					volume = 0xff
				end
				puts "volume : #{volume}"
				@wiiremote[DATA_SPEAKER_VOLUME] = volume
			end
			
			# change sample rate
			if @wiiremote.check_button_any("LR") then
				rate = @wiiremote[DATA_SPEAKER_SAMPLE_RATE]
				rate -= 1 if @wiiremote.check_button("L") 
				rate += 1 if @wiiremote.check_button("R") 
				if rate < 0 then
					rate = 0
				elsif rate > 0xff then
					rate = 0xff
				end
				puts "rate : #{rate}"
				@wiiremote[DATA_SPEAKER_SAMPLE_RATE] = rate
			end

			# play sound
			if @wiiremote.check_button("A") then
				@wiiremote.play_sound(SOUND_DATA, 0, SOUND_DATA.length)
			end
			
			# quit 
			if @wiiremote.check_button_all("AB") then
				@done = true
			end

			sleep(0.03);
		end
	end
end

if $0 == __FILE__ then
	WRMT::init()
	begin
		app = SpeakerTest::new
		app.init_wiiremote()
		app.main_loop()
	ensure
		puts "WRMT::quit()"
		WRMT::quit()
	end
end

